/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.cxf.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wssecurity.cxf.validator.Utils;
import java.security.Principal;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.cxf.ws.security.wss4j.WSS4JTokenConverter;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.cache.ReplayCache;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.apache.ws.security.processor.UsernameTokenProcessor;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UsernameTokenInterceptor
extends org.apache.cxf.ws.security.wss4j.UsernameTokenInterceptor {
    protected static final TraceComponent tc = Tr.register(UsernameTokenInterceptor.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    static final long serialVersionUID = 3217700443631337574L;

    protected WSUsernameTokenPrincipal getPrincipal(@Sensitive Element tokenElement, final @Sensitive SoapMessage message) throws WSSecurityException {
        ReplayCache replayCache = Utils.getReplayCache(message, "ws-security.enable.nonce.cache", "ws-security.nonce.cache.instance");
        boolean bspCompliant = this.isWsiBSPCompliant(message);
        boolean utWithCallbacks = MessageUtils.getContextualBoolean((Message)message, (String)"ws-security.validate.token", (boolean)true);
        if (utWithCallbacks) {
            UsernameTokenProcessor p = new UsernameTokenProcessor();
            WSDocInfo wsDocInfo = new WSDocInfo(tokenElement.getOwnerDocument());
            RequestData data = new RequestData(){
                static final long serialVersionUID = -3153756028932700157L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public CallbackHandler getCallbackHandler() {
                    return UsernameTokenInterceptor.this.getCallback(message);
                }

                public Validator getValidator(QName qName) throws WSSecurityException {
                    Object validator = message.getContextualProperty("ws-security.ut.validator");
                    if (validator == null) {
                        return super.getValidator(qName);
                    }
                    return (Validator)validator;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
                }
            };
            data.setWssConfig(WSSConfig.getNewInstance());
            data.setNonceReplayCache(replayCache);
            data.setMsgContext((Object)message);
            this.translateSettingsFromMsgContext(data, message);
            List results = p.handleToken(tokenElement, data, wsDocInfo);
            this.checkTokens(message, results);
            return (WSUsernameTokenPrincipal)((WSSecurityEngineResult)results.get(0)).get((Object)"principal");
        }
        WSUsernameTokenPrincipal principal = this.parseTokenAndCreatePrincipal(tokenElement, bspCompliant);
        WSS4JTokenConverter.convertToken((Message)message, (Principal)principal);
        return principal;
    }

    /*
     * WARNING - void declaration
     */
    private CallbackHandler getCallback(@Sensitive SoapMessage message) {
        Object o = message.getContextualProperty("ws-security.callback-handler");
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), ((Object)((Object)this)).getClass()).newInstance();
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wssecurity.cxf.interceptor.UsernameTokenInterceptor", (String)"112", (Object)((Object)this), (Object[])objectArray);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception while getCallback handler :" + e), (Object[])new Object[0]);
                }
                handler = null;
            }
        }
        return handler;
    }

    protected WSSecUsernameToken addUsernameToken(@Sensitive SoapMessage message, @Sensitive UsernameToken token) {
        String userName = (String)message.getContextualProperty("ws-security.username");
        WSSConfig wssConfig = (WSSConfig)message.getContextualProperty(WSSConfig.class.getName());
        if (wssConfig == null) {
            wssConfig = WSSConfig.getNewInstance();
        }
        if (!StringUtils.isEmpty((String)userName)) {
            if (token.isNoPassword()) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken(wssConfig);
                utBuilder.setUserInfo(userName, null);
                utBuilder.setPasswordType(null);
                if (token.isRequireCreated() && !token.isHashPassword()) {
                    utBuilder.addCreated();
                }
                if (token.isRequireNonce() && !token.isHashPassword()) {
                    utBuilder.addNonce();
                }
                return utBuilder;
            }
            String password = (String)message.getContextualProperty("ws-security.password");
            if (StringUtils.isEmpty((String)password)) {
                password = this.getPassword(userName, token, 2, message);
            }
            if (!StringUtils.isEmpty((String)password)) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken(wssConfig);
                if (token.isHashPassword()) {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
                } else {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                }
                utBuilder.setUserInfo(userName, password);
                if (token.isRequireCreated() && !token.isHashPassword()) {
                    utBuilder.addCreated();
                }
                if (token.isRequireNonce() && !token.isHashPassword()) {
                    utBuilder.addNonce();
                }
                return utBuilder;
            }
            this.policyNotAsserted(token, "No username available", message);
        } else {
            this.policyNotAsserted(token, "No username available", message);
        }
        return null;
    }

    public boolean checkTokens(@Sensitive SoapMessage message, List<WSSecurityEngineResult> utResults) throws WSSecurityException {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        Collection ais = aim.getAssertionInfo(SP12Constants.USERNAME_TOKEN);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ais in checkTokens is '" + ais + "'"), (Object[])new Object[0]);
        }
        UsernameToken usernameTokenPolicy = null;
        Object[] aiArray = ais.toArray();
        AssertionInfo ai = null;
        if (aiArray.length > 0) {
            ai = (AssertionInfo)aiArray[0];
            usernameTokenPolicy = (UsernameToken)ai.getAssertion();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ai in checkTokens is '" + ai + "'"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("usernameTokenPolicy is '" + usernameTokenPolicy + "'"), (Object[])new Object[0]);
        }
        boolean bOk = true;
        LinkedHashSet<String> msgs = new LinkedHashSet<String>();
        for (WSSecurityEngineResult result : utResults) {
            String strErr;
            org.apache.ws.security.message.token.UsernameToken usernameToken = (org.apache.ws.security.message.token.UsernameToken)result.get((Object)"username-token");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("usernameToken is '" + usernameToken + "'"), (Object[])new Object[0]);
            }
            if (usernameTokenPolicy.isHashPassword() != usernameToken.isHashed()) {
                strErr = "Password hashing policy not enforced";
                msgs.add(strErr);
                bOk = false;
            }
            if (usernameTokenPolicy.isNoPassword() && usernameToken.getPassword() != null) {
                strErr = "Username Token NoPassword policy not enforced";
                msgs.add(strErr);
                bOk = false;
            }
            if (usernameTokenPolicy.isRequireCreated() && (usernameToken.getCreated() == null || usernameToken.isHashed())) {
                strErr = "Username Token Created policy not enforced";
                msgs.add(strErr);
                bOk = false;
            }
            if (!usernameTokenPolicy.isRequireNonce() || usernameToken.getNonce() != null && !usernameToken.isHashed()) continue;
            strErr = "Username Token Nonce policy not enforced";
            msgs.add(strErr);
            bOk = false;
        }
        if (!bOk) {
            throw new WSSecurityException(((Object)msgs).toString());
        }
        return true;
    }

    void translateSettingsFromMsgContext(RequestData reqData, @Sensitive SoapMessage message) {
        WSSConfig wssConfig = reqData.getWssConfig();
        if (wssConfig == null) {
            wssConfig = WSSConfig.getNewInstance();
        }
        wssConfig.setUtTTL(this.decodeTimeToLive(reqData, message));
        wssConfig.setUtFutureTTL(this.decodeFutureTimeToLive(reqData, message));
        reqData.setWssConfig(wssConfig);
    }

    /*
     * WARNING - void declaration
     */
    public int decodeTimeToLive(RequestData reqData, @Sensitive SoapMessage message) {
        String ttl = (String)message.getContextualProperty("ws-security.timestamp.timeToLive");
        int ttlI = 0;
        if (ttl != null) {
            try {
                ttlI = Integer.parseInt(ttl);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] objectArray = new Object[2];
                objectArray[0] = reqData;
                objectArray[1] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.wssecurity.cxf.interceptor.UsernameTokenInterceptor", (String)"282", (Object)((Object)this), (Object[])objectArray);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("ttl string is malformat '" + ttl + "'" + e.getMessage()), (Object[])new Object[0]);
                }
                ttlI = reqData.getTimeToLive();
            }
        }
        if (ttlI <= 0) {
            ttlI = reqData.getTimeToLive();
        }
        return ttlI;
    }

    /*
     * WARNING - void declaration
     */
    protected int decodeFutureTimeToLive(RequestData reqData, @Sensitive SoapMessage message) {
        String ttl = (String)message.getContextualProperty("ws-security.timestamp.futureTimeToLive");
        int defaultFutureTimeToLive = 60;
        if (ttl != null) {
            try {
                int ttlI = Integer.parseInt(ttl);
                if (ttlI < 0) {
                    return defaultFutureTimeToLive;
                }
                return ttlI;
            }
            catch (NumberFormatException ttlI) {
                Object[] objectArray = new Object[2];
                objectArray[0] = reqData;
                objectArray[1] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
                FFDCFilter.processException((Throwable)ttlI, (String)"com.ibm.ws.wssecurity.cxf.interceptor.UsernameTokenInterceptor", (String)"306", (Object)((Object)this), (Object[])objectArray);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("future ttl string is malformat '" + ttl + "'" + e.getMessage()), (Object[])new Object[0]);
                }
                return defaultFutureTimeToLive;
            }
        }
        return defaultFutureTimeToLive;
    }
}

