/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.cxf.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.SamlToken;
import org.apache.cxf.ws.security.wss4j.SamlTokenInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.processor.SAMLTokenProcessor;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSSecuritySamlTokenInterceptor
extends SamlTokenInterceptor {
    private static final TraceComponent tc = Tr.register(WSSecuritySamlTokenInterceptor.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    public static final String WSSEC = "ws-security";
    public static final String CXF_SIG_PROPS = "ws-security.signature.properties";
    public static final String CXF_ENC_PROPS = "ws-security.encryption.properties";
    static final long serialVersionUID = -5538011446894670891L;

    public void handleMessage(SoapMessage message) throws Fault {
        boolean isReq = MessageUtils.isRequestor((Message)message);
        boolean isOut = MessageUtils.isOutbound((Message)message);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" isReq:" + isReq + "isOut:" + isOut), (Object[])new Object[0]);
        }
        if (isReq != isOut) {
            super.handleMessage(message);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SamlTokenInterceptor handled(1)", (Object[])new Object[0]);
            }
            return;
        }
        if (isReq) {
            super.handleMessage(message);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SamlTokenInterceptor handled(1)", (Object[])new Object[0]);
            }
            return;
        }
        if (message.containsKey((Object)WSS4JInInterceptor.SECURITY_PROCESSED)) {
            return;
        }
        this.processSamlToken(message);
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    private void processSamlToken(SoapMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"processSamlToken(1)", (Object[])new Object[0]);
        }
        Header h = this.findSecurityHeader(message, false);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processSamlToken(2):" + h), (Object[])new Object[0]);
        }
        if (h == null) {
            return;
        }
        Element el = (Element)h.getObject();
        el = (Element)DOMUtils.getDomElement((Node)el);
        Element child = DOMUtils.getFirstElement((Node)el);
        while (child != null) {
            if ("Assertion".equals(child.getLocalName())) {
                try {
                    List<WSSecurityEngineResult> samlResults = this.processToken(child, message);
                    if (samlResults != null) {
                        ArrayList<WSHandlerResult> results = CastUtils.cast((List)((List)message.get((Object)"RECV_RESULTS")));
                        if (results == null) {
                            results = new ArrayList<WSHandlerResult>();
                            message.put("RECV_RESULTS", results);
                        }
                        WSHandlerResult rResult = new WSHandlerResult(null, samlResults);
                        results.add(0, rResult);
                        this.assertSamlTokens(message);
                        Principal principal = (Principal)samlResults.get(0).get((Object)"principal");
                        message.put("wss4j.principal.result", (Object)principal);
                        SecurityContext sc = (SecurityContext)message.get(SecurityContext.class);
                        if (sc == null || sc.getUserPrincipal() == null) {
                            message.put(SecurityContext.class, (Object)new DefaultSecurityContext(principal, null));
                        }
                    }
                }
                catch (WSSecurityException samlResults) {
                    void ex;
                    FFDCFilter.processException((Throwable)samlResults, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecuritySamlTokenInterceptor", (String)"171", (Object)((Object)this), (Object[])new Object[]{message});
                    throw new Fault((Throwable)ex);
                }
            }
            child = DOMUtils.getNextElement((Element)child);
        }
    }

    @Trivial
    private List<WSSecurityEngineResult> processToken(Element tokenElement, final SoapMessage message) throws WSSecurityException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processToken(1):" + tokenElement), (Object[])new Object[0]);
        }
        WSDocInfo wsDocInfo = new WSDocInfo(tokenElement.getOwnerDocument());
        RequestData data = new RequestData(){
            static final long serialVersionUID = 6505831369165965164L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public CallbackHandler getCallbackHandler() {
                return WSSecuritySamlTokenInterceptor.this.getCallback(message);
            }

            /*
             * WARNING - void declaration
             */
            public Validator getValidator(QName qName) throws WSSecurityException {
                String key = null;
                if (WSSecurityEngine.SAML_TOKEN.equals(qName)) {
                    key = "ws-security.saml1.validator";
                } else if (WSSecurityEngine.SAML2_TOKEN.equals(qName)) {
                    key = "ws-security.saml2.validator";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("found key?:" + (key != null)), (Object[])new Object[0]);
                }
                if (key != null) {
                    Object o = message.getContextualProperty(key);
                    try {
                        if (o instanceof Validator) {
                            return (Validator)o;
                        }
                        if (o instanceof Class) {
                            return (Validator)((Class)o).newInstance();
                        }
                        if (o instanceof String) {
                            return (Validator)ClassLoaderUtils.loadClass((String)o.toString(), WSSecuritySamlTokenInterceptor.class).newInstance();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        void t;
                        FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecuritySamlTokenInterceptor$1", (String)"216", (Object)((Object)this), (Object[])new Object[]{qName});
                        throw t;
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecuritySamlTokenInterceptor$1", (String)"218", (Object)((Object)this), (Object[])new Object[]{qName});
                        throw new WSSecurityException(t.getMessage(), t);
                    }
                }
                return super.getValidator(qName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
            }
        };
        data.setWssConfig(WSSConfig.getNewInstance());
        SAMLTokenProcessor p = new SAMLTokenProcessor();
        Object o = message.getContextualProperty(CXF_SIG_PROPS);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("found sig object:" + (o != null)), (Object[])new Object[0]);
        }
        if (o != null) {
            Map sigPropsMap = (Map)o;
            Properties sigProps = new Properties();
            sigProps.putAll((Map<?, ?>)sigPropsMap);
            Crypto sigCrypto = CryptoFactory.getInstance((Properties)sigProps);
            data.setEncCrypto(sigCrypto);
        }
        Object oe = message.getContextualProperty(CXF_ENC_PROPS);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("found enc object:" + (oe != null)), (Object[])new Object[0]);
        }
        if (oe != null) {
            Map encPropsMap = (Map)oe;
            Properties encProps = new Properties();
            encProps.putAll((Map<?, ?>)encPropsMap);
            Crypto encCrypto = CryptoFactory.getInstance((Properties)encProps);
            data.setSigCrypto(encCrypto);
        }
        List results = p.handleToken(tokenElement, data, wsDocInfo);
        return results;
    }

    @Trivial
    private SamlToken assertSamlTokens(SoapMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"assertSamlToken(1)", (Object[])new Object[0]);
        }
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        Collection ais = aim.getAssertionInfo(SP12Constants.SAML_TOKEN);
        SamlToken tok = null;
        for (AssertionInfo ai : ais) {
            tok = (SamlToken)ai.getAssertion();
            ai.setAsserted(true);
        }
        ais = aim.getAssertionInfo(SP12Constants.SUPPORTING_TOKENS);
        for (AssertionInfo ai : ais) {
            ai.setAsserted(true);
        }
        ais = aim.getAssertionInfo(SP12Constants.SIGNED_SUPPORTING_TOKENS);
        for (AssertionInfo ai : ais) {
            ai.setAsserted(true);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("assertSamlToken(2)" + (tok != null)), (Object[])new Object[0]);
        }
        return tok;
    }

    @Trivial
    private Header findSecurityHeader(SoapMessage message, boolean create) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findSecurityHeader(1) create" + create), (Object[])new Object[0]);
        }
        for (Header h : message.getHeaders()) {
            QName n = h.getName();
            if (!n.getLocalPart().equals("Security") || !n.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") && !n.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) continue;
            return h;
        }
        if (!create) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"findSecurityHeader(2)", (Object[])new Object[0]);
        }
        Document doc = DOMUtils.createDocument();
        Element el = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SoapHeader sh = new SoapHeader(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"), (Object)el);
        sh.setMustUnderstand(true);
        message.getHeaders().add(sh);
        return sh;
    }

    private CallbackHandler getCallback(SoapMessage message) {
        Object o = message.getContextualProperty("ws-security.callback-handler");
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), ((Object)((Object)this)).getClass()).newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecuritySamlTokenInterceptor", (String)"331", (Object)((Object)this), (Object[])new Object[]{message});
                handler = null;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCallBack():" + handler), (Object[])new Object[0]);
        }
        return handler;
    }
}

