/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.registry;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.ws.security.wim.VMMService;
import com.ibm.wsspi.security.registry.RegistryHelper;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import com.ibm.wsspi.security.wim.model.PropertyControl;
import com.ibm.wsspi.security.wim.model.Root;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RegistryClaims {
    private static final TraceComponent tc = Tr.register(RegistryClaims.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    private final String userName;
    static final long serialVersionUID = 5933981138416689894L;

    public RegistryClaims(String userName) {
        this.userName = userName;
    }

    public Object fetchClaim(String claim) throws Exception {
        VMMService vmmService = JwtUtils.getVMMService();
        if (vmmService != null) {
            PropertyControl vmmServiceProps = new PropertyControl();
            vmmServiceProps.getProperties().add(claim);
            if (!vmmServiceProps.getProperties().isEmpty()) {
                PersonAccount person = this.getUser(vmmService, vmmServiceProps);
                Object value = person.get(claim);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("get for claim: " + claim + ", returned: " + value), (Object[])new Object[0]);
                }
                return value;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("get for claim: " + claim + ", returned: null"), (Object[])new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> fetchExtraClaims(JwtConfig jwtConfig) {
        Map<String, Object> vmmInfoMap;
        block5: {
            List<String> claimsList = jwtConfig.getClaims();
            vmmInfoMap = new HashMap<String, Object>();
            if (!claimsList.isEmpty()) {
                HashSet<String> extraCustomClaims = new HashSet<String>(claimsList);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("extraCustomClaims length: " + extraCustomClaims.size()), (Object[])new Object[0]);
                }
                if (extraCustomClaims == null || extraCustomClaims.size() <= 0) {
                    return null;
                }
                try {
                    vmmInfoMap = this.getUserinfoFromRegistryMap(extraCustomClaims, vmmInfoMap, false);
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.registry.RegistryClaims", (String)"95", (Object)this, (Object[])new Object[]{jwtConfig});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)"extraCustomClaims get unexpected Exception", (Object[])new Object[]{e});
                }
            }
        }
        return vmmInfoMap;
    }

    private PersonAccount getUser(VMMService vmmService, PropertyControl vmmServiceProps) throws Exception {
        IdentifierType id = new IdentifierType();
        String uniqueId = RegistryHelper.getUserRegistry(null).getUniqueUserId(this.userName);
        id.setUniqueName(uniqueId);
        Entity entity = new Entity();
        entity.setIdentifier(id);
        Root root = new Root();
        root.getEntities().add(entity);
        root.getControls().add(vmmServiceProps);
        root = vmmService.get(root);
        PersonAccount person = (PersonAccount)root.getEntities().get(0);
        return person;
    }

    private Map<String, Object> getUserinfoFromRegistryMap(Set<String> claims, Map<String, Object> inputMap, boolean isJson) throws Exception {
        Map<String, Object> result = inputMap;
        VMMService vmmService = JwtUtils.getVMMService();
        if (vmmService != null) {
            PropertyControl vmmServiceProps = new PropertyControl();
            Properties claimsToVMMProperties = new Properties();
            if (!claims.isEmpty()) {
                Iterator<String> iterator = claims.iterator();
                while (iterator.hasNext()) {
                    String claim;
                    String vmmProperty = claim = iterator.next();
                    claimsToVMMProperties.put(claim, vmmProperty);
                    vmmServiceProps.getProperties().add(vmmProperty);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("claimsToVMMProperties: " + claimsToVMMProperties), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("getting VMM properties: " + vmmServiceProps.getProperties()), (Object[])new Object[0]);
            }
            if (!vmmServiceProps.getProperties().isEmpty()) {
                PersonAccount person = this.getUser(vmmService, vmmServiceProps);
                for (Map.Entry<Object, Object> e : claimsToVMMProperties.entrySet()) {
                    String strValue;
                    String claim = (String)e.getKey();
                    String vmmProperty = (String)e.getValue();
                    Object value = person.get(vmmProperty);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("get for claim: " + claim + "  vmmProperty: " + vmmProperty + ", returned: " + value), (Object[])new Object[0]);
                    }
                    if ((strValue = this.vmmPropertyToString(value)) == null || strValue.isEmpty()) continue;
                    result.put(claim, strValue);
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"VMM service not available - not returning any extra claims", (Object[])new Object[0]);
        }
        return result;
    }

    public String vmmPropertyToString(Object value) {
        String result = null;
        if (value == null || value instanceof String) {
            result = (String)value;
        } else if (value instanceof List) {
            StringBuffer strBuff = null;
            for (Object element : (List)value) {
                String elem = element.toString();
                if (elem == null) continue;
                if (strBuff == null) {
                    strBuff = new StringBuffer();
                } else {
                    strBuff.append(" ");
                }
                strBuff.append(elem);
            }
            if (strBuff != null) {
                result = strBuff.toString();
            }
        } else {
            result = value.toString();
        }
        return result;
    }
}

