/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.utils;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.jwt.InvalidTokenException;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.internal.JwtConfigUtil;
import com.ibm.ws.security.jwt.registry.RegistryClaims;
import com.ibm.ws.security.wim.VMMService;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.jose4j.json.JsonUtil;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwtUtils {
    private static final TraceComponent tc = Tr.register(JwtUtils.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    public static final String CFG_KEY_ID = "id";
    public static final String CFG_KEY_ISSUER = "issuer";
    public static final String CFG_KEY_JWK_ENABLED = "jwkEnabled";
    public static final String CFG_KEY_VALID = "expiry";
    public static final String CFG_KEY_JTI = "jti";
    public static final String CFG_KEY_JTI_CHECK_ENABLED = "jtiCheckEnabled";
    public static final String CFG_KEY_SCOPE = "scope";
    public static final String CFG_KEY_AUDIENCES = "audiences";
    public static final String CFG_KEY_SIGNATURE_ALGORITHM = "signatureAlgorithm";
    public static final String CFG_KEY_CLAIMS = "claims";
    public static final String CFG_KEY_KEYSTORE_REF = "keyStoreRef";
    public static final String CFG_KEY_KEY_ALIAS_NAME = "keyAlias";
    public static final String CFG_KEY_TRUSTSTORE_REF = "trustStoreRef";
    public static final String CFG_KEY_TRUSTED_ALIAS = "trustedAlias";
    public static final String CFG_KEY_SHARED_KEY = "sharedKey";
    public static final String CFG_KEY_JWK_ROTATION_TIME = "jwkRotationTime";
    public static final String CFG_KEY_JWK_SIGNING_KEY_SIZE = "jwkSigningKeySize";
    public static final String CFG_KEY_JWK_ENDPOINT_URL = "jwkEndpointUrl";
    public static final String CFG_KEY_CLOCK_SKEW = "clockSkew";
    public static final String CFG_KEY_VALIDATION_REQUIRED = "validationRequired";
    public static final String CFG_KEY_SSL_REF = "sslRef";
    public static final String CFG_KEY_EXPIRES_IN_SECONDS = "expiresInSeconds";
    public static final String CFG_KEY_USE_SYSPROPS_FOR_HTTPCLIENT_CONNECTONS = "useSystemPropertiesForHttpClientConnections";
    public static final String JCEPROVIDER_IBM = "IBMJCE";
    public static final String SECRANDOM_SHA1PRNG = "SHA1PRNG";
    public static final String SECRANDOM_IBM = "IBMSecureRandom";
    public static final String ISSUER = "iss";
    public static final String SUBJECT = "sub";
    public static final String AUDIENCE = "aud";
    public static final String SCOPE = "scope";
    public static final String EXPIRATION = "exp";
    public static final String NOT_BEFORE = "nbf";
    public static final String ISSUED_AT = "iat";
    public static final String ID = "jti";
    public static final String KEY = "signKey";
    public static final String ALG = "signAlg";
    public static final String KS = "KeyStore";
    public static final String KS_ALIAS = "KeyStore_ALIAS";
    public static final String TS = "TrustStore";
    public static final String TS_ALIAS = "TrustStore_ALIAS";
    public static final String DELIMITER = ".";
    private static final String KEY_VMM_SERVICE = "vmmService";
    public static final String KEY_KEYSTORE_SERVICE = "keyStoreService";
    private static AtomicServiceReference<VMMService> vmmServiceRef = new AtomicServiceReference("vmmService");
    private static AtomicServiceReference<KeyStoreService> keyStoreServiceRef;
    private static ConcurrentServiceReferenceMap<String, KeyStoreService> keyStoreServiceMapRef;
    private static AtomicServiceReference<SSLSupport> sslSupportRef;
    private static ThreadLocal<Boolean> isJwtSsoValidationPath;
    private static ThreadLocal<Boolean> isJwtSsoValidationPathExpiredToken;
    static final long serialVersionUID = 7345811177324922947L;

    public static void setJwtSsoValidationPath() {
        isJwtSsoValidationPath.set(true);
    }

    public static boolean setJwtSsoValidationPathExiredToken() {
        if (isJwtSsoValidationPath.get() != null && isJwtSsoValidationPath.get().booleanValue()) {
            isJwtSsoValidationPathExpiredToken.set(true);
            return true;
        }
        return false;
    }

    public static boolean isJwtSsoValidationExpiredTokenCodePath() {
        boolean result = isJwtSsoValidationPathExpiredToken.get() != null ? isJwtSsoValidationPathExpiredToken.get() : false;
        return result;
    }

    public static String convertToBase64(String source) {
        return Base64.encodeBase64URLSafeString((byte[])StringUtils.getBytesUtf8((String)source));
    }

    public static String decodeFromBase64String(String encoded) {
        return new String(Base64.decodeBase64((String)encoded));
    }

    public static boolean isBase64Encoded(String str) {
        if (!JwtUtils.isNullEmpty(str)) {
            return Base64.isArrayByteBase64((byte[])StringUtils.getBytesUtf8((String)str));
        }
        return false;
    }

    public static String fromBase64ToJsonString(String source) {
        return StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)source));
    }

    public static String toJson(String source) {
        try {
            return StringUtils.newStringUtf8((byte[])source.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.jwt.utils.JwtUtils", (String)"169", null, (Object[])new Object[]{source});
            return null;
        }
    }

    public static boolean isNullEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static boolean isJson(String tokenString) {
        boolean result = false;
        if (!JwtUtils.isNullEmpty(tokenString) && (tokenString.startsWith("{") && tokenString.endsWith("}") || tokenString.startsWith("[") && tokenString.endsWith("]"))) {
            result = true;
        }
        return result;
    }

    public static Object claimFromJsonObject(String jsonFormattedString, String claimName) throws JoseException {
        Object claim = null;
        Map jobj = JsonUtil.parseJson((String)jsonFormattedString);
        if (jobj != null) {
            claim = jobj.get(claimName);
        }
        return claim;
    }

    public static Map claimsFromJsonObject(String jsonFormattedString) throws JoseException {
        ConcurrentHashMap claimsMap = new ConcurrentHashMap();
        Map jobj = JsonUtil.parseJson((String)jsonFormattedString);
        Set entries = jobj.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Key : " + key + ", Value: " + value), (Object[])new Object[0]);
            }
            if (JwtUtils.isNullEmpty(key) || value == null) continue;
            claimsMap.put(key, value);
        }
        return claimsMap;
    }

    public static Map<String, Object> claimsFromJson(String jsonFormattedString) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JSON String =" + jsonFormattedString), (Object[])new Object[0]);
        }
        JSONObject object = JSONObject.parse((String)jsonFormattedString);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set set = object.entrySet();
        for (Map.Entry entry : set) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (JwtUtils.isJsonArray(value)) {
                JwtUtils.handleJsonArray(value, key, map);
                continue;
            }
            if (JwtUtils.isJsonObject(value)) {
                map.put(key, JwtUtils.claimsFromJson(value.toString()));
                continue;
            }
            map.put(key, value.toString());
        }
        return map;
    }

    @FFDCIgnore(value={Exception.class})
    public static void handleJsonArray(Object value, String key, HashMap<String, Object> map) {
        if (!JwtUtils.isJsonArray(value)) {
            map.put(key, value.toString());
            return;
        }
        JSONArray jArray = null;
        try {
            jArray = JSONArray.parse((String)value.toString());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception handling provided object [" + value.toString() + "]: " + e.getMessage()), (Object[])new Object[0]);
            }
            map.put(key, value.toString());
            return;
        }
        if (jArray != null && !jArray.isEmpty()) {
            map.put(key, jArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("array list of objects, Key : " + key + ", Value: " + jArray.toString()), (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={Exception.class})
    static boolean isJsonObject(Object value) {
        if (value == null) {
            return false;
        }
        try {
            JSONObject.parse((String)value.toString());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Value [" + value + "] is not a valid JSON object: " + e.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    @FFDCIgnore(value={Exception.class})
    static boolean isJsonArray(Object value) {
        if (value == null) {
            return false;
        }
        try {
            JSONArray.parse((String)value.toString());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Value [" + value + "] is not a valid JSON array: " + e.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    public static List<String> trimIt(String[] strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < strings.length; ++i) {
            String result = JwtUtils.trimIt(strings[i]);
            if (result == null) continue;
            results.add(result);
        }
        if (results.size() > 0) {
            return results;
        }
        return null;
    }

    public static String trimIt(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).isEmpty()) {
            return null;
        }
        return str;
    }

    public static JwtConfig getTheAtomicService(String builderConfigId, ConcurrentServiceReferenceMap<String, JwtConfig> jwtServiceMapRef) {
        Iterator jwtServices = jwtServiceMapRef.getServices();
        while (jwtServices.hasNext()) {
            JwtConfig jwtService = (JwtConfig)jwtServices.next();
            if (!builderConfigId.equals(jwtService.getId())) continue;
            return jwtService;
        }
        return null;
    }

    public static JwtConfig getTheService(String builderConfigId, ConcurrentServiceReferenceMap<String, JwtConfig> jwtServiceMapRef) {
        Iterator jwtServices = jwtServiceMapRef.getServices();
        while (jwtServices.hasNext()) {
            JwtConfig jwtService = (JwtConfig)jwtServices.next();
            if (!builderConfigId.equals(jwtService.getId())) continue;
            return jwtService;
        }
        return null;
    }

    public static String[] splitTokenString(String tokenString) {
        boolean isPlainTextJWT = false;
        if (tokenString.endsWith(DELIMITER)) {
            isPlainTextJWT = true;
        }
        String[] pieces = tokenString.split(Pattern.quote(DELIMITER));
        if (!isPlainTextJWT && pieces.length != 3) {
            return null;
        }
        return pieces;
    }

    public static String getPayload(String jwt) {
        String[] jwtInfo = JwtUtils.splitTokenString(jwt);
        if (jwtInfo != null) {
            return jwtInfo[1];
        }
        return null;
    }

    public static String getRandom(int length) {
        StringBuffer result = new StringBuffer(length);
        char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        Random r = JwtUtils.getRandom();
        for (int i = 0; i < length; ++i) {
            int n = r.nextInt(62);
            result.append(chars[n]);
        }
        return result.toString();
    }

    static Random getRandom() {
        Random result = null;
        try {
            result = Security.getProvider(JCEPROVIDER_IBM) != null ? SecureRandom.getInstance(SECRANDOM_IBM) : SecureRandom.getInstance(SECRANDOM_SHA1PRNG);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.utils.JwtUtils", (String)"433", null, (Object[])new Object[0]);
            result = new Random();
        }
        return result;
    }

    public static long calculate(long valid) {
        long lifetimeSeconds = valid * 60L * 60L;
        long timeInSeconds = System.currentTimeMillis() / 1000L;
        return timeInSeconds + lifetimeSeconds;
    }

    public static String toJson(Map<String, Object> claimsMap) {
        return JsonUtil.toJson(claimsMap);
    }

    public static void setVMMService(AtomicServiceReference<VMMService> vmmServiceRef) {
        JwtUtils.vmmServiceRef = vmmServiceRef;
    }

    public static VMMService getVMMService() {
        return (VMMService)vmmServiceRef.getService();
    }

    public static Object fetch(String claim, String subject) throws Exception {
        RegistryClaims claims = new RegistryClaims(subject);
        return claims.fetchClaim(claim);
    }

    public static void setSSLSupportService(AtomicServiceReference<SSLSupport> sslSupportRef) {
        JwtUtils.sslSupportRef = sslSupportRef;
    }

    public static SSLSupport getSSLSupportService() {
        return (SSLSupport)sslSupportRef.getService();
    }

    public static void setKeyStoreService(AtomicServiceReference<KeyStoreService> kssRef) {
        keyStoreServiceRef = kssRef;
    }

    public static void setKeyStoreService2(ConcurrentServiceReferenceMap<String, KeyStoreService> kssMapRef) {
        keyStoreServiceMapRef = kssMapRef;
    }

    public static KeyStoreService getKeyStoreService() {
        if (keyStoreServiceRef != null) {
            return (KeyStoreService)keyStoreServiceRef.getService();
        }
        return null;
    }

    public static String getDefaultKeyStoreName(String propKey) {
        String keyStoreName = null;
        SSLSupport sslSupport = JwtUtils.getSSLSupportService();
        JSSEHelper helper = null;
        if (sslSupport != null) {
            helper = sslSupport.getJSSEHelper();
        }
        Properties props = null;
        final JSSEHelper jsseHelper = helper;
        final HashMap<String, String> connectionInfo = new HashMap<String, String>();
        connectionInfo.put("com.ibm.ssl.direction", "inbound");
        if (jsseHelper != null) {
            block6: {
                try {
                    props = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                        static final long serialVersionUID = 613296464331805325L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Object run() throws Exception {
                            return jsseHelper.getProperties("", connectionInfo, null, true);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.jwt.utils.JwtUtils", (String)"515", null, (Object[])new Object[]{propKey});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)"Exception getting properties from jssehelper!!!", (Object[])new Object[0]);
                }
            }
            if (props != null) {
                keyStoreName = props.getProperty(propKey);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("KeyStore name from default ssl config = " + keyStoreName), (Object[])new Object[0]);
                }
            }
        }
        return keyStoreName;
    }

    @Sensitive
    public static PrivateKey getPrivateKey(String keyAlias, String keyStoreRef) throws KeyStoreException, CertificateException {
        return JwtUtils.getPrivateKey(keyAlias, keyStoreRef, JwtUtils.getKeyStoreService());
    }

    @Sensitive
    public static PrivateKey getPrivateKey(String keyAlias, String keyStoreRef, KeyStoreService kss) throws KeyStoreException, CertificateException {
        if (kss != null) {
            if (keyStoreRef == null) {
                keyStoreRef = JwtUtils.getDefaultKeyStoreName("com.ibm.ssl.keyStoreName");
            }
            if (keyStoreRef != null) {
                if (keyAlias != null) {
                    return kss.getPrivateKeyFromKeyStore(keyStoreRef, keyAlias, null);
                }
                return kss.getPrivateKeyFromKeyStore(keyStoreRef);
            }
        }
        return null;
    }

    public static PublicKey getPublicKey(String keyAlias, String trustStoreRef) throws KeyStoreException, CertificateException, InvalidTokenException {
        return JwtUtils.getPublicKey(keyAlias, trustStoreRef, JwtUtils.getKeyStoreService());
    }

    public static PublicKey getPublicKey(String keyAlias, String trustStoreRef, KeyStoreService kss) throws KeyStoreException, CertificateException, InvalidTokenException {
        if (kss == null) {
            return null;
        }
        if (trustStoreRef == null && (trustStoreRef = JwtUtils.getDefaultKeyStoreName("com.ibm.ssl.trustStoreName")) == null) {
            return null;
        }
        if (keyAlias != null) {
            X509Certificate cert = kss.getX509CertificateFromKeyStore(trustStoreRef, keyAlias);
            if (cert == null) {
                return null;
            }
            return cert.getPublicKey();
        }
        Collection aliases = kss.getTrustedCertEntriesInKeyStore(trustStoreRef);
        if (aliases == null || aliases.size() == 0) {
            X509Certificate cert = kss.getX509CertificateFromKeyStore(trustStoreRef);
            if (cert != null) {
                return cert.getPublicKey();
            }
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_SIGNER_CERT_NOT_AVAILABLE", (Object[])new Object[0]);
            throw new InvalidTokenException(errorMsg);
        }
        if (aliases.size() > 1) {
            X509Certificate cert = kss.getX509CertificateFromKeyStore(trustStoreRef);
            if (cert != null) {
                return cert.getPublicKey();
            }
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_SIGNER_CERT_AMBIGUOUS", (Object[])new Object[0]);
            throw new InvalidTokenException(errorMsg);
        }
        String alias = (String)aliases.iterator().next();
        X509Certificate cert = kss.getX509CertificateFromKeyStore(trustStoreRef, alias);
        if (cert != null) {
            return cert.getPublicKey();
        }
        String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_SIGNER_CERT_NOT_AVAILABLE", (Object[])new Object[0]);
        throw new InvalidTokenException(errorMsg);
    }

    public static String getDate(long current) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date resultdate = new Date(current);
        return sdf.format(resultdate);
    }

    @Sensitive
    public static String processProtectedString(Map<String, Object> props, String cfgKey) {
        return JwtConfigUtil.processProtectedString(props, cfgKey);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        keyStoreServiceMapRef = new ConcurrentServiceReferenceMap(KEY_KEYSTORE_SERVICE);
        isJwtSsoValidationPath = new ThreadLocal();
        isJwtSsoValidationPathExpiredToken = new ThreadLocal();
    }
}

