/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.ClassGenerator;
import com.ibm.ws.classloading.ClassLoaderIdentifierService;
import com.ibm.ws.classloading.LibertyClassLoadingService;
import com.ibm.ws.classloading.MetaInfServicesProvider;
import com.ibm.ws.classloading.configuration.GlobalClassloadingConfiguration;
import com.ibm.ws.classloading.internal.AppClassLoader;
import com.ibm.ws.classloading.internal.ClassGeneratorManager;
import com.ibm.ws.classloading.internal.ClassLoaderConfigurationImpl;
import com.ibm.ws.classloading.internal.ClassLoaderFactory;
import com.ibm.ws.classloading.internal.CompositeResourceProvider;
import com.ibm.ws.classloading.internal.GatewayBundleFactory;
import com.ibm.ws.classloading.internal.GatewayClassLoader;
import com.ibm.ws.classloading.internal.GatewayConfigurationImpl;
import com.ibm.ws.classloading.internal.ShadowClassLoader;
import com.ibm.ws.classloading.internal.ThreadContextClassLoader;
import com.ibm.ws.classloading.internal.ThreadContextClassLoaderForBundles;
import com.ibm.ws.classloading.internal.UnifiedClassLoader;
import com.ibm.ws.classloading.internal.providers.WeakLibraryListener;
import com.ibm.ws.classloading.internal.util.CanonicalStore;
import com.ibm.ws.classloading.internal.util.ClassRedefiner;
import com.ibm.ws.classloading.internal.util.Factory;
import com.ibm.ws.classloading.internal.util.MultiMap;
import com.ibm.ws.classloading.serializable.ClassLoaderIdentityImpl;
import com.ibm.ws.container.service.metadata.extended.MetaDataIdentifierService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.classloading.ClassTransformer;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import com.ibm.wsspi.classloading.ResourceProvider;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.library.ApplicationExtensionLibrary;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.logging.Introspector;
import java.io.File;
import java.io.PrintWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.url.URLStreamHandlerService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ClassLoadingService.class, LibertyClassLoadingService.class, ClassLoaderIdentifierService.class, Introspector.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ClassLoadingServiceImpl
implements LibertyClassLoadingService,
ClassLoaderIdentifierService,
Introspector {
    static final TraceComponent tc = Tr.register(ClassLoadingServiceImpl.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private final Map<ClassLoader, StackTraceElement[]> leakDetectionMap = new HashMap<ClassLoader, StackTraceElement[]>();
    private final Set<AppClassLoader> appClassLoaders = Collections.newSetFromMap(new WeakHashMap());
    private static final int TCCL_LOCK_WAIT = Integer.getInteger("com.ibm.ws.classloading.tcclLockWaitTimeMillis", 15000);
    static final String REFERENCE_GENERATORS = "generators";
    private BundleContext bundleContext;
    private CanonicalStore<ClassLoaderIdentity, AppClassLoader> aclStore;
    private CanonicalStore<String, ThreadContextClassLoader> tcclStore;
    private final ReentrantLock tcclStoreLock = new ReentrantLock();
    private RegionDigraph digraph;
    private ClassRedefiner redefiner = new ClassRedefiner(null);
    private final BundleListener listener = new BundleListener(){
        static final long serialVersionUID = -9159707349812113172L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent event) {
            if (event.getType() == 16) {
                ClassLoadingServiceImpl.this.classloaders.remove(event.getBundle());
            } else if (event.getType() == 32) {
                Map<Bundle, Set<GatewayClassLoader>> map = ClassLoadingServiceImpl.this.classloaders;
                synchronized (map) {
                    Set<GatewayClassLoader> gwCLs = ClassLoadingServiceImpl.this.classloaders.get(event.getBundle());
                    if (gwCLs != null) {
                        for (GatewayClassLoader gwCL : gwCLs) {
                            gwCL.populateNewLoader();
                        }
                    }
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    };
    final Map<Bundle, Set<GatewayClassLoader>> classloaders = Collections.synchronizedMap(new HashMap());
    private final CompositeResourceProvider resourceProviders = new CompositeResourceProvider();
    private final Map<String, WeakReference<Bundle>> rememberedBundles = new ConcurrentHashMap<String, WeakReference<Bundle>>();
    private final ReferenceQueue<Bundle> collectedBundles = new ReferenceQueue();
    private final ConcurrentServiceReferenceSet<ClassGenerator> generatorRefs = new ConcurrentServiceReferenceSet("generators");
    private final ClassGeneratorManager generatorManager = new ClassGeneratorManager(this.generatorRefs);
    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected volatile List<ApplicationExtensionLibrary> appExtLibs;
    private GlobalClassloadingConfiguration globalConfig;
    final ConcurrentHashMap<String, ConcurrentLinkedQueue<String>> metaInfServicesProviders = new ConcurrentHashMap();
    final ConcurrentServiceReferenceMap<String, MetaInfServicesProvider> metaInfServicesRefs = new ConcurrentServiceReferenceMap("MetaInfServicesProvider");
    private Map<String, ProtectionDomain> protectionDomainMap = null;
    protected MetaDataIdentifierService metadataIdentifierService;
    private final AtomicReference<Library> globalSharedLibrary = new AtomicReference();
    static final long serialVersionUID = 4365026902615131286L;

    @org.osgi.service.component.annotations.Reference
    protected void setGlobalClassloadingConfiguration(GlobalClassloadingConfiguration globalConfig) {
        this.globalConfig = globalConfig;
    }

    protected void unsetGlobalClassloadingConfiguration(GlobalClassloadingConfiguration globalConfig) {
        if (this.globalConfig == globalConfig) {
            this.globalConfig = null;
        }
    }

    @Activate
    protected void activate(ComponentContext cCtx, Map<String, Object> properties) {
        this.generatorRefs.activate(cCtx);
        this.metaInfServicesRefs.activate(cCtx);
        this.bundleContext = cCtx.getBundleContext();
        this.aclStore = new CanonicalStore();
        this.tcclStore = new CanonicalStore();
        Bundle systemBundle = this.bundleContext.getBundle("System Bundle");
        BundleContext systemContext = systemBundle.getBundleContext();
        systemContext.addBundleListener(this.listener);
    }

    @Deactivate
    protected void deactivate(ComponentContext cCtx) {
        this.generatorRefs.deactivate(cCtx);
        this.metaInfServicesRefs.deactivate(cCtx);
        Bundle systemBundle = this.bundleContext.getBundle("System Bundle");
        BundleContext systemContext = systemBundle.getBundleContext();
        systemContext.removeBundleListener(this.listener);
        this.bundleContext = null;
        this.cleanupRememberedBundles();
        this.aclStore = null;
        this.resourceProviders.clear();
    }

    @org.osgi.service.component.annotations.Reference(name="generators", service=ClassGenerator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addGenerator(ServiceReference<ClassGenerator> ref) {
        this.generatorRefs.addReference(ref);
    }

    protected void removeGenerator(ServiceReference<ClassGenerator> ref) {
        this.generatorRefs.removeReference(ref);
    }

    @org.osgi.service.component.annotations.Reference(service=MetaInfServicesProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addMetaInfServicesProvider(ServiceReference<MetaInfServicesProvider> ref) {
        String path = (String)ref.getProperty("file.path");
        String implClassName = (String)ref.getProperty("implementation.class");
        this.metaInfServicesRefs.putReference((Object)implClassName, ref);
        ConcurrentLinkedQueue<String> newList = new ConcurrentLinkedQueue<String>();
        ConcurrentLinkedQueue oldList = this.metaInfServicesProviders.putIfAbsent(path, newList);
        (oldList == null ? newList : oldList).add(implClassName);
    }

    protected void removeMetaInfServicesProvider(ServiceReference<MetaInfServicesProvider> ref) {
        String path = (String)ref.getProperty("file.path");
        String implClassName = (String)ref.getProperty("implementation.class");
        ConcurrentLinkedQueue<String> list = this.metaInfServicesProviders.get(path);
        if (list != null) {
            list.remove(implClassName);
        }
        this.metaInfServicesRefs.removeReference((Object)implClassName, ref);
    }

    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addResourceProvider(ResourceProvider rp) {
        this.resourceProviders.add(rp);
    }

    protected void removeResourceProvider(ResourceProvider rp) {
        this.resourceProviders.remove(rp);
    }

    @org.osgi.service.component.annotations.Reference
    protected void setRegionDigraph(RegionDigraph digraph) {
        this.digraph = digraph;
    }

    protected void unsetRegionDigraph(RegionDigraph digraph) {
    }

    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected void setInstrumentation(Instrumentation inst) {
        this.redefiner = new ClassRedefiner(inst);
    }

    protected void unsetInstrumentation(Instrumentation inst) {
        this.redefiner = null;
    }

    @org.osgi.service.component.annotations.Reference(service=MetaDataIdentifierService.class, name="metadataIdentifierService")
    protected void setMetadataIdentifierService(MetaDataIdentifierService svc) {
        this.metadataIdentifierService = svc;
    }

    protected void unsetMetadataIdentifierService(MetaDataIdentifierService svc) {
        this.metadataIdentifierService = null;
    }

    @org.osgi.service.component.annotations.Reference(service=URLStreamHandlerService.class, target="(url.handler.protocol=wsjar)")
    protected void setURLStreamHandlerService(URLStreamHandlerService svc) {
    }

    protected void unsetURLStreamHandlerService(URLStreamHandlerService svc) {
    }

    @Override
    public AppClassLoader createTopLevelClassLoader(List<Container> classPath, GatewayConfiguration gwConfig, ClassLoaderConfiguration clConfig) {
        if (clConfig.getIncludeAppExtensions()) {
            this.addAppExtensionLibs(clConfig);
        }
        AppClassLoader result = this.createAppClassLoader(new ClassLoaderFactory(this.bundleContext, this.digraph, this.classloaders, this.aclStore, this.resourceProviders, this.redefiner, this.generatorManager, this.globalConfig).setClassPath(classPath).configure(gwConfig).configure(clConfig));
        this.rememberBundle(result.getBundle());
        return result;
    }

    @Override
    public AppClassLoader createBundleAddOnClassLoader(List<File> classPath, ClassLoader gwClassLoader, ClassLoaderConfiguration clConfig) {
        return this.createAppClassLoader(new ClassLoaderFactory(this.bundleContext, this.digraph, this.classloaders, this.aclStore, this.resourceProviders, this.redefiner, this.generatorManager, this.globalConfig).setSharedLibPath(classPath).configure(this.createGatewayConfiguration()).useBundleAddOnLoader(gwClassLoader).configure(clConfig));
    }

    @Override
    public AppClassLoader createChildClassLoader(List<Container> classPath, ClassLoaderConfiguration config) {
        if (config.getIncludeAppExtensions()) {
            this.addAppExtensionLibs(config);
        }
        return this.createAppClassLoader(new ClassLoaderFactory(this.bundleContext, this.digraph, this.classloaders, this.aclStore, this.resourceProviders, this.redefiner, this.generatorManager, this.globalConfig).setClassPath(classPath).configure(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppClassLoader createAppClassLoader(ClassLoaderFactory factory) {
        AppClassLoader loader = factory.create();
        Set<AppClassLoader> set = this.appClassLoaders;
        synchronized (set) {
            this.appClassLoaders.add(loader);
        }
        return loader;
    }

    @Override
    public GatewayConfigurationImpl createGatewayConfiguration() {
        return new GatewayConfigurationImpl();
    }

    @Override
    public ClassLoaderConfigurationImpl createClassLoaderConfiguration() {
        return new ClassLoaderConfigurationImpl();
    }

    @Override
    public ClassLoaderIdentityImpl createIdentity(String domain, String id) {
        return new ClassLoaderIdentityImpl(domain, id);
    }

    @Override
    @FFDCIgnore(value={ClassCastException.class})
    public ShadowClassLoader getShadowClassLoader(ClassLoader loader) {
        try {
            return new ShadowClassLoader((AppClassLoader)loader);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public boolean registerTransformer(ClassTransformer transformer, ClassLoader loader) {
        try {
            return ((AppClassLoader)loader).addTransformer(new ClassFileTransformerAdapter(transformer));
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.classloading.internal.ClassLoadingServiceImpl", (String)"380", (Object)this, (Object[])new Object[]{transformer, loader});
            return false;
        }
    }

    @Override
    public boolean unregisterTransformer(ClassTransformer transformer, ClassLoader loader) {
        try {
            return ((AppClassLoader)loader).removeTransformer(new ClassFileTransformerAdapter(transformer));
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.classloading.internal.ClassLoadingServiceImpl", (String)"389", (Object)this, (Object[])new Object[]{transformer, loader});
            return false;
        }
    }

    @Override
    public UnifiedClassLoader unify(ClassLoader parent, ClassLoader ... followOns) {
        return new UnifiedClassLoader(parent, followOns);
    }

    @Override
    public AppClassLoader getSharedLibraryClassLoader(Library lib) {
        ClassLoaderIdentityImpl clId = this.createIdentity("Shared Library", lib.id());
        AppClassLoader loader = this.aclStore.retrieve(clId);
        if (loader != null) {
            return loader;
        }
        EnumSet<ApiType> apiTypeVisibility = lib.getApiTypeVisibility();
        ClassLoaderConfiguration clsCfg = this.createClassLoaderConfiguration().setId(clId).setSharedLibraries(lib.id());
        Collection<Fileset> filesets = lib.getFilesets();
        if (filesets != null && !filesets.isEmpty()) {
            for (Fileset fileset : filesets) {
                this.setProtectionDomain(fileset.getFileset(), clsCfg);
            }
        } else {
            Collection<File> files = lib.getFiles();
            if (files != null && !files.isEmpty()) {
                this.setProtectionDomain(files, clsCfg);
            }
        }
        AppClassLoader result = new ClassLoaderFactory(this.bundleContext, this.digraph, this.classloaders, this.aclStore, this.resourceProviders, this.redefiner, this.generatorManager, this.globalConfig).configure(this.createGatewayConfiguration().setApplicationName("Shared Library: " + lib.id()).setDynamicImportPackage("*").setApiTypeVisibility(apiTypeVisibility)).configure(clsCfg).onCreate(this.listenForLibraryChanges(lib.id())).getCanonical();
        this.rememberBundle(result.getBundle());
        return result;
    }

    private void setProtectionDomain(Collection<File> files, ClassLoaderConfiguration clsCfg) {
        for (File file : files) {
            String path = file.getPath();
            path = path.replace("\\", "/");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("path: " + path), (Object[])new Object[0]);
            }
            String matchingDomainKey = this.getProtectionDomainMapKey(path);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("matchingDomainKey: " + matchingDomainKey), (Object[])new Object[0]);
            }
            if (matchingDomainKey == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting the protection domain", (Object[])new Object[0]);
            }
            clsCfg.setProtectionDomain(this.protectionDomainMap.get(matchingDomainKey));
            break;
        }
    }

    @Trivial
    public Map<String, ProtectionDomain> getProtectionDomainMap() {
        return this.protectionDomainMap;
    }

    public String getProtectionDomainMapKey(String path) {
        if (this.protectionDomainMap == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"protectionDomainMap is null", (Object[])new Object[0]);
            }
            return null;
        }
        if (this.protectionDomainMap.containsKey(path)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("protectionDomainMap is not null, returning path: " + path), (Object[])new Object[0]);
            }
            return path;
        }
        for (String codebase : this.protectionDomainMap.keySet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("codebase = " + codebase), (Object[])new Object[0]);
            }
            if (codebase.endsWith("-")) {
                if (!path.startsWith(codebase.substring(0, codebase.indexOf(45)))) continue;
                return codebase;
            }
            if (!codebase.endsWith("*")) continue;
            String temp = codebase.substring(0, codebase.indexOf(42) - 1);
            File jarFile = new File(path);
            String pathParent = jarFile.getParent().replace("\\", "/");
            if (pathParent == null || !pathParent.equalsIgnoreCase(temp)) continue;
            return codebase;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"nothing matched in the protectionDomainMap, returning null", (Object[])new Object[0]);
        }
        return null;
    }

    private ClassLoaderFactory.PostCreateAction listenForLibraryChanges(final String libid) {
        return new ClassLoaderFactory.PostCreateAction(){
            static final long serialVersionUID = -65768333330841311L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void invoke(AppClassLoader acl) {
                ClassLoadingServiceImpl.this.listenForLibraryChanges(libid, acl);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        };
    }

    private void listenForLibraryChanges(String libid, AppClassLoader acl) {
        new WeakLibraryListener(libid, acl.getKey().getId(), acl, this.bundleContext){
            static final long serialVersionUID = 4175496090837118711L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            protected void update() {
                Object cl = this.get();
                if (cl instanceof AppClassLoader && ClassLoadingServiceImpl.this.aclStore != null) {
                    ClassLoadingServiceImpl.this.aclStore.remove((AppClassLoader)cl);
                }
                this.deregister();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        };
    }

    @Override
    @FFDCIgnore(value={InterruptedException.class})
    public ThreadContextClassLoader createThreadContextClassLoader(final ClassLoader applicationClassLoader) {
        ThreadContextClassLoader result;
        block16: {
            String key;
            String methodName = "createThreadContextClassLoader(): ";
            if (applicationClassLoader == null) {
                throw new IllegalArgumentException("ClassLoader argument is null");
            }
            if (applicationClassLoader instanceof AppClassLoader) {
                key = ((AppClassLoader)applicationClassLoader).getKey().toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createThreadContextClassLoader(): Instance of LibertyClassLoader, key = " + key), (Object[])new Object[0]);
                }
            } else if (applicationClassLoader instanceof BundleReference) {
                key = Long.toString(((BundleReference)applicationClassLoader).getBundle().getBundleId());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createThreadContextClassLoader(): Instance of BundleReference, key = " + key), (Object[])new Object[0]);
                }
            } else {
                throw new IllegalArgumentException(applicationClassLoader.toString() + " + is an unexpected ClassLoader type");
            }
            try {
                if (this.tcclStoreLock.tryLock(TCCL_LOCK_WAIT, TimeUnit.MILLISECONDS)) {
                    do {
                        if ((result = this.tcclStore.retrieveOrCreate(key, new Factory<ThreadContextClassLoader>(){
                            static final long serialVersionUID = -8724024091149290930L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public ThreadContextClassLoader createInstance() {
                                return ClassLoadingServiceImpl.this.createTCCL(applicationClassLoader, key);
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register(4.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                            }
                        })).isFor(applicationClassLoader)) continue;
                        this.tcclStore.remove(result);
                        result = null;
                    } while (result == null);
                    result.incrementRefCount();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        this.leakDetectionMap.put(result, Thread.currentThread().getStackTrace());
                    }
                    break block16;
                }
                throw new IllegalStateException("Unable to acquire TCCL store lock");
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Thread interrupted while acquiring TCCL store lock");
            }
            finally {
                if (this.tcclStoreLock.isHeldByCurrentThread()) {
                    this.tcclStoreLock.unlock();
                }
            }
        }
        return result;
    }

    private ThreadContextClassLoader createTCCL(ClassLoader cl, String key) {
        GatewayConfiguration gwConfig = this.createGatewayConfiguration().setApplicationName("ThreadContextClassLoader").setDynamicImportPackage("*;thread-context=\"true\"").setDelegateToSystem(false);
        ClassLoaderConfiguration clConfig = this.createClassLoaderConfiguration().setId(this.createIdentity("Thread Context", key));
        GatewayBundleFactory gatewayBundleFactory = new GatewayBundleFactory(this.bundleContext, this.digraph, this.classloaders);
        GatewayClassLoader aug = gatewayBundleFactory.createGatewayBundleClassLoader(gwConfig, clConfig, this.resourceProviders);
        ThreadContextClassLoader tccl = cl instanceof BundleReference ? new ThreadContextClassLoaderForBundles(aug, cl, key, this) : new ThreadContextClassLoader(aug, cl, key, this);
        return tccl;
    }

    private void cleanupRememberedBundles() {
        String methodName = "cleanupRememberedBundles(): ";
        for (WeakReference<Bundle> r : this.rememberedBundles.values()) {
            Bundle b = (Bundle)r.get();
            if (b == null) continue;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cleanupRememberedBundles(): Uninstalling bundle location: " + b.getLocation() + ", bundle id: " + b.getBundleId()), (Object[])new Object[0]);
                }
                b.uninstall();
            }
            catch (BundleException bundleException) {
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.classloading.internal.ClassLoadingServiceImpl", (String)"619", (Object)this, (Object[])new Object[0]);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.classloading.internal.ClassLoadingServiceImpl", (String)"620", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    private void forgetStaleBundles() {
        Reference<Bundle> o = this.collectedBundles.poll();
        while (o != null) {
            this.rememberedBundles.values().remove(o);
            o = this.collectedBundles.poll();
        }
    }

    private void rememberBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        this.forgetStaleBundles();
        WeakReference<Bundle> oldRef = this.rememberedBundles.get(bundle.getLocation());
        if (oldRef != null && oldRef.get() == bundle) {
            return;
        }
        WeakReference<Bundle> ref = new WeakReference<Bundle>(bundle, this.collectedBundles);
        oldRef = this.rememberedBundles.put(bundle.getLocation(), ref);
        if (oldRef != null) {
            oldRef.clear();
        }
    }

    @Override
    public void destroyThreadContextClassLoader(ClassLoader loader) {
        if (loader instanceof ThreadContextClassLoader) {
            this.tcclStoreLock.lock();
            try {
                ThreadContextClassLoader tccl = (ThreadContextClassLoader)loader;
                if (tccl.decrementRefCount() <= 0) {
                    this.tcclStore.remove(tccl);
                    this.leakDetectionMap.remove(tccl);
                }
            }
            finally {
                this.tcclStoreLock.unlock();
            }
        }
    }

    @Override
    public String getClassLoaderIdentifier(ClassLoader classloader) throws IllegalArgumentException {
        if (classloader instanceof ThreadContextClassLoader && !(classloader instanceof ThreadContextClassLoaderForBundles)) {
            return ((ThreadContextClassLoader)classloader).getKey();
        }
        if (classloader instanceof AppClassLoader) {
            return ((AppClassLoader)classloader).getKey().toString();
        }
        return null;
    }

    @Override
    public ClassLoader getClassLoader(String identifier) throws IllegalArgumentException {
        if (identifier == null) {
            return null;
        }
        ThreadContextClassLoader classloader = this.tcclStore.retrieve(identifier);
        if (classloader != null) {
            return classloader;
        }
        return null;
    }

    @Override
    public String getClassLoaderIdentifier(String type, String appName, String moduleName, String componentName) {
        String metadataId = this.metadataIdentifierService.getMetaDataIdentifier(type, appName, moduleName, componentName);
        MetaData metadata = this.metadataIdentifierService.getMetaData(metadataId);
        ClassLoader classLoader = this.metadataIdentifierService.getClassLoader(type, (ComponentMetaData)metadata);
        return this.getClassLoaderIdentifier(classLoader);
    }

    @Override
    public boolean isAppClassLoader(ClassLoader cl) {
        return cl instanceof AppClassLoader;
    }

    @Override
    public boolean isThreadContextClassLoader(ClassLoader cl) {
        return cl instanceof ThreadContextClassLoader;
    }

    @Override
    @Trivial
    public void setSharedLibraryProtectionDomains(Map<String, ProtectionDomain> protectionDomainMap) {
        this.protectionDomainMap = protectionDomainMap;
    }

    public void setGlobalSharedLibrary(Library gsl) {
        this.globalSharedLibrary.set(gsl);
    }

    public String getIntrospectorName() {
        return "ClassLoadingServiceIntrospector";
    }

    public String getIntrospectorDescription() {
        return "ClassLoadingService diagnostics - leaked/active TCCLs, active resource providers, etc.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void introspect(PrintWriter out) throws Exception {
        out.println("Resource Providers:");
        MultiMap<String, ResourceProvider> resourceProviderMap = this.resourceProviders.getProviderMap();
        for (String iterator : resourceProviderMap.keys()) {
            out.println("  " + iterator + " provided by:");
            for (ResourceProvider resourceProvider : resourceProviderMap.get(iterator)) {
                out.println("    " + resourceProvider);
            }
        }
        out.println();
        out.println();
        out.println("Gateway Loaders:");
        for (Map.Entry entry : this.classloaders.entrySet()) {
            Bundle bundle = (Bundle)entry.getKey();
            out.println("  " + bundle.getSymbolicName());
            for (Object gcl : (Set)entry.getValue()) {
                out.println("    " + ((GatewayClassLoader)gcl).getBundle().getSymbolicName() + " " + ((GatewayClassLoader)gcl).getApiTypeVisibility());
            }
        }
        out.println();
        out.println();
        Library gsl = this.globalSharedLibrary.get();
        if (gsl == null) {
            out.println("Global Shared Library not configured");
        } else {
            out.println("Global Shared Library contents:");
            out.println("  filesets:");
            for (Fileset fileset : gsl.getFilesets()) {
                String string = fileset.getDir();
                for (File file : fileset.getFileset()) {
                    out.println("    " + string + "  " + file.getPath());
                }
            }
            out.println("  folders:");
            for (File file : gsl.getFolders()) {
                out.println("    " + file.getAbsolutePath());
            }
            out.println("  files:");
            for (File file : gsl.getFiles()) {
                out.println("    " + file.getAbsolutePath());
            }
        }
        out.println();
        out.println();
        out.println("Existing appClassLoaders:");
        Set<AppClassLoader> set = this.appClassLoaders;
        synchronized (set) {
            for (AppClassLoader appClassLoader : this.appClassLoaders) {
                out.println("  " + appClassLoader.toDiagString());
            }
        }
        out.println();
        out.println();
        out.println("Leaked (or active) TCCLs - note that tracing must be enabled to see these stacks:");
        for (Map.Entry<ClassLoader, StackTraceElement[]> entry : this.leakDetectionMap.entrySet()) {
            ClassLoader classLoader = entry.getKey();
            StackTraceElement[] stes = entry.getValue();
            out.println("  " + classLoader + " created via");
            for (StackTraceElement ste : stes) {
                out.println("    " + ste.toString());
            }
        }
    }

    private void addAppExtensionLibs(ClassLoaderConfiguration config) {
        for (ApplicationExtensionLibrary appExt : this.appExtLibs) {
            config.addSharedLibraries(appExt.getReference().id());
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class ClassFileTransformerAdapter
    implements ClassFileTransformer {
        private final ClassTransformer transformer;
        static final long serialVersionUID = 1036452955082884629L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ClassFileTransformerAdapter(ClassTransformer transformer) {
            this.transformer = transformer;
        }

        @Override
        public byte[] transform(ClassLoader loader, String name, Class<?> classBeingRedefined, ProtectionDomain pd, byte[] bytes) throws IllegalClassFormatException {
            return this.transformer.transformClass(name, bytes, pd == null ? null : pd.getCodeSource(), loader);
        }

        public boolean equals(Object o) {
            return o instanceof ClassFileTransformerAdapter && ((ClassFileTransformerAdapter)o).transformer.equals(this.transformer);
        }

        public int hashCode() {
            return this.transformer.hashCode();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ClassFileTransformerAdapter.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }
}

