/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.internal.Util;
import com.ibm.ws.classloading.internal.util.MultiMap;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ResourceProvider;
import com.ibm.wsspi.kernel.service.utils.CompositeEnumeration;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class CompositeResourceProvider {
    private final ReadWriteLock lockFactory = new ReentrantReadWriteLock();
    private final MultiMap<String, ResourceProvider> providerMap = new MultiMap();
    static final long serialVersionUID = -5576435894946156347L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    CompositeResourceProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(ResourceProvider provider) {
        Lock lock = this.lockFactory.writeLock();
        lock.lock();
        try {
            for (String res : provider.getResourceNames()) {
                this.providerMap.add(Util.normalizeResourceName(res), provider);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ResourceProvider provider) {
        Lock lock = this.lockFactory.writeLock();
        lock.lock();
        try {
            for (String res : provider.getResourceNames()) {
                this.providerMap.remove(Util.normalizeResourceName(res), provider);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ResourceProvider> getProviders(String resourceName) {
        Lock lock = this.lockFactory.readLock();
        lock.lock();
        try {
            Set<ResourceProvider> set = this.providerMap.get(resourceName);
            return set;
        }
        finally {
            lock.unlock();
        }
    }

    URL findResource(String resourceName) throws SecurityException {
        resourceName = Util.normalizeResourceName(resourceName);
        for (ResourceProvider p : this.getProviders(resourceName)) {
            URL u = p.findResource(resourceName);
            if (u == null) continue;
            return u;
        }
        return null;
    }

    CompositeEnumeration<URL> findResources(String resourceName, CompositeEnumeration<URL> enumerations) throws SecurityException, IOException {
        resourceName = Util.normalizeResourceName(resourceName);
        for (ResourceProvider p : this.getProviders(resourceName)) {
            enumerations.add(p.findResources(resourceName));
        }
        return enumerations;
    }

    void clear() {
        this.providerMap.clear();
    }

    MultiMap<String, ResourceProvider> getProviderMap() {
        return this.providerMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CompositeResourceProvider.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    }
}

