/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.PolicyExecutorProvider;
import com.ibm.ws.threading.internal.ExecutorServiceImpl;
import com.ibm.ws.threading.internal.ThreadPoolController;
import com.ibm.wsspi.logging.Introspector;
import com.ibm.wsspi.threading.WSExecutorService;
import java.io.PrintWriter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ThreadingIntrospector
implements Introspector {
    private ExecutorServiceImpl impl;
    @Reference
    private PolicyExecutorProvider provider;
    static final long serialVersionUID = -2649808738402512382L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    protected void setWSExecutorService(WSExecutorService wses) {
        if (wses instanceof ExecutorServiceImpl) {
            this.impl = (ExecutorServiceImpl)wses;
        }
    }

    protected void unsetWSExecutorService(WSExecutorService wses) {
        this.impl = null;
    }

    public String getIntrospectorName() {
        return "ThreadingIntrospector";
    }

    public String getIntrospectorDescription() {
        return "Liberty threading diagnostics";
    }

    public void introspect(PrintWriter out) throws Exception {
        if (this.impl == null) {
            out.println("No ExecutorServiceImpl configured");
        } else {
            ThreadPoolController tpc = this.impl.threadPoolController;
            tpc.introspect(out);
        }
        out.println();
        this.provider.introspectPolicyExecutors(out);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ThreadingIntrospector.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
    }
}

