/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.Constants;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics.impl.SharedMetricRegistries;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Util {
    public static SharedMetricRegistries SHARED_METRIC_REGISTRIES;
    static final long serialVersionUID = -1377292082349528916L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Map<MetricID, Metric> getMetricsAsMap(String registryName, String metricName) throws NoSuchRegistryException, NoSuchMetricException, EmptyRegistryException {
        MetricRegistry registry = Util.getRegistry(registryName);
        Map metricMap = registry.getMetrics();
        HashMap<MetricID, Metric> returnMap = new HashMap<MetricID, Metric>();
        HashSet<MetricID> potentialMatches = new HashSet<MetricID>();
        for (MetricID tempmid : metricMap.keySet()) {
            if (!tempmid.getName().equals(metricName)) continue;
            potentialMatches.add(tempmid);
        }
        if (metricMap.isEmpty()) {
            throw new EmptyRegistryException();
        }
        if (potentialMatches.size() == 0) {
            throw new NoSuchMetricException();
        }
        for (MetricID tmid : potentialMatches) {
            returnMap.put(tmid, (Metric)metricMap.get(tmid));
        }
        return returnMap;
    }

    public static Map<MetricID, Metric> getMetricsAsMap(String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        MetricRegistry registry = Util.getRegistry(registryName);
        Map metricMap = registry.getMetrics();
        if (metricMap.isEmpty()) {
            throw new EmptyRegistryException();
        }
        return metricMap;
    }

    public static Map<String, Metadata> getMetricsMetadataAsMap(String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        MetricRegistry registry = Util.getRegistry(registryName);
        Map metricMetadataMap = registry.getMetadata();
        if (metricMetadataMap.isEmpty()) {
            throw new EmptyRegistryException();
        }
        return metricMetadataMap;
    }

    public static Map<String, Metadata> getMetricsMetadataAsMap(String registryName, String metricName) throws NoSuchRegistryException, EmptyRegistryException, NoSuchMetricException {
        MetricRegistry registry = Util.getRegistry(registryName);
        Map metricMetadataMap = registry.getMetadata();
        HashMap<String, Metadata> returnMap = new HashMap<String, Metadata>();
        if (metricMetadataMap.isEmpty()) {
            throw new EmptyRegistryException();
        }
        if (!metricMetadataMap.containsKey(metricName)) {
            throw new NoSuchMetricException();
        }
        returnMap.put(metricName, (Metadata)metricMetadataMap.get(metricName));
        return returnMap;
    }

    private static MetricRegistry getRegistry(String registryName) throws NoSuchRegistryException {
        if (!Constants.REGISTRY_NAMES_LIST.contains(registryName)) {
            throw new NoSuchRegistryException();
        }
        return SHARED_METRIC_REGISTRIES.getOrCreate(registryName);
    }

    public static Map<String, Number> getTimerNumbers(Timer timer, String tags, double conversionFactor) {
        HashMap<String, Number> results = new HashMap<String, Number>();
        results.put("count" + tags, timer.getCount());
        results.put("meanRate" + tags, timer.getMeanRate());
        results.put("oneMinRate" + tags, timer.getOneMinuteRate());
        results.put("fiveMinRate" + tags, timer.getFiveMinuteRate());
        results.put("fifteenMinRate" + tags, timer.getFifteenMinuteRate());
        results.put("max" + tags, (double)timer.getSnapshot().getMax() / conversionFactor);
        results.put("mean" + tags, timer.getSnapshot().getMean() / conversionFactor);
        results.put("min" + tags, (double)timer.getSnapshot().getMin() / conversionFactor);
        results.put("stddev" + tags, timer.getSnapshot().getStdDev() / conversionFactor);
        results.put("p50" + tags, timer.getSnapshot().getMedian() / conversionFactor);
        results.put("p75" + tags, timer.getSnapshot().get75thPercentile() / conversionFactor);
        results.put("p95" + tags, timer.getSnapshot().get95thPercentile() / conversionFactor);
        results.put("p98" + tags, timer.getSnapshot().get98thPercentile() / conversionFactor);
        results.put("p99" + tags, timer.getSnapshot().get99thPercentile() / conversionFactor);
        results.put("p999" + tags, timer.getSnapshot().get999thPercentile() / conversionFactor);
        return results;
    }

    public static Map<String, Number> getHistogramNumbers(Histogram histogram, String tags) {
        HashMap<String, Number> results = new HashMap<String, Number>();
        results.put("count" + tags, histogram.getCount());
        results.put("max" + tags, histogram.getSnapshot().getMax());
        results.put("mean" + tags, histogram.getSnapshot().getMean());
        results.put("min" + tags, histogram.getSnapshot().getMin());
        results.put("stddev" + tags, histogram.getSnapshot().getStdDev());
        results.put("p50" + tags, histogram.getSnapshot().getMedian());
        results.put("p75" + tags, histogram.getSnapshot().get75thPercentile());
        results.put("p95" + tags, histogram.getSnapshot().get95thPercentile());
        results.put("p98" + tags, histogram.getSnapshot().get98thPercentile());
        results.put("p99" + tags, histogram.getSnapshot().get99thPercentile());
        results.put("p999" + tags, histogram.getSnapshot().get999thPercentile());
        return results;
    }

    public static Map<String, Number> getMeterNumbers(Meter meter, String tags) {
        HashMap<String, Number> results = new HashMap<String, Number>();
        results.put("count" + tags, meter.getCount());
        results.put("meanRate" + tags, meter.getMeanRate());
        results.put("oneMinRate" + tags, meter.getOneMinuteRate());
        results.put("fiveMinRate" + tags, meter.getFiveMinuteRate());
        results.put("fifteenMinRate" + tags, meter.getFifteenMinuteRate());
        return results;
    }

    public static Map<String, Number> getConcurrentGaugeNumbers(ConcurrentGauge concurrentgauge, String tags) {
        HashMap<String, Number> results = new HashMap<String, Number>();
        results.put("current" + tags, concurrentgauge.getCount());
        results.put("min" + tags, concurrentgauge.getMin());
        results.put("max" + tags, concurrentgauge.getMax());
        return results;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(Util.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    }
}

