/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.microprofile.metrics.ConcurrentGauge;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConcurrentGaugeImpl
implements ConcurrentGauge {
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicLong max_previousMinute = new AtomicLong(0L);
    private final AtomicLong min_previousMinute = new AtomicLong(0L);
    private final AtomicLong max_thisMinute = new AtomicLong(0L);
    private final AtomicLong min_thisMinute = new AtomicLong(0L);
    private final AtomicLong thisMinute = new AtomicLong(this.getCurrentMinuteFromSystem());
    static final long serialVersionUID = 7766893192030949545L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inc() {
        this.maybeStartNewMinute();
        ConcurrentGaugeImpl concurrentGaugeImpl = this;
        synchronized (concurrentGaugeImpl) {
            long newCount = this.count.incrementAndGet();
            if (newCount > this.max_thisMinute.get()) {
                this.max_thisMinute.set(newCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dec() {
        this.maybeStartNewMinute();
        ConcurrentGaugeImpl concurrentGaugeImpl = this;
        synchronized (concurrentGaugeImpl) {
            long newCount = this.count.decrementAndGet();
            if (newCount < this.min_thisMinute.get()) {
                this.min_thisMinute.set(newCount);
            }
        }
    }

    public long getCount() {
        this.maybeStartNewMinute();
        return this.count.get();
    }

    public long getMax() {
        this.maybeStartNewMinute();
        return this.max_previousMinute.get();
    }

    public long getMin() {
        this.maybeStartNewMinute();
        return this.min_previousMinute.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeStartNewMinute() {
        long newMinute = this.getCurrentMinuteFromSystem();
        if (newMinute > this.thisMinute.get()) {
            ConcurrentGaugeImpl concurrentGaugeImpl = this;
            synchronized (concurrentGaugeImpl) {
                if (newMinute > this.thisMinute.get()) {
                    this.thisMinute.set(newMinute);
                    this.max_previousMinute.set(this.max_thisMinute.get());
                    this.min_previousMinute.set(this.min_thisMinute.get());
                    this.max_thisMinute.set(this.count.get());
                    this.min_thisMinute.set(this.count.get());
                }
            }
        }
    }

    private long getCurrentMinuteFromSystem() {
        return System.currentTimeMillis() / 60000L;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConcurrentGaugeImpl.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    }
}

