/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.j2ee.mejb.service;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ejbcontainer.osgi.EJBContainer;
import com.ibm.ws.ejbcontainer.osgi.EJBRemoteRuntime;
import com.ibm.ws.ejbcontainer.osgi.EJBSystemBeanConfig;
import com.ibm.ws.ejbcontainer.osgi.EJBSystemModule;
import com.ibm.ws.kernel.feature.ServerStarted;
import com.ibm.ws.management.j2ee.mejb.ManagementEJB;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.management.j2ee.Management;
import javax.management.j2ee.ManagementHome;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ManagementEJBService.class}, configurationPid={"com.ibm.ws.management.j2ee.mejb.service.ManagementEJBService"}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class ManagementEJBService {
    private static final TraceComponent tc = Tr.register(ManagementEJBService.class, (String)"mejb", (String)"com.ibm.ws.management.j2ee.mejb.resources.Messages");
    private static final String MODULE_NAME = "MEJB";
    private static final String BEAN_NAME = "ManagementEJB";
    private static final String BINDING_NAME = "ejb/mejb/MEJB";
    private EJBSystemModule ejbSystemModule;
    private EJBContainer ejbContainer;
    private EJBRemoteRuntime ejbRemoteRuntime;
    private volatile boolean isServerStarted;
    static final long serialVersionUID = 1554789857245921761L;

    @Reference(service=EJBContainer.class)
    protected synchronized void setEJBContainer(EJBContainer reference) {
        this.ejbContainer = reference;
        this.startManagementEJB();
    }

    protected synchronized void unsetEJBContainer(EJBContainer reference) {
        this.stopManagementEJB();
        this.ejbContainer = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected synchronized void setEJBRemoteRuntime(EJBRemoteRuntime ejbRemoteRuntime) {
        this.ejbRemoteRuntime = ejbRemoteRuntime;
        this.startManagementEJB();
    }

    protected synchronized void unsetEJBRemoteRuntime(EJBRemoteRuntime ejbRemoteRuntime) {
        this.stopManagementEJB();
        this.ejbRemoteRuntime = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected synchronized void setServerStarted(ServerStarted serverStarted) {
        this.isServerStarted = true;
        this.startManagementEJB();
    }

    protected synchronized void unsetServerStarted(ServerStarted serverStarted) {
        this.stopManagementEJB();
        this.isServerStarted = false;
    }

    private EJBSystemBeanConfig[] getEJBSystemBeanConfigs() {
        EJBSystemBeanConfig ejb = new EJBSystemBeanConfig(BEAN_NAME, ManagementEJB.class, BINDING_NAME, ManagementHome.class, Management.class);
        EJBSystemBeanConfig[] ejbs = new EJBSystemBeanConfig[]{ejb};
        return ejbs;
    }

    private void startManagementEJB() {
        if (this.isServerStarted && this.ejbRemoteRuntime != null && this.ejbContainer != null) {
            ClassLoader classLoader = ManagementEJBService.class.getClassLoader();
            EJBSystemBeanConfig[] ejbs = this.getEJBSystemBeanConfigs();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ejbs " + ejbs.length), (Object[])new Object[0]);
            }
            this.ejbSystemModule = this.ejbContainer.startSystemModule(MODULE_NAME, classLoader, ejbs, this.ejbRemoteRuntime);
            if (tc.isDebugEnabled()) {
                Tr.info((TraceComponent)tc, (String)"MANAGEMENT_EJB_SERVICE_ACTIVATED", (Object[])new Object[0]);
            }
        }
    }

    private void stopManagementEJB() {
        if (this.ejbSystemModule != null) {
            this.ejbSystemModule.stop();
            this.ejbSystemModule = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"MANAGEMENT_EJB_SERVICE_DEACTIVATED", (Object[])new Object[0]);
            }
        }
    }
}

