/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.AbstractRepositoryWrapper;
import com.ibm.ws.security.wim.Repository;
import com.ibm.ws.security.wim.RepositoryConfig;
import com.ibm.wsspi.security.wim.CustomRepository;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Control;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.PropertyControl;
import com.ibm.wsspi.security.wim.model.Root;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class CustomRepositoryWrapper
extends AbstractRepositoryWrapper {
    private final CustomRepositoryAdapter repository;
    static final long serialVersionUID = -5795453054501309796L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public CustomRepositoryWrapper(String repositoryId, CustomRepository customRepository) {
        super(repositoryId);
        this.repository = new CustomRepositoryAdapter(repositoryId, customRepository);
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    protected RepositoryConfig getRepositoryConfig() {
        return this.repository;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CustomRepositoryWrapper.class, (String)"wimUtil", (String)"com.ibm.ws.security.wim.util.resources.WimUtilMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class CustomRepositoryAdapter
    implements Repository,
    RepositoryConfig {
        private final CustomRepository customRepository;
        private final String repositoryId;
        static final long serialVersionUID = -6406077548508817664L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CustomRepositoryAdapter(String repositoryId, CustomRepository customRepository) {
            this.repositoryId = repositoryId;
            this.customRepository = customRepository;
        }

        @Override
        public Root create(Root root) throws WIMException {
            return this.setRepositoryId(this.customRepository.create(root));
        }

        @Override
        public Root delete(Root root) throws WIMException {
            return this.setRepositoryId(this.customRepository.delete(root));
        }

        @Override
        public Root get(Root root) throws WIMException {
            for (Control control : root.getControls()) {
                if (!(control instanceof PropertyControl)) continue;
                PropertyControl pControl = (PropertyControl)control;
                List properties = pControl.getProperties();
                if (properties == null || properties.isEmpty()) break;
                if (properties.contains("displayBridgePrincipalName")) {
                    properties.remove("displayBridgePrincipalName");
                    properties.add("principalName");
                }
                if (!properties.contains("displayBridgeCN")) break;
                properties.remove("displayBridgeCN");
                properties.add("cn");
                break;
            }
            return this.setRepositoryId(this.customRepository.get(root));
        }

        @Override
        public String getRealm() {
            return this.customRepository.getRealm();
        }

        @Override
        public String getReposId() {
            return this.repositoryId;
        }

        @Override
        public String[] getRepositoriesForGroups() {
            String[] repos = this.customRepository.getRepositoriesForGroups();
            if (repos == null) {
                repos = new String[]{this.repositoryId};
            }
            return repos;
        }

        @Override
        public Map<String, String> getRepositoryBaseEntries() {
            return this.customRepository.getRepositoryBaseEntries();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public Root login(Root root) throws WIMException {
            return this.setRepositoryId(this.customRepository.login(root));
        }

        @Override
        public void resetConfig() {
        }

        @Override
        public Root search(Root root) throws WIMException {
            return this.setRepositoryId(this.customRepository.search(root));
        }

        private Root setRepositoryId(Root root) {
            for (Entity entity : root.getEntities()) {
                IdentifierType identifier = entity.getIdentifier();
                if (identifier == null) continue;
                identifier.setRepositoryId(this.repositoryId);
            }
            return root;
        }

        @Override
        public Root update(Root root) throws WIMException {
            return this.setRepositoryId(this.customRepository.update(root));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CustomRepositoryAdapter.class, (String)"wimUtil", (String)"com.ibm.ws.security.wim.util.resources.WimUtilMessages");
        }
    }
}

