/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.wim.ConfiguredRepository;
import com.ibm.ws.security.wim.ConfiguredRepositoryWrapper;
import com.ibm.ws.security.wim.CustomRepositoryWrapper;
import com.ibm.ws.security.wim.Repository;
import com.ibm.ws.security.wim.RepositoryWrapper;
import com.ibm.ws.security.wim.UserRegistryWrapper;
import com.ibm.ws.security.wim.VMMService;
import com.ibm.ws.security.wim.adapter.urbridge.URBridge;
import com.ibm.ws.security.wim.util.UniqueNameHelper;
import com.ibm.wsspi.security.wim.CustomRepository;
import com.ibm.wsspi.security.wim.exception.InitializationException;
import com.ibm.wsspi.security.wim.exception.InvalidUniqueNameException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RepositoryManager {
    public static final String CLASSNAME = RepositoryManager.class.getName();
    public static final String ACTION_READ = "READ";
    public static final String ACTION_CREATE = "CREATE";
    public static final String ACTION_UPDATE = "UPDATE";
    public static final String ACTION_DELETE = "DELETE";
    private static final TraceComponent tc = Tr.register(RepositoryManager.class, (String)"wimUtil", (String)"com.ibm.ws.security.wim.util.resources.WimUtilMessages");
    private final VMMService vmmService;
    private volatile int numRepos = 0;
    private final Map<String, RepositoryWrapper> repositories = new ConcurrentHashMap<String, RepositoryWrapper>();
    static final long serialVersionUID = -5846991162115277243L;

    public RepositoryManager(VMMService service) {
        this.vmmService = service;
    }

    void addConfiguredRepository(String repositoryId, ConfiguredRepository configuredRepository) {
        ConfiguredRepositoryWrapper repositoryHolder = new ConfiguredRepositoryWrapper(repositoryId, configuredRepository);
        this.addRepository(repositoryId, repositoryHolder);
    }

    void addCustomRepository(String repositoryId, CustomRepository customRepository) {
        CustomRepositoryWrapper repositoryHolder = new CustomRepositoryWrapper(repositoryId, customRepository);
        this.addRepository(repositoryId, repositoryHolder);
    }

    private void addRepository(String repositoryId, RepositoryWrapper repositoryHolder) {
        this.repositories.put(repositoryId, repositoryHolder);
        this.numRepos = this.getNumberOfRepositories();
    }

    void addUserRegistry(UserRegistry userRegistry) {
        try {
            UserRegistryWrapper repositoryHolder = new UserRegistryWrapper(userRegistry, this.vmmService.getConfigManager());
            this.addRepository(userRegistry.getRealm(), repositoryHolder);
        }
        catch (InitializationException initializationException) {
            FFDCFilter.processException((Throwable)initializationException, (String)"com.ibm.ws.security.wim.RepositoryManager", (String)"87", (Object)this, (Object[])new Object[]{userRegistry});
        }
    }

    void removeRepositoryHolder(String id) {
        RepositoryWrapper repositoryHolder = this.repositories.remove(id);
        if (repositoryHolder != null) {
            repositoryHolder.clear();
        }
        this.numRepos = this.getNumberOfRepositories();
    }

    public Repository getRepository(String instanceId) {
        RepositoryWrapper repositoryHolder = this.repositories.get(instanceId);
        if (repositoryHolder != null) {
            return repositoryHolder.getRepository();
        }
        return null;
    }

    public Repository getTargetRepository(String uniqueName) throws WIMException {
        String reposId = this.getRepositoryIdByUniqueName(uniqueName);
        Repository repos = this.getRepository(reposId);
        return repos;
    }

    public String getRepositoryId(String uniqueName) throws WIMException {
        String reposId = this.getRepositoryIdByUniqueName(uniqueName);
        return reposId;
    }

    protected String getRepositoryIdByUniqueName(String uniqueName) throws WIMException {
        boolean isDn;
        boolean bl = isDn = UniqueNameHelper.isDN(uniqueName) != null;
        if (isDn) {
            uniqueName = UniqueNameHelper.getValidUniqueName(uniqueName).trim();
        }
        String repo = null;
        int repoMatch = -1;
        int bestMatch = -1;
        for (Map.Entry<String, RepositoryWrapper> entry : this.repositories.entrySet()) {
            repoMatch = entry.getValue().isUniqueNameForRepository(uniqueName, isDn);
            if (repoMatch == Integer.MAX_VALUE) {
                return entry.getKey();
            }
            if (repoMatch <= bestMatch) continue;
            repo = entry.getKey();
            bestMatch = repoMatch;
        }
        if (repo != null) {
            return repo;
        }
        AuditManager auditManager = new AuditManager();
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), auditManager.getRequestType(), auditManager.getRepositoryId(), uniqueName, this.vmmService.getConfigManager().getConfiguredPrimaryRealmName(), null, Integer.valueOf("204")});
        throw new InvalidUniqueNameException("ENTITY_NOT_IN_REALM_SCOPE", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_IN_REALM_SCOPE", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueName, (Object)"defined")));
    }

    public Map<String, List<String>> getRepositoriesBaseEntries() {
        HashMap<String, List<String>> reposNodesMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, RepositoryWrapper> entry : this.repositories.entrySet()) {
            reposNodesMap.put(entry.getKey(), new ArrayList<String>(entry.getValue().getRepositoryBaseEntries().keySet()));
        }
        return reposNodesMap;
    }

    public Map<String, String> getRepositoryBaseEntries(String reposId) throws WIMException {
        RepositoryWrapper repositoryHolder = this.repositories.get(reposId);
        if (repositoryHolder != null) {
            return repositoryHolder.getRepositoryBaseEntries();
        }
        return Collections.emptyMap();
    }

    public List<String> getRepoIds() {
        return new ArrayList<String>(this.repositories.keySet());
    }

    public int getNumberOfRepositories() {
        return this.getRepoIds().size();
    }

    @Trivial
    public int getNumberOfRepositoriesVolatile() throws WIMException {
        return this.numRepos;
    }

    public static boolean matchBaseEntryIgnoreCase(List<String> baseEntries, String baseEntry) {
        boolean result = false;
        if (baseEntries != null && baseEntry != null) {
            for (int i = 0; i < baseEntries.size(); ++i) {
                if (!baseEntry.equalsIgnoreCase(baseEntries.get(i))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean isPropertyJoin() {
        return false;
    }

    public boolean isEntryJoin() {
        return false;
    }

    public Map<String, List<String>> getBaseEntriesForRepos(String[] realmBaseEntries) throws WIMException {
        HashMap<String, List<String>> reposBaseEntries = new HashMap<String, List<String>>();
        for (String baseEntryName : realmBaseEntries) {
            String reposId = this.getRepositoryIdByUniqueName(baseEntryName);
            ArrayList<String> baseEntryList = (ArrayList<String>)reposBaseEntries.get(reposId);
            if (baseEntryList == null) {
                baseEntryList = new ArrayList<String>();
            }
            baseEntryList.add(baseEntryName);
            reposBaseEntries.put(reposId, baseEntryList);
        }
        return reposBaseEntries;
    }

    public boolean isReadOnly(String reposId) throws WIMException {
        return false;
    }

    public boolean isSortingSupported(String reposId) {
        return false;
    }

    private Map<String, Set<String>> getRepositoriesForGroup() {
        HashMap<String, Set<String>> repositoriesForGroup = new HashMap<String, Set<String>>();
        for (Map.Entry<String, RepositoryWrapper> entry : this.repositories.entrySet()) {
            repositoriesForGroup.put(entry.getKey(), entry.getValue().getRepositoryGroups());
        }
        return repositoriesForGroup;
    }

    public boolean isCrossRepositoryGroupMembership(String reposID) throws WIMException {
        String grpReposUUID;
        Map<String, Set<String>> repositoriesForGroup = this.getRepositoriesForGroup();
        int numOfReposForGrp = repositoriesForGroup.get(reposID).size();
        if (numOfReposForGrp > 1) {
            return true;
        }
        return numOfReposForGrp == 1 && !reposID.equals(grpReposUUID = repositoriesForGroup.get(reposID).iterator().next());
    }

    public Set<String> getRepositoriesForGroupMembership(String repositoryId) throws WIMException {
        RepositoryWrapper repositoryHolder = this.repositories.get(repositoryId);
        if (repositoryHolder != null) {
            return repositoryHolder.getRepositoryGroups();
        }
        return null;
    }

    private Map<String, Set<String>> getRepositoriesForGroupMembers() {
        HashMap<String, Set<String>> groupToRepositoryId = new HashMap<String, Set<String>>();
        for (Map.Entry<String, RepositoryWrapper> entry : this.repositories.entrySet()) {
            String repositoryid = entry.getKey();
            Set<String> groups = entry.getValue().getRepositoryGroups();
            for (String group : groups) {
                HashSet<String> repositoryIds = (HashSet<String>)groupToRepositoryId.get(group);
                if (repositoryIds == null) {
                    repositoryIds = new HashSet<String>();
                    groupToRepositoryId.put(group, repositoryIds);
                }
                repositoryIds.add(repositoryid);
            }
        }
        return groupToRepositoryId;
    }

    public boolean canGroupAcceptMember(String grpReposId, String mbrReposId) {
        Set<String> mbrReposIdSet;
        Map<String, Set<String>> repositoriesForGroupMembers = this.getRepositoriesForGroupMembers();
        if (repositoriesForGroupMembers != null && (mbrReposIdSet = repositoriesForGroupMembers.get(grpReposId)) != null) {
            return mbrReposIdSet.contains(mbrReposId);
        }
        return false;
    }

    public void clearAllCachedURRepositories() {
        for (RepositoryWrapper repositoryHolder : this.repositories.values()) {
            repositoryHolder.clear();
        }
    }

    public List<String> getFederationUREntityType(String data) {
        List<String> result = null;
        for (RepositoryWrapper rw : this.repositories.values()) {
            URBridge bridge;
            if (rw instanceof UserRegistryWrapper && (result = (bridge = (URBridge)((UserRegistryWrapper)rw).getRepository()).getEntityType(data)) != null) break;
        }
        return result;
    }
}

