/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.context.service.serializable;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.context.service.serializable.ThreadContextManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.ThreadContextDeserializationInfo;
import com.ibm.wsspi.threadcontext.ThreadContextProvider;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.RejectedExecutionException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ThreadContextDescriptorImpl
implements ThreadContextDescriptor,
ThreadContextDeserializationInfo {
    private static final TraceComponent tc = Tr.register(ThreadContextDescriptorImpl.class, (String)"context", (String)"com.ibm.ws.context.service.resources.CWWKCMessages");
    private final Map<String, String> execProps;
    private final String metaDataIdentifier;
    private ArrayList<String> providerNames;
    List<String> providerNamesToSkip;
    private ArrayList<ThreadContext> threadContext;
    private ThreadContextManager threadContextMgr;
    static final long serialVersionUID = -7343744414892349896L;

    /*
     * WARNING - void declaration
     */
    public ThreadContextDescriptorImpl(Map<String, String> execProps, @Sensitive byte[] bytes) throws ClassNotFoundException, IOException {
        final boolean trace = TraceComponent.isAnyTracingEnabled();
        execProps = execProps == null ? new TreeMap<String, String>() : new TreeMap<String, String>(execProps);
        this.execProps = execProps;
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytes));
        short numFields = oin.readShort();
        final byte[][] contextBytes = (byte[][])oin.readObject();
        this.metaDataIdentifier = numFields < 2 ? null : (String)oin.readObject();
        int numProviderNames = numFields < 3 ? 0 : oin.readShort();
        this.providerNames = new ArrayList(numProviderNames);
        for (int i = 0; i < numProviderNames; ++i) {
            String name = (String)oin.readObject();
            if (name.charAt(0) == '.' && name.charAt(name.length() - 1) == '.') {
                this.providerNames.add("com.ibm.ws" + name + "context.provider");
                continue;
            }
            this.providerNames.add(name);
        }
        oin.close();
        this.threadContext = new ArrayList(contextBytes.length);
        String skip = execProps.get("com.ibm.ws.concurrent.SKIP_CONTEXT_PROVIDERS");
        this.providerNamesToSkip = skip == null ? Collections.emptyList() : Arrays.asList(skip.split(","));
        final ServiceReference[] threadContextMgrRef = new ServiceReference[1];
        final BundleContext[] bundleContext = new BundleContext[1];
        boolean successful = false;
        try {
            ThreadContextProvider[] contextProviders = AccessController.doPrivileged(new PrivilegedExceptionAction<ThreadContextProvider[]>(){
                static final long serialVersionUID = -3785653293436033703L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ThreadContextProvider[] run() throws InvalidSyntaxException {
                    ThreadContextProvider[] contextProviders = new ThreadContextProvider[contextBytes.length];
                    bundleContext[0] = FrameworkUtil.getBundle(ThreadContextManager.class).getBundleContext();
                    threadContextMgrRef[0] = (ServiceReference)bundleContext[0].getServiceReferences(WSContextService.class, "(component.name=com.ibm.ws.context.manager)").iterator().next();
                    ThreadContextDescriptorImpl.this.threadContextMgr = (ThreadContextManager)bundleContext[0].getService(threadContextMgrRef[0]);
                    for (int i = 0; i < contextBytes.length; ++i) {
                        String providerName = (String)ThreadContextDescriptorImpl.this.providerNames.get(i);
                        ThreadContextProvider contextProvider = (ThreadContextProvider)((ThreadContextDescriptorImpl)ThreadContextDescriptorImpl.this).threadContextMgr.threadContextProviders.getService((Object)providerName);
                        if (contextProvider == null) {
                            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1004.context.provider.unavailable", (Object[])new Object[]{providerName}));
                        }
                        contextProviders[i] = contextProvider;
                        if (!trace || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)providerName, (Object[])new Object[]{contextProvider});
                    }
                    return contextProviders;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"context", (String)"com.ibm.ws.context.service.resources.CWWKCMessages");
                }
            });
            for (int i = 0; i < contextBytes.length; ++i) {
                ThreadContext context = contextProviders[i].deserializeThreadContext(this, contextBytes[i]);
                this.threadContext.add(context);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)contextProviders[i].toString(), (Object[])new Object[]{ThreadContextDescriptorImpl.toString(context)});
            }
            successful = true;
        }
        catch (PrivilegedActionException contextProviders) {
            void x;
            Object[] objectArray = new Object[2];
            objectArray[0] = execProps;
            objectArray[1] = "<sensitive byte[]>";
            FFDCFilter.processException((Throwable)contextProviders, (String)"com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl", (String)"168", (Object)this, (Object[])objectArray);
            throw new IOException(x.getCause());
        }
        finally {
            if (!successful && threadContextMgrRef[0] != null) {
                bundleContext[0].ungetService(threadContextMgrRef[0]);
            }
        }
    }

    @Trivial
    ThreadContextDescriptorImpl(Map<String, String> execProps, int initialCapacity, ThreadContextManager threadContextMgr) {
        this.execProps = execProps;
        this.providerNames = new ArrayList(initialCapacity);
        this.threadContext = new ArrayList(initialCapacity);
        this.threadContextMgr = threadContextMgr;
        String skip = execProps.get("com.ibm.ws.concurrent.SKIP_CONTEXT_PROVIDERS");
        this.providerNamesToSkip = skip == null ? Collections.emptyList() : Arrays.asList(skip.split(","));
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        this.metaDataIdentifier = cData == null ? null : threadContextMgr.metadataIdentifierService.getMetaDataIdentifier((MetaData)cData);
    }

    final void add(String providerName, ThreadContext context) {
        this.providerNames.add(providerName);
        this.threadContext.add(context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ThreadContextDescriptor clone() {
        try {
            ThreadContextDescriptorImpl clone = (ThreadContextDescriptorImpl)super.clone();
            clone.providerNames = new ArrayList<String>(clone.providerNames);
            clone.providerNamesToSkip = new ArrayList<String>(clone.providerNamesToSkip);
            clone.threadContext = new ArrayList<ThreadContext>(this.threadContext);
            return clone;
        }
        catch (CloneNotSupportedException clone) {
            void x;
            FFDCFilter.processException((Throwable)clone, (String)"com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl", (String)"217", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)x);
        }
    }

    @Trivial
    private static final boolean containsAll(LinkedHashMap<ThreadContextProvider, ThreadContext> contextProviders, List<ThreadContextProvider> prereqs) {
        for (ThreadContextProvider prereq : prereqs) {
            if (contextProviders.containsKey(prereq)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Trivial
    public final Map<String, String> getExecutionProperties() {
        return this.execProps;
    }

    public static void notAvailable(String jeeName, String taskName) {
        String message;
        int modSepIndex = jeeName.indexOf(35);
        if (modSepIndex == -1) {
            message = Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1011.app.unavailable", (Object[])new Object[]{taskName, jeeName});
        } else {
            String application = jeeName.substring(0, modSepIndex);
            int compSepIndex = jeeName.indexOf(35, modSepIndex + 1);
            if (compSepIndex == -1) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1012.module.unavailable", (Object[])new Object[]{taskName, jeeName.substring(modSepIndex + 1), application});
            } else {
                String module = jeeName.substring(modSepIndex + 1, compSepIndex);
                message = Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1013.component.unavailable", (Object[])new Object[]{taskName, jeeName.substring(compSepIndex + 1), module, application});
            }
        }
        throw new IllegalStateException(message);
    }

    @Override
    @Sensitive
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int size = this.threadContext.size();
        byte[][] contextBytes = new byte[size][];
        for (int i = 0; i < size; ++i) {
            bout.reset();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(this.threadContext.get(i));
            oout.flush();
            contextBytes[i] = bout.toByteArray();
            oout.close();
        }
        bout.reset();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeShort(3);
        oout.writeObject(contextBytes);
        oout.writeObject(this.metaDataIdentifier);
        oout.writeShort(this.providerNames.size());
        for (String providerName : this.providerNames) {
            if (providerName.startsWith("com.ibm.ws.") && providerName.endsWith(".context.provider")) {
                oout.writeObject(providerName.substring(10, providerName.length() - 16));
                continue;
            }
            oout.writeObject(providerName);
        }
        oout.flush();
        oout.close();
        return bout.toByteArray();
    }

    @Override
    public final void set(String providerName, ThreadContext context) {
        int index = this.providerNames.indexOf(providerName);
        if (index >= 0) {
            this.threadContext.set(index, context);
        } else {
            this.providerNames.add(providerName);
            this.threadContext.add(context);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayList<ThreadContext> taskStarting() throws RejectedExecutionException {
        String defaultContextTypes;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (!"false".equalsIgnoreCase(this.execProps.get("com.ibm.ws.concurrent.REQUIRE_AVAILABLE_APP")) && this.metaDataIdentifier != null && this.threadContextMgr.metadataIdentifierService.getMetaData(this.metaDataIdentifier) == null) {
            String taskName = this.execProps.get("javax.enterprise.concurrent.IDENTITY_NAME");
            ThreadContextDescriptorImpl.notAvailable(this.metaDataIdentifier, taskName);
        }
        final Set<Object> providerNamesForDefaultContext = "UNCONFIGURED_CONTEXT_TYPES".equals(defaultContextTypes = this.execProps.get("com.ibm.ws.concurrent.DEFAULT_CONTEXT")) || "ALL_CONTEXT_TYPES".equals(defaultContextTypes) ? new HashSet(this.threadContextMgr.threadContextProviders.keySet()) : Collections.emptySet();
        providerNamesForDefaultContext.removeAll(this.providerNamesToSkip);
        LinkedHashMap<ThreadContextProvider, ThreadContext> contextAppliedToThread = new LinkedHashMap<ThreadContextProvider, ThreadContext>();
        try {
            Map<ThreadContextProvider, ThreadContext> contextNotApplied = AccessController.doPrivileged(new PrivilegedAction<Map<ThreadContextProvider, ThreadContext>>(){
                static final long serialVersionUID = -2742201417361455820L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Map<ThreadContextProvider, ThreadContext> run() {
                    LinkedHashMap<ThreadContextProvider, ThreadContext> contextNotApplied = new LinkedHashMap<ThreadContextProvider, ThreadContext>();
                    for (int i = 0; i < ThreadContextDescriptorImpl.this.threadContext.size(); ++i) {
                        String providerName = (String)ThreadContextDescriptorImpl.this.providerNames.get(i);
                        providerNamesForDefaultContext.remove(providerName);
                        contextNotApplied.put((ThreadContextProvider)((ThreadContextDescriptorImpl)ThreadContextDescriptorImpl.this).threadContextMgr.threadContextProviders.getServiceWithException((Object)providerName), (ThreadContext)ThreadContextDescriptorImpl.this.threadContext.get(i));
                    }
                    for (String providerName : providerNamesForDefaultContext) {
                        contextNotApplied.put((ThreadContextProvider)((ThreadContextDescriptorImpl)ThreadContextDescriptorImpl.this).threadContextMgr.threadContextProviders.getServiceWithException((Object)providerName), null);
                    }
                    return contextNotApplied;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, (String)"context", (String)"com.ibm.ws.context.service.resources.CWWKCMessages");
                }
            });
            int count = contextNotApplied.size();
            int prev = count + 1;
            while (count > 0 && count < prev) {
                Iterator<Map.Entry<ThreadContextProvider, ThreadContext>> it = contextNotApplied.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<ThreadContextProvider, ThreadContext> entry = it.next();
                    ThreadContextProvider provider = entry.getKey();
                    List<ThreadContextProvider> prereqs = provider.getPrerequisites();
                    if (prereqs != null && !ThreadContextDescriptorImpl.containsAll(contextAppliedToThread, prereqs)) continue;
                    ThreadContext context = entry.getValue();
                    ThreadContext threadContext = context = context == null ? provider.createDefaultThreadContext(this.execProps) : context.clone();
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("taskStarting " + ThreadContextDescriptorImpl.toString(context)), (Object[])new Object[0]);
                    }
                    context.taskStarting();
                    contextAppliedToThread.put(provider, context);
                    it.remove();
                }
                prev = count;
                count = contextNotApplied.size();
            }
            if (contextNotApplied.size() > 0) {
                throw new IllegalStateException(contextNotApplied.keySet().toString());
            }
        }
        catch (Throwable contextNotApplied) {
            void x;
            FFDCFilter.processException((Throwable)contextNotApplied, (String)"com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl", (String)"402", (Object)this, (Object[])new Object[0]);
            ArrayList contextToRemove = new ArrayList(contextAppliedToThread.values());
            for (int c = contextToRemove.size() - 1; c >= 0; --c) {
                try {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("taskStopping " + ThreadContextDescriptorImpl.toString((ThreadContext)contextToRemove.get(c))), (Object[])new Object[0]);
                    }
                    ((ThreadContext)contextToRemove.get(c)).taskStopping();
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl", (String)"410", (Object)this, (Object[])new Object[0]);
                }
            }
            if (x instanceof RejectedExecutionException) {
                throw (RejectedExecutionException)x;
            }
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            if (x instanceof Error) {
                throw (Error)x;
            }
            throw new RejectedExecutionException((Throwable)x);
        }
        return new ArrayList<ThreadContext>(contextAppliedToThread.values());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void taskStopping(ArrayList<ThreadContext> threadContext) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Throwable failure = null;
        for (int c = threadContext.size() - 1; c >= 0; --c) {
            try {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("taskStopping " + ThreadContextDescriptorImpl.toString(threadContext.get(c))), (Object[])new Object[0]);
                }
                threadContext.get(c).taskStopping();
                continue;
            }
            catch (Throwable throwable) {
                void x;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl", (String)"440", (Object)this, (Object[])new Object[]{threadContext});
                if (failure != null) continue;
                failure = x;
            }
        }
        if (failure != null) {
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure instanceof Error) {
                throw (Error)failure;
            }
            throw new RuntimeException(failure);
        }
    }

    @Trivial
    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + this.providerNames;
    }

    @Trivial
    private static String toString(ThreadContext c) {
        if (c == null) {
            return null;
        }
        String s = c.toString();
        if (s.indexOf(64) < 0) {
            s = c.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(c)) + ':' + s;
        }
        return s;
    }

    @Override
    public String getExecutionProperty(String name) {
        return this.execProps.get(name);
    }

    @Override
    public String getMetadataIdentifier() {
        return this.metaDataIdentifier;
    }
}

