/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer40.srt;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.websphere.servlet40.IRequest40;
import com.ibm.ws.webcontainer31.osgi.srt.SRTConnectionContext31;
import com.ibm.ws.webcontainer31.srt.SRTServletRequest31;
import com.ibm.ws.webcontainer40.osgi.srt.SRTConnectionContext40;
import com.ibm.ws.webcontainer40.osgi.webapp.WebAppDispatcherContext40;
import com.ibm.ws.webcontainer40.srt.SRTServletResponse40;
import com.ibm.ws.webcontainer40.srt.http.HttpPushBuilder;
import com.ibm.ws.webcontainer40.srt.http.HttpServletMappingImpl;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.ee8.Http2Request;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer40.WCCustomProperties40;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletMapping;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.MappingMatch;
import javax.servlet.http.PushBuilder;

public class SRTServletRequest40
extends SRTServletRequest31
implements HttpServletRequest {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer40.srt");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer40.srt.SRTServletRequest40";
    private boolean _sessionCreated;
    private Enumeration<String> _pushBuilderHeaders;
    private static ArrayList<String> _disallowedPushBuilderHeaders = new ArrayList();
    HashMap<String, String> _trailers;

    public SRTServletRequest40(SRTConnectionContext40 context) {
        super((SRTConnectionContext31)context);
    }

    public void initForNextRequest(IRequest req) {
        String methodName = "initForNextRequest";
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, methodName, "this->" + (Object)((Object)this) + " :  req->" + req);
        }
        this._sessionCreated = false;
        super.initForNextRequest(req);
        this._pushBuilderHeaders = null;
        this._trailers = null;
    }

    public HttpServletMapping getHttpServletMapping() {
        WebAppDispatcherContext40 dispatchContext;
        HttpServletMapping returnMapping;
        String methodName = "getHttpServletMapping";
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, methodName);
        }
        if ((returnMapping = (dispatchContext = (WebAppDispatcherContext40)this.getDispatchContext()).getServletMapping()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "existing mapping found. Servlet name = " + returnMapping.getServletName());
            }
            return returnMapping;
        }
        return this.getCurrentHttpServletMapping(dispatchContext);
    }

    public HttpServletMapping getCurrentHttpServletMapping(WebAppDispatcherContext40 dispatchContext) {
        String methodName = "getCurrentHttpServletMapping";
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, methodName + " dispatchContext -> " + (Object)((Object)dispatchContext));
        }
        HttpServletMappingImpl returnMapping = null;
        if (dispatchContext.getMappingMatch() != null) {
            String matchValue;
            IServletWrapper servletRef = dispatchContext.getCurrentServletReference();
            String servletName = null;
            if (servletRef != null) {
                servletName = servletRef.getServletName();
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "servletName was set to: " + servletName);
            }
            String pathInfo = dispatchContext.getPathInfoForMapping();
            String servletPath = dispatchContext.getServletPathForMapping();
            if (pathInfo == null) {
                pathInfo = "";
            }
            if (servletPath == null) {
                servletPath = "";
            }
            if ((matchValue = servletPath + pathInfo).startsWith("/")) {
                matchValue = matchValue.substring(1, matchValue.length());
            }
            String pattern = "/";
            switch (dispatchContext.getMappingMatch()) {
                case CONTEXT_ROOT: {
                    returnMapping = new HttpServletMappingImpl(MappingMatch.CONTEXT_ROOT, "", "", servletName);
                    break;
                }
                case DEFAULT: {
                    returnMapping = new HttpServletMappingImpl(MappingMatch.DEFAULT, "", pattern, servletName);
                    break;
                }
                case EXACT: {
                    pattern = servletPath + pathInfo;
                    returnMapping = new HttpServletMappingImpl(MappingMatch.EXACT, matchValue, pattern, servletName);
                    break;
                }
                case EXTENSION: {
                    matchValue = matchValue.substring(0, matchValue.indexOf("."));
                    pattern = "*" + servletPath.substring(servletPath.indexOf("."), servletPath.length());
                    returnMapping = new HttpServletMappingImpl(MappingMatch.EXTENSION, matchValue, pattern, servletName);
                    break;
                }
                case PATH: {
                    if (!dispatchContext.hasSlashStarMapping()) {
                        matchValue = pathInfo.substring(pathInfo.lastIndexOf("/") + 1, pathInfo.length());
                    }
                    pattern = servletPath + "/*";
                    returnMapping = new HttpServletMappingImpl(MappingMatch.PATH, matchValue, pattern, servletName);
                    break;
                }
                default: {
                    returnMapping = new HttpServletMappingImpl(null, "", "", "");
                    break;
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "matching match not found.");
            }
            returnMapping = new HttpServletMappingImpl(null, "", "", "");
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, methodName);
        }
        return returnMapping;
    }

    public PushBuilder newPushBuilder() {
        IRequest40 iRequest;
        String methodName = "newPushBuilder";
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, methodName, "this -> " + (Object)((Object)this));
        }
        if (!((Http2Request)(iRequest = (IRequest40)this.getIRequest()).getHttpRequest()).isPushSupported()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "push not supported");
            }
            return null;
        }
        String sessionID = null;
        sessionID = this._sessionCreated ? this.getSession(false).getId() : this.getRequestedSessionId();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, methodName, "sessionId = " + sessionID);
        }
        SRTServletResponse40 response = (SRTServletResponse40)this._connContext.getResponse();
        HttpPushBuilder pb = new HttpPushBuilder(this, sessionID, this.getPushBuilderHeaders(), response.getAddedCookies());
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, methodName);
        }
        return pb;
    }

    public HttpSession getSession(boolean create) {
        HttpSession session;
        String methodName = "getSession";
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, methodName, "create " + String.valueOf(create) + ", this -> " + (Object)((Object)this));
        }
        if ((session = super.getSession(create)) != null) {
            this._sessionCreated = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, methodName, "_sessionCreated " + this._sessionCreated + ", this -> " + (Object)((Object)this));
        }
        return session;
    }

    private Enumeration<String> getPushBuilderHeaders() {
        if (this._pushBuilderHeaders == null) {
            ArrayList<String> pushBuilderHeaderNames = new ArrayList<String>();
            Enumeration allHeaders = this.getHeaderNames();
            while (allHeaders.hasMoreElements()) {
                String headerName = (String)allHeaders.nextElement();
                if (_disallowedPushBuilderHeaders.contains(headerName)) continue;
                pushBuilderHeaderNames.add(headerName);
            }
            this._pushBuilderHeaders = Collections.enumeration(pushBuilderHeaderNames);
        }
        return this._pushBuilderHeaders;
    }

    public String getCharacterEncoding() {
        String _encoding;
        String methodName = "getCharacterEncoding";
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, methodName, "this -> " + (Object)((Object)this));
        }
        if ((_encoding = super.getSrtHelperCharEncoding()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "returns -> " + _encoding);
            }
            return _encoding;
        }
        String type = this.getContentType();
        int index = -1;
        if (type != null) {
            index = type.indexOf("charset=");
        }
        if ((_encoding = SRTServletRequest40.getEncodingFromContentType((String)type, (int)index)) != null) {
            try {
                this.setCharacterEncoding(_encoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.logp(Level.INFO, CLASS_NAME, methodName, "Unable to set request character encoding based upon request header ", e);
            }
        }
        if (_encoding == null && (_encoding = this.getDispatchContext().getWebApp().getConfiguration().getModuleRequestEncoding()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "Encoding from web module ->[" + _encoding + "]");
            }
            try {
                this.setCharacterEncoding(_encoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.logp(Level.INFO, CLASS_NAME, methodName, "Unable to set request character encoding", e);
            }
        }
        if (_encoding == null && (_encoding = WCCustomProperties40.SERVER_REQUEST_ENCODING) != null && !_encoding.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, methodName, "Encoding from WC property->[" + _encoding + "]");
            }
            try {
                this.setCharacterEncoding(_encoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.logp(Level.INFO, CLASS_NAME, methodName, "Unable to set request character encoding", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, methodName, "encoding -> " + _encoding);
        }
        return _encoding;
    }

    public Map<String, String> getTrailerFields() throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getTrailerFields", "this -> " + (Object)((Object)this));
        }
        if (!this.isTrailerFieldsReady()) {
            throw new IllegalStateException();
        }
        if (this._trailers == null) {
            IRequest40 request = (IRequest40)this.getIRequest();
            this._trailers = request.getTrailers();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getTrailerFields", "number of trailers -> " + this._trailers.size());
        }
        return this._trailers;
    }

    public boolean isTrailerFieldsReady() {
        IRequest40 request = (IRequest40)this.getIRequest();
        return request.getHttpRequest().isTrailersReady();
    }

    static {
        _disallowedPushBuilderHeaders.add(HttpHeaderKeys.HDR_IF_MATCH.getName());
        _disallowedPushBuilderHeaders.add(HttpHeaderKeys.HDR_IF_MODIFIED_SINCE.getName());
        _disallowedPushBuilderHeaders.add(HttpHeaderKeys.HDR_IF_NONE_MATCH.getName());
        _disallowedPushBuilderHeaders.add(HttpHeaderKeys.HDR_IF_RANGE.getName());
        _disallowedPushBuilderHeaders.add(HttpHeaderKeys.HDR_IF_UNMODIFIED_SINCE.getName());
        _disallowedPushBuilderHeaders.add(HttpHeaderKeys.HDR_RANGE.getName());
        _disallowedPushBuilderHeaders.add(HttpHeaderKeys.HDR_EXPECT.getName());
        _disallowedPushBuilderHeaders.add(HttpHeaderKeys.HDR_AUTHORIZATION.getName());
        _disallowedPushBuilderHeaders.add(HttpHeaderKeys.HDR_REFERER.getName());
        _disallowedPushBuilderHeaders.add(HttpHeaderKeys.HDR_UPGRADE.getName());
        _disallowedPushBuilderHeaders.add(HttpHeaderKeys.HDR_HTTP2_SETTINGS.getName());
        _disallowedPushBuilderHeaders.add(HttpHeaderKeys.HDR_CONNECTION.getName());
    }
}

