/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.cdi.beans;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.CDIHelper;
import com.ibm.wsspi.security.registry.RegistryHelper;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.credential.BasicAuthenticationCredential;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.IdentityStoreHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Utils {
    private static final TraceComponent tc = Tr.register(Utils.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
    private boolean logNoIDInfo = false;
    static final long serialVersionUID = 7719278886142842682L;

    protected AuthenticationStatus validateUserAndPassword(CDI cdi, String realmName, Subject clientSubject, @Sensitive UsernamePasswordCredential credential, HttpMessageContext httpMessageContext) throws AuthenticationException {
        return this.validateCredential(cdi, realmName, clientSubject, (Credential)credential, httpMessageContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AuthenticationStatus validateCredential(CDI cdi, String realmName, Subject clientSubject, @Sensitive Credential credential, HttpMessageContext httpMessageContext) throws AuthenticationException {
        AuthenticationStatus status = AuthenticationStatus.SEND_FAILURE;
        if (this.isIdentityStoreAvailable(cdi)) {
            IdentityStoreHandler identityStoreHandler = this.getIdentityStoreHandler(cdi);
            if (identityStoreHandler != null) {
                return this.validateWithIdentityStore(realmName, clientSubject, credential, identityStoreHandler);
            }
            if (!tc.isDebugEnabled()) throw new AuthenticationException("No IdentityStoreHandler found");
            Tr.debug((TraceComponent)tc, (String)"IdentityStoreHandler bean is not found. ", (Object[])new Object[0]);
            throw new AuthenticationException("No IdentityStoreHandler found");
        }
        if (!this.logNoIDInfo) {
            Tr.info((TraceComponent)tc, (String)"JAVAEESEC_CDI_INFO_NO_IDENTITY_STORE", (Object[])new Object[0]);
            this.logNoIDInfo = true;
        }
        if (!this.isRegistryAvailable()) return AuthenticationStatus.NOT_DONE;
        return this.validateWithUserRegistry(clientSubject, credential, httpMessageContext.getHandler());
    }

    protected AuthenticationStatus handleAuthenticate(CDI cdi, String realmName, @Sensitive Credential credential, Subject clientSubject, HttpMessageContext httpMessageContext) throws AuthenticationException {
        AuthenticationStatus status = AuthenticationStatus.SEND_FAILURE;
        status = this.validateCredential(cdi, realmName, clientSubject, credential, httpMessageContext);
        if (status == AuthenticationStatus.SUCCESS) {
            httpMessageContext.getMessageInfo().getMap().put("javax.servlet.http.authType", "JASPI_AUTH");
        }
        return status;
    }

    public AuthenticationStatus validateWithIdentityStore(String realmName, Subject clientSubject, @Sensitive Credential credential, IdentityStoreHandler identityStoreHandler) {
        AuthenticationStatus status = AuthenticationStatus.SEND_FAILURE;
        CredentialValidationResult result = identityStoreHandler.validate(credential);
        if (result.getStatus() == CredentialValidationResult.Status.VALID) {
            this.setLoginHashtable(realmName, clientSubject, result);
            status = AuthenticationStatus.SUCCESS;
        } else if (result.getStatus() == CredentialValidationResult.Status.NOT_VALIDATED) {
            status = AuthenticationStatus.NOT_DONE;
        }
        return status;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AuthenticationStatus validateWithUserRegistry(Subject clientSubject, @Sensitive Credential credential, CallbackHandler handler) throws AuthenticationException {
        AuthenticationStatus status = AuthenticationStatus.SEND_FAILURE;
        if (handler == null) return status;
        if (this.isSupportedCredential(credential)) {
            PasswordValidationCallback pwcb = new PasswordValidationCallback(clientSubject, ((UsernamePasswordCredential)credential).getCaller(), ((UsernamePasswordCredential)credential).getPassword().getValue());
            try {
                handler.handle(new Callback[]{pwcb});
                boolean isValidPassword = pwcb.getResult();
                if (!isValidPassword) return status;
                return AuthenticationStatus.SUCCESS;
            }
            catch (Exception isValidPassword) {
                void e;
                Object[] objectArray = new Object[3];
                objectArray[0] = clientSubject;
                objectArray[1] = "<sensitive javax.security.enterprise.credential.Credential>";
                objectArray[2] = handler;
                FFDCFilter.processException((Throwable)isValidPassword, (String)"com.ibm.ws.security.javaeesec.cdi.beans.Utils", (String)"123", (Object)this, (Object[])objectArray);
                throw new AuthenticationException(e.toString());
            }
        }
        Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_UNSUPPORTED_CRED", (Object[])new Object[]{credential.getClass().getName()});
        String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_UNSUPPORTED_CRED", (Object[])new Object[]{credential.getClass().getName()});
        throw new AuthenticationException(msg);
    }

    private void setLoginHashtable(String realmName, Subject clientSubject, CredentialValidationResult result) {
        Hashtable<String, Object> subjectHashtable = this.getSubjectHashtable(clientSubject);
        String callerPrincipalName = result.getCallerPrincipal().getName();
        String callerUniqueId = result.getCallerUniqueId();
        String realm = result.getIdentityStoreId();
        String string = realm = realm != null ? realm : realmName;
        if (realm == null || realm.isEmpty()) {
            realm = "defaultRealm";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The realm name is not defined, \"defaultRealm\" is used.", (Object[])new Object[0]);
            }
        }
        String uniqueId = callerUniqueId != null ? callerUniqueId : callerPrincipalName;
        this.setCommonAttributes(subjectHashtable, realm, callerPrincipalName);
        this.setUniqueId(subjectHashtable, realm, uniqueId);
        this.setGroups(subjectHashtable, result.getCallerGroups());
        subjectHashtable.put("com.ibm.wsspi.security.cred.cacheKey", String.valueOf(subjectHashtable.hashCode()));
    }

    private void setCommonAttributes(Hashtable<String, Object> subjectHashtable, String realm, String callerPrincipalName) {
        subjectHashtable.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
        subjectHashtable.put("com.ibm.wsspi.security.cred.realm", realm);
        subjectHashtable.put("com.ibm.wsspi.security.cred.userId", callerPrincipalName);
        subjectHashtable.put("com.ibm.wsspi.security.cred.securityName", callerPrincipalName);
    }

    private void setUniqueId(Hashtable<String, Object> subjectHashtable, String realm, String uniqueId) {
        String accessId = "user:" + realm + "/" + uniqueId;
        subjectHashtable.put("com.ibm.wsspi.security.cred.uniqueId", accessId);
    }

    private void setGroups(Hashtable<String, Object> subjectHashtable, Set<String> groups) {
        if (groups != null && !groups.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding groups found in an identitystore", (Object[])new Object[]{groups});
            }
            subjectHashtable.put("com.ibm.wsspi.security.cred.groups", new ArrayList<String>(groups));
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No group  found in an identitystore", (Object[])new Object[0]);
            }
            subjectHashtable.put("com.ibm.wsspi.security.cred.groups", new ArrayList());
        }
    }

    private Hashtable<String, Object> getSubjectHashtable(Subject clientSubject) {
        Hashtable<String, Object> subjectHashtable = this.getSubjectExistingHashtable(clientSubject);
        if (subjectHashtable == null) {
            subjectHashtable = this.createNewSubjectHashtable(clientSubject);
        }
        return subjectHashtable;
    }

    public Hashtable<String, Object> getSubjectExistingHashtable(final Subject clientSubject) {
        if (clientSubject == null) {
            return null;
        }
        PrivilegedAction<Hashtable<String, Object>> action = new PrivilegedAction<Hashtable<String, Object>>(){
            static final long serialVersionUID = 6465427640815995979L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Hashtable<String, Object> run() {
                Set<Hashtable> hashtables = clientSubject.getPrivateCredentials(Hashtable.class);
                if (hashtables == null || hashtables.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Subject has no Hashtable with custom credentials, return null.", (Object[])new Object[0]);
                    }
                    return null;
                }
                Hashtable hashtable = hashtables.iterator().next();
                return hashtable;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
            }
        };
        Hashtable<String, Object> cred = AccessController.doPrivileged(action);
        return cred;
    }

    public Hashtable<String, Object> createNewSubjectHashtable(final Subject clientSubject) {
        PrivilegedAction<Hashtable<String, Object>> action = new PrivilegedAction<Hashtable<String, Object>>(){
            static final long serialVersionUID = -7365263597260288116L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Hashtable<String, Object> run() {
                Hashtable<String, Object> newCred = new Hashtable<String, Object>();
                clientSubject.getPrivateCredentials().add(newCred);
                return newCred;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
            }
        };
        return AccessController.doPrivileged(action);
    }

    public IdentityStoreHandler getIdentityStoreHandler(CDI cdi) {
        IdentityStoreHandler identityStoreHandler = null;
        Instance storeHandlerInstance = cdi.select(IdentityStoreHandler.class, new Annotation[0]);
        if (!storeHandlerInstance.isUnsatisfied() && !storeHandlerInstance.isAmbiguous()) {
            identityStoreHandler = (IdentityStoreHandler)storeHandlerInstance.get();
        }
        if (identityStoreHandler == null && !cdi.getBeanManager().equals(CDIHelper.getBeanManager())) {
            identityStoreHandler = (IdentityStoreHandler)CDIHelper.getBeanFromCurrentModule(IdentityStoreHandler.class);
        }
        return identityStoreHandler;
    }

    public boolean isIdentityStoreAvailable(CDI cdi) {
        Instance identityStoreInstances = cdi.select(IdentityStore.class, new Annotation[0]);
        if (identityStoreInstances != null && !identityStoreInstances.isUnsatisfied() && !identityStoreInstances.isAmbiguous()) {
            return true;
        }
        return !cdi.getBeanManager().equals(CDIHelper.getBeanManager()) && !CDIHelper.getBeansFromCurrentModule(IdentityStore.class).isEmpty();
    }

    private boolean isSupportedCredential(@Sensitive Credential cred) {
        return cred != null && (cred instanceof UsernamePasswordCredential || cred instanceof BasicAuthenticationCredential);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isRegistryAvailable() {
        try {
            return RegistryHelper.getUserRegistry(null) != null;
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.javaeesec.cdi.beans.Utils", (String)"273", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Internal error getting the user registry", (Object[])new Object[]{e});
            }
            return true;
        }
    }
}

