/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.webcontainer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.endpoint.JaxWsWebEndpoint;
import com.ibm.ws.jaxws.webcontainer.JaxWsHttpServletRequestAdapter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppNameSpaceCollaborator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyJaxWsServlet
extends HttpServlet {
    private static final long serialVersionUID = -6835560282014155024L;
    private static final List<String> KNOWN_HTTP_VERBS;
    private static final String HTML_CONTENT_TYPE = "text/html";
    private final transient JaxWsWebEndpoint endpoint;
    private final transient IWebAppNameSpaceCollaborator collaborator;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public LibertyJaxWsServlet(JaxWsWebEndpoint endpoint) {
        this(endpoint, null);
    }

    public LibertyJaxWsServlet(JaxWsWebEndpoint endpoint, IWebAppNameSpaceCollaborator collaborator) {
        this.endpoint = endpoint;
        this.collaborator = collaborator;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.endpoint.init(servletConfig);
    }

    /*
     * WARNING - void declaration
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletResponse response;
        HttpServletRequest request;
        try {
            request = (HttpServletRequest)req;
            if (this.collaborator != null) {
                ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                request = new JaxWsHttpServletRequestAdapter(request, this.collaborator, componentMetaData);
            }
            response = (HttpServletResponse)res;
        }
        catch (ClassCastException componentMetaData) {
            void e;
            FFDCFilter.processException((Throwable)componentMetaData, (String)"com.ibm.ws.jaxws.webcontainer.LibertyJaxWsServlet", (String)"79", (Object)((Object)this), (Object[])new Object[]{req, res});
            throw new ServletException("Unrecognized HTTP request or response object", (Throwable)e);
        }
        String method = request.getMethod();
        if (KNOWN_HTTP_VERBS.contains(method)) {
            super.service(request, response);
        } else {
            this.handleRequest(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (null == request.getQueryString()) {
            this.reportAvailableService(request, response);
        } else {
            this.handleRequest(request, response);
        }
    }

    private void reportAvailableService(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        response.setContentType(HTML_CONTENT_TYPE);
        writer.println("<h2>" + request.getServletPath() + "</h2>");
        writer.println("<h3>Hello! This is a CXF Web Service!</h3>");
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.endpoint.invoke(request, response);
    }

    public void destroy() {
        this.endpoint.destroy();
        super.destroy();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(LibertyJaxWsServlet.class, (String)"JaxWsWebContainer", (String)"com.ibm.ws.jaxws.webcontainer.internal.resources.JaxWsWebContainerMessages");
        KNOWN_HTTP_VERBS = Arrays.asList("POST", "GET", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE");
    }
}

