/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.security.fallback;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.cdi.internal.interfaces.SecurityContextStore;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.cdi.security.fallback.FallbackContextStore", immediate=true, property={"service.vendor=IBM", "service.ranking:Integer=-1"})
public class FallbackContextStore
implements SecurityContextStore {
    private static final TraceComponent tc = Tr.register(FallbackContextStore.class, null, null);
    static final String KEY_UNAUTH_SERVICE = "unauthenticatedSubjectServiceRef";
    private final AtomicServiceReference<UnauthenticatedSubjectService> unauthenticatedSubjectServiceRef = new AtomicServiceReference("unauthenticatedSubjectServiceRef");
    static final long serialVersionUID = 6403752923454840860L;

    protected void activate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Activating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.unauthenticatedSubjectServiceRef.activate(compcontext);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.unauthenticatedSubjectServiceRef.deactivate(compcontext);
    }

    @Reference(service=UnauthenticatedSubjectService.class, name="unauthenticatedSubjectServiceRef")
    protected void setUnauthenticatedSubjectService(ServiceReference<UnauthenticatedSubjectService> ref) {
        this.unauthenticatedSubjectServiceRef.setReference(ref);
    }

    protected void unsetUnauthenticatedSubjectService(ServiceReference<UnauthenticatedSubjectService> ref) {
        this.unauthenticatedSubjectServiceRef.unsetReference(ref);
    }

    public Principal getCurrentPrincipal() {
        Principal principal = AccessController.doPrivileged(new PrivilegedAction<Principal>(){
            static final long serialVersionUID = -1107395172221844239L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Principal run() {
                Principal principal = FallbackContextStore.this.getPrincipalFromWSSubject();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Principal from WSSubject : {0}", (Object[])new Object[]{principal});
                }
                return principal;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, null, null);
            }
        });
        if (principal == null) {
            principal = this.getUnauthenticatedPrincipal();
        }
        return principal;
    }

    /*
     * WARNING - void declaration
     */
    private Principal getPrincipalFromWSSubject() {
        Subject subject;
        Principal principal;
        block6: {
            principal = null;
            subject = null;
            try {
                subject = WSSubject.getRunAsSubject();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Current subject: ", (Object[])new Object[]{subject});
                }
            }
            catch (WSSecurityException wSSecurityException) {
                void e;
                FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.cdi.security.fallback.FallbackContextStore", (String)"109", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"Failed to get current subject", (Object[])new Object[]{e});
            }
        }
        if (subject != null) {
            Set<Principal> principals = subject.getPrincipals();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Number of principals: ", (Object[])new Object[]{principals.size()});
            }
            if (!principals.isEmpty()) {
                principal = principals.iterator().next();
            }
        }
        return principal;
    }

    private Principal getUnauthenticatedPrincipal() {
        UnauthenticatedSubjectService uss;
        Set<Principal> principals;
        if (this.unauthenticatedSubjectServiceRef.getService() != null && !(principals = (uss = (UnauthenticatedSubjectService)this.unauthenticatedSubjectServiceRef.getService()).getUnauthenticatedSubject().getPrincipals()).isEmpty()) {
            return principals.iterator().next();
        }
        return null;
    }
}

