/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayDeque;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServiceRegistrationModifier<S> {
    private final ArrayDeque<Boolean> modifyQueue = new ArrayDeque();
    private final Lock modifyLock = new ReentrantLock();
    private final Class<S> serviceClass;
    private final ServicePropertySupplier supplier;
    private final S service;
    private BundleContext context;
    private Hashtable<String, Object> serviceProperties;
    private ServiceRegistration<S> registration;
    private boolean unregistered = false;
    static final long serialVersionUID = -8660370088002683450L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ServiceRegistrationModifier(Class<S> serviceClass, ServicePropertySupplier supplier, S service) {
        this.serviceClass = serviceClass;
        this.supplier = supplier;
        this.service = service;
    }

    public void registerOrUpdate(BundleContext bc) {
        this.updateService(false, bc);
    }

    public void unregister() {
        this.updateService(true, null);
    }

    public void update() {
        this.updateService(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @FFDCIgnore(value={IllegalStateException.class})
    private void updateService(boolean unregister, BundleContext bc) {
        block25: {
            this.modifyLock.lock();
            try {
                if (bc != null) {
                    this.context = bc;
                }
                boolean doWorkNow = this.modifyQueue.isEmpty();
                this.modifyQueue.add(unregister);
                if (!doWorkNow) break block25;
                do {
                    Hashtable<String, Object> currentProps;
                    ServiceRegistration currentReg;
                    boolean doUnregister;
                    block28: {
                        Hashtable<String, Object> newProps;
                        ServiceRegistration newReg;
                        BundleContext currentContext;
                        block27: {
                            block26: {
                                doUnregister = this.modifyQueue.peek();
                                boolean isUnregistered = this.unregistered;
                                currentContext = this.context;
                                currentReg = this.registration;
                                currentProps = this.serviceProperties;
                                newReg = null;
                                newProps = null;
                                this.modifyLock.unlock();
                                if (!isUnregistered) break block26;
                                this.modifyLock.lock();
                                this.modifyQueue.poll();
                                if (doUnregister) {
                                    this.unregistered = true;
                                    this.context = null;
                                    this.registration = null;
                                    this.serviceProperties = null;
                                } else {
                                    this.serviceProperties = currentProps;
                                    this.registration = currentReg;
                                }
                                return;
                            }
                            if (!doUnregister) break block27;
                            if (currentReg == null) break block28;
                            currentReg.unregister();
                            this.modifyLock.lock();
                            this.modifyQueue.poll();
                            if (doUnregister) {
                                this.unregistered = true;
                                this.context = null;
                                this.registration = null;
                                this.serviceProperties = null;
                            } else {
                                this.serviceProperties = currentProps;
                                this.registration = currentReg;
                            }
                            return;
                        }
                        try {
                            if (currentReg == null && currentContext == null || (newProps = this.supplier.getServiceProperties()) == null || currentProps != null && currentProps.equals(newProps)) break block28;
                            newProps = new Hashtable<String, Object>(newProps);
                            if (currentReg != null) {
                                currentReg.setProperties(newProps);
                            } else {
                                currentReg = newReg = currentContext.registerService(this.serviceClass, this.service, newProps);
                            }
                            currentProps = newProps;
                        }
                        catch (IllegalStateException e) {
                            this.modifyLock.lock();
                            this.modifyQueue.poll();
                            if (doUnregister) {
                                this.unregistered = true;
                                this.context = null;
                                this.registration = null;
                                this.serviceProperties = null;
                            } else {
                                this.serviceProperties = currentProps;
                                this.registration = currentReg;
                            }
                            this.modifyLock.unlock();
                            return;
                            catch (Throwable throwable) {
                                this.modifyLock.lock();
                                this.modifyQueue.poll();
                                if (doUnregister) {
                                    this.unregistered = true;
                                    this.context = null;
                                    this.registration = null;
                                    this.serviceProperties = null;
                                } else {
                                    this.serviceProperties = currentProps;
                                    this.registration = currentReg;
                                }
                                throw throwable;
                            }
                        }
                    }
                    this.modifyLock.lock();
                    this.modifyQueue.poll();
                    if (doUnregister) {
                        this.unregistered = true;
                        this.context = null;
                        this.registration = null;
                        this.serviceProperties = null;
                        continue;
                    }
                    this.serviceProperties = currentProps;
                    this.registration = currentReg;
                } while (!this.modifyQueue.isEmpty());
            }
            finally {
                this.modifyLock.unlock();
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ServiceRegistrationModifier.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
    }

    public static interface ServicePropertySupplier {
        public Hashtable<String, Object> getServiceProperties();
    }
}

