/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ServiceReferenceUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ConcurrentServiceReferenceElement<T>
implements Comparable<ConcurrentServiceReferenceElement<T>> {
    private final String referenceName;
    private final ServiceReference<T> serviceRef;
    private final Long serviceId;
    private final Integer serviceRanking;
    private volatile T locatedService = null;
    static final long serialVersionUID = -1026902885734078179L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ConcurrentServiceReferenceElement(String referenceName, ServiceReference<T> serviceRef) {
        this.referenceName = referenceName;
        this.serviceRef = serviceRef;
        this.serviceId = ServiceReferenceUtils.getId(serviceRef);
        this.serviceRanking = ServiceReferenceUtils.getRanking(serviceRef);
    }

    ServiceReference<T> getReference() {
        return this.serviceRef;
    }

    Integer getRanking() {
        return this.serviceRanking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T getService(ComponentContext context) {
        if (this.locatedService == null) {
            ConcurrentServiceReferenceElement concurrentServiceReferenceElement = this;
            synchronized (concurrentServiceReferenceElement) {
                if (this.locatedService == null) {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        final ComponentContext finalContext = context;
                        this.locatedService = AccessController.doPrivileged(new PrivilegedAction<T>(){
                            static final long serialVersionUID = 3948019524770933966L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public T run() {
                                return finalContext.locateService(ConcurrentServiceReferenceElement.this.referenceName, ConcurrentServiceReferenceElement.this.serviceRef);
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register(1.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                            }
                        });
                    } else {
                        this.locatedService = context.locateService(this.referenceName, this.serviceRef);
                    }
                }
            }
        }
        return this.locatedService;
    }

    public String toString() {
        return super.toString() + "[id=" + this.serviceId + ", ranking=" + this.serviceRanking + "]";
    }

    public int hashCode() {
        return this.serviceId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConcurrentServiceReferenceElement other = (ConcurrentServiceReferenceElement)obj;
        return this.serviceId.equals(other.serviceId);
    }

    @Override
    public int compareTo(ConcurrentServiceReferenceElement<T> that) {
        int compare = that.serviceRanking.compareTo(this.serviceRanking);
        if (compare == 0) {
            compare = this.serviceId.compareTo(that.serviceId);
        }
        return compare;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConcurrentServiceReferenceElement.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
    }
}

