/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceElement;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConcurrentServiceReferenceMap<K, V> {
    private final String referenceName;
    private volatile ComponentContext context;
    private final ConcurrentMap<K, ConcurrentServiceReferenceElement<V>> elementMap = new ConcurrentHashMap<K, ConcurrentServiceReferenceElement<V>>();
    static final long serialVersionUID = 6980924785166233786L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ConcurrentServiceReferenceMap(String name) {
        this.referenceName = name;
    }

    public void activate(ComponentContext context) {
        if (this.context != null) {
            throw new IllegalStateException("already activated");
        }
        this.context = context;
    }

    public synchronized void deactivate(ComponentContext context) {
        if (this.context == null) {
            throw new IllegalStateException("not activated");
        }
        this.context = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[refName=" + this.referenceName + ", isEmpty=" + this.elementMap.isEmpty() + ", isActive=" + (this.context != null) + "]";
    }

    public boolean putReference(K key, ServiceReference<V> reference) {
        if (key == null || reference == null) {
            return false;
        }
        ConcurrentServiceReferenceElement<V> element = new ConcurrentServiceReferenceElement<V>(this.referenceName, reference);
        return this.elementMap.put(key, element) != null;
    }

    public ServiceReference<V> putReferenceIfAbsent(K key, ServiceReference<V> reference) {
        if (key == null) {
            return null;
        }
        if (reference == null) {
            return this.getReference(key);
        }
        ConcurrentServiceReferenceElement<V> element = new ConcurrentServiceReferenceElement<V>(this.referenceName, reference);
        ConcurrentServiceReferenceElement<V> existingEntry = this.elementMap.putIfAbsent(key, element);
        if (existingEntry == null) {
            return null;
        }
        return existingEntry.getReference();
    }

    public boolean removeReference(K key, ServiceReference<V> reference) {
        if (key == null || reference == null) {
            return false;
        }
        ConcurrentServiceReferenceElement<V> element = new ConcurrentServiceReferenceElement<V>(this.referenceName, reference);
        return this.elementMap.remove(key, element);
    }

    public boolean isEmpty() {
        return this.elementMap.isEmpty();
    }

    public int size() {
        return this.elementMap.size();
    }

    public Set<K> keySet() {
        return this.elementMap.keySet();
    }

    public Iterable<ServiceReference<V>> references() {
        return new Iterable<ServiceReference<V>>(){
            static final long serialVersionUID = 1089825374742461639L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Iterator<ServiceReference<V>> iterator() {
                return new Iterator<ServiceReference<V>>(){
                    Iterator<ConcurrentServiceReferenceElement<V>> it;
                    static final long serialVersionUID = -2013988629199489543L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;
                    {
                        this.it = ConcurrentServiceReferenceMap.this.elementMap.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public ServiceReference<V> next() {
                        ConcurrentServiceReferenceElement e = this.it.next();
                        return e.getReference();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
                    }
                };
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
            }
        };
    }

    public V getService(K key) {
        ComponentContext ctx = this.context;
        if (ctx == null || key == null) {
            return null;
        }
        ConcurrentServiceReferenceElement e = (ConcurrentServiceReferenceElement)this.elementMap.get(key);
        if (e == null) {
            return null;
        }
        return (V)e.getService(ctx);
    }

    public V getServiceWithException(K key) {
        ComponentContext ctx = this.context;
        if (ctx == null) {
            throw new IllegalStateException("context is null");
        }
        if (key == null) {
            throw new IllegalStateException("key is null");
        }
        ConcurrentServiceReferenceElement e = (ConcurrentServiceReferenceElement)this.elementMap.get(key);
        if (e == null) {
            throw new IllegalStateException("No such element for " + key);
        }
        Object service = e.getService(ctx);
        if (service == null) {
            throw new IllegalStateException("Located service is null: " + e.getReference());
        }
        return (V)service;
    }

    public ServiceReference<V> getReference(K key) {
        if (key == null) {
            return null;
        }
        ConcurrentServiceReferenceElement e = (ConcurrentServiceReferenceElement)this.elementMap.get(key);
        if (e == null) {
            return null;
        }
        return e.getReference();
    }

    public Iterator<V> getServices() {
        List empty = Collections.emptyList();
        if (this.context == null) {
            return empty.iterator();
        }
        return new ValueIterator(this.elementMap.values().iterator());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConcurrentServiceReferenceMap.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class ValueIterator
    implements Iterator<V> {
        final Iterator<ConcurrentServiceReferenceElement<V>> c_refs;
        V next;
        static final long serialVersionUID = 7656929272327845883L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ValueIterator(Iterator<ConcurrentServiceReferenceElement<V>> iterator) {
            this.c_refs = iterator;
        }

        @Override
        public boolean hasNext() {
            ComponentContext ctx = ConcurrentServiceReferenceMap.this.context;
            if (ctx == null) {
                return false;
            }
            while (this.next == null && this.c_refs.hasNext()) {
                this.next = this.c_refs.next().getService(ctx);
            }
            return this.next != null;
        }

        @Override
        public V next() {
            Object service = this.next;
            if (service == null) {
                throw new NoSuchElementException();
            }
            this.next = null;
            return service;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[next=" + this.next + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ValueIterator.class, (String)"kernelUtils", (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }
}

