/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.java;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.File;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JavaRuntimeInformation
implements Introspector {
    private static final String INDENT = "    ";
    private final long MILLIS_PER_SECOND = 1000L;
    private final long MILLIS_PER_MINUTE = 60000L;
    private final long MILLIS_PER_HOUR = 3600000L;
    private final long MILLIS_PER_DAY = 86400000L;
    private final long MILLIS_PER_WEEK = 604800000L;
    static final long serialVersionUID = 575461548814352236L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String getIntrospectorName() {
        return "JavaRuntimeInformation";
    }

    public String getIntrospectorDescription() {
        return "Java runtime information";
    }

    public void introspect(PrintWriter writer) {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        this.introspectUptime(runtime, writer);
        this.introspectVendorVersion(runtime, writer);
        this.introspectInputArguments(runtime, writer);
        Map<String, String> props = this.introspectSystemProperties(runtime, writer);
        this.introspectDirsFromSystemProperties(runtime, writer, "java.ext.dirs", props);
        this.introspectDirsFromSystemProperties(runtime, writer, "java.endorsed.dirs", props);
    }

    private void introspectUptime(RuntimeMXBean runtime, PrintWriter writer) {
        this.writeHeader("Uptime", writer);
        StringBuilder sb = new StringBuilder();
        sb.append("JVM active ").append(this.formatDuration(runtime.getUptime()));
        sb.append(" [Started ").append(new Date(runtime.getStartTime())).append("]");
        writer.println(sb.toString());
    }

    private void introspectVendorVersion(RuntimeMXBean runtime, PrintWriter writer) {
        this.writeHeader("JVM Vendor and Version", writer);
        writer.println(" JVM Vendor: " + runtime.getVmVendor());
        writer.println("   JVM Name: " + runtime.getVmName());
        writer.println("JVM Version: " + runtime.getVmVersion());
        this.writeHeader("Java Specification Levels", writer);
        writer.println(" VM Spec Vendor: " + runtime.getSpecVendor());
        writer.println("   VM Spec Name: " + runtime.getSpecName());
        writer.println("VM Spec Version: " + runtime.getSpecVersion());
    }

    private void introspectInputArguments(RuntimeMXBean runtime, PrintWriter writer) {
        this.writeHeader("Input Arguments", writer);
        List<String> args = runtime.getInputArguments();
        for (int i = 0; i < args.size(); ++i) {
            StringBuilder sb = new StringBuilder(INDENT);
            sb.append("arg[").append(i).append("] = ");
            sb.append(args.get(i));
            writer.println(sb.toString());
        }
    }

    private Map<String, String> introspectSystemProperties(RuntimeMXBean runtime, PrintWriter writer) {
        this.writeHeader("Java System Properties", writer);
        Map<String, String> props = AccessController.doPrivileged(new GetSysPropsAction(runtime));
        for (Map.Entry<String, String> entry : props.entrySet()) {
            writer.print(INDENT);
            writer.print(entry.getKey());
            writer.print("=");
            writer.println(entry.getValue().replaceAll("\\\n", "<nl>"));
        }
        return props;
    }

    private void introspectDirsFromSystemProperties(RuntimeMXBean runtime, PrintWriter writer, String propertyName, Map<String, String> props) {
        String pathSeparator = props.get("path.separator");
        String dirsFromSysProps = props.get(propertyName);
        if (dirsFromSysProps != null) {
            String[] dirs;
            this.writeHeader("Contents of " + propertyName, writer);
            for (String dir : dirs = dirsFromSysProps.split(pathSeparator)) {
                File dirFile = new File(dir);
                writer.println(INDENT + dir);
                for (File f : this.listFiles(dirFile, writer)) {
                    writer.println("        " + f.getName());
                }
            }
        }
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private File[] listFiles(final File dir, PrintWriter writer) {
        File[] files;
        try {
            files = AccessController.doPrivileged(new PrivilegedExceptionAction<File[]>(){
                static final long serialVersionUID = -8769795322266464419L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public File[] run() throws Exception {
                    File[] files = dir.listFiles();
                    return files == null ? new File[]{} : files;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException e) {
            writer.println("    Failed to read contents of directory - " + dir.getAbsolutePath());
            e.printStackTrace(writer);
            files = new File[]{};
        }
        return files;
    }

    private void writeHeader(String header, PrintWriter writer) {
        writer.println();
        writer.println(header);
        for (int i = header.length(); i > 0; --i) {
            writer.print("-");
        }
        writer.println();
    }

    private String formatDuration(long millis) {
        long minutes;
        long hours;
        long days;
        StringBuilder sb = new StringBuilder();
        long weeks = millis / 604800000L;
        if (weeks != 0L) {
            sb.append(weeks).append("w");
        }
        if ((days = millis % 604800000L / 86400000L) != 0L) {
            sb.append(days).append("d");
        }
        if ((hours = millis % 86400000L / 3600000L) != 0L) {
            sb.append(hours).append("h");
        }
        if ((minutes = millis % 3600000L / 60000L) != 0L) {
            sb.append(minutes).append("m");
        }
        long seconds = millis % 60000L / 1000L;
        sb.append(seconds).append(".").append(millis % 1000L).append("s");
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JavaRuntimeInformation.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class GetSysPropsAction
    implements PrivilegedAction<Map<String, String>> {
        private final RuntimeMXBean runtime;
        static final long serialVersionUID = -236245246139957038L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GetSysPropsAction(RuntimeMXBean runtime) {
            this.runtime = runtime;
        }

        @Override
        public Map<String, String> run() {
            return new TreeMap<String, String>(this.runtime.getSystemProperties());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(GetSysPropsAction.class, null, null);
        }
    }
}

