/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.java;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ThreadInfoIntrospector
implements Introspector {
    private static final String INDENT = "    ";
    static final long serialVersionUID = -9182884728002605856L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String getIntrospectorName() {
        return "ThreadInfoIntrospector";
    }

    public String getIntrospectorDescription() {
        return "Basic thread information acquired from the SDK Thread MXBean";
    }

    public void introspect(PrintWriter writer) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        writer.println("Thread counts:");
        writer.println("--------------");
        writer.println("    current active: " + threadMXBean.getThreadCount());
        writer.println("     active daemon: " + threadMXBean.getDaemonThreadCount());
        writer.println("       peak active: " + threadMXBean.getPeakThreadCount());
        writer.println("     total started: " + threadMXBean.getTotalStartedThreadCount());
        writer.println();
        boolean lockedMonitorsSupported = threadMXBean.isObjectMonitorUsageSupported();
        boolean lockedSynchronizersSupported = threadMXBean.isSynchronizerUsageSupported();
        if (lockedMonitorsSupported && lockedSynchronizersSupported) {
            this.introspectDeadlockedThreads(threadMXBean, writer);
        } else if (lockedMonitorsSupported) {
            this.introspectMonitorDeadlockedThreads(threadMXBean, writer);
        }
        writer.println();
        writer.println("All thread information:");
        writer.println("-----------------------");
        this.dumpThreadInfos(threadMXBean.dumpAllThreads(lockedMonitorsSupported, lockedSynchronizersSupported), writer);
    }

    void introspectDeadlockedThreads(ThreadMXBean threadMXBean, PrintWriter writer) {
        writer.println("Detected deadlocks:");
        writer.println("-------------------");
        long[] deadlocked = threadMXBean.findDeadlockedThreads();
        if (deadlocked == null) {
            writer.println("No deadlocks detected");
            return;
        }
        this.dumpThreadInfos(threadMXBean.getThreadInfo(deadlocked), writer);
    }

    void introspectMonitorDeadlockedThreads(ThreadMXBean threadMXBean, PrintWriter writer) {
        writer.println("Detected deadlocks:");
        writer.println("-------------------");
        long[] deadlocked = threadMXBean.findMonitorDeadlockedThreads();
        if (deadlocked == null) {
            writer.println("No deadlocks detected");
            return;
        }
        this.dumpThreadInfos(threadMXBean.getThreadInfo(deadlocked), writer);
    }

    void dumpThreadInfos(ThreadInfo[] threadInfos, PrintWriter writer) {
        for (ThreadInfo threadInfo : threadInfos) {
            writer.println(threadInfo);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ThreadInfoIntrospector.class, null, null);
    }
}

