/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component
public class RegionIntrospection
implements Introspector {
    @Reference
    private RegionDigraph digraph;
    private BundleContext systemContext;
    static final long serialVersionUID = -746675952091035480L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(BundleContext ctx) {
        this.systemContext = ctx.getBundle("System Bundle").getBundleContext();
    }

    public String getIntrospectorName() {
        return "RegionIntrospection";
    }

    public String getIntrospectorDescription() {
        return "Information on the region digraph";
    }

    public void introspect(PrintWriter out) throws Exception {
        for (Region region : this.digraph) {
            out.println(region.getName());
            out.println("  Associated Bundles:");
            for (Long id : region.getBundleIds()) {
                Bundle b = this.systemContext.getBundle(id.longValue());
                out.append("    ");
                out.println(b);
            }
            out.println("  Edges:");
            for (RegionDigraph.FilteredRegion edge : region.getEdges()) {
                out.append("    ").append(edge.getRegion().getName()).append(" -> ");
                out.println(edge.getFilter());
            }
            out.println();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(RegionIntrospection.class, null, null);
    }
}

