/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public final class CollectionExpression
extends AbstractExpression {
    private List<AbstractExpression> children;
    private List<Boolean> commas;
    private List<Boolean> spaces;

    public CollectionExpression(AbstractExpression parent, List<AbstractExpression> children, List<Boolean> commas, List<Boolean> spaces) {
        this(parent, children, commas, spaces, false);
    }

    public CollectionExpression(AbstractExpression parent, List<AbstractExpression> children, List<Boolean> commas, List<Boolean> spaces, boolean temporary) {
        super(parent);
        this.children = children;
        this.commas = commas;
        this.spaces = spaces;
        if (!temporary) {
            this.updateBackpointers();
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public void accept(int index, ExpressionVisitor visitor) {
        this.getChild(index).accept(visitor);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        for (Expression child : this.children()) {
            child.accept(visitor);
        }
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        int index = 0;
        int childCount = this.children.size();
        while (index < childCount) {
            this.getChildInternal(index);
            ++index;
        }
        children.addAll(this.children);
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        this.children();
        int index = 0;
        int count = this.children.size();
        while (index < count) {
            Expression expression = this.getChild(index);
            children.add(expression);
            if (this.hasComma(index)) {
                children.add(this.buildStringExpression(','));
            }
            if (this.hasSpace(index)) {
                children.add(this.buildStringExpression(' '));
            }
            ++index;
        }
    }

    public int childrenSize() {
        this.children();
        return this.children.size();
    }

    public boolean endsWithComma() {
        this.children();
        if (this.children.get(this.children.size() - 1).isNull()) {
            return this.commas.get(this.commas.size() - 2);
        }
        return false;
    }

    public boolean endsWithSpace() {
        this.children();
        if (this.children.get(this.children.size() - 1).isNull()) {
            return this.spaces.get(this.spaces.size() - 2);
        }
        return false;
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        return this.getParent().findQueryBNF(expression);
    }

    public Expression getChild(int index) {
        return this.getChildInternal(index);
    }

    private AbstractExpression getChildInternal(int index) {
        AbstractExpression child = this.children.get(index);
        if (child == null) {
            child = this.buildNullExpression();
            this.children.set(index, child);
        }
        return child;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getParent().getQueryBNF();
    }

    public boolean hasComma(int index) {
        this.children();
        return index < this.commas.size() && this.commas.get(index) != false;
    }

    public boolean hasSpace(int index) {
        this.children();
        return index < this.spaces.size() && (this.spaces.get(index) != false || this.hasComma(index) && index + 1 < this.children.size() && !this.getChildInternal(index + 1).isNull());
    }

    public int indexOf(Expression expression) {
        this.children();
        return this.children.indexOf(expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        throw new IllegalAccessError("This method shouln't be invoked, text=" + wordParser);
    }

    public String toActualText(int endIndex) {
        StringBuilder writer = new StringBuilder();
        this.toParsedText(writer, endIndex, true);
        return writer.toString();
    }

    public String toParsedText(int endIndex) {
        StringBuilder writer = new StringBuilder();
        this.toParsedText(writer, endIndex, false);
        return writer.toString();
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        this.toParsedText(writer, this.childrenSize(), actual);
    }

    private void toParsedText(StringBuilder writer, int endIndex, boolean actual) {
        int index = 0;
        int count = this.children.size();
        while (index < endIndex) {
            AbstractExpression expression = this.children.get(index);
            if (expression != null) {
                expression.toParsedText(writer, actual);
            }
            if (this.commas.get(index).booleanValue()) {
                AbstractExpression nextExpression;
                writer.append(',');
                if (this.spaces.get(index).booleanValue()) {
                    writer.append(' ');
                } else if (index + 1 < count && (nextExpression = this.children.get(index + 1)) != null && !nextExpression.isNull()) {
                    writer.append(' ');
                }
            } else if (this.spaces.get(index).booleanValue()) {
                writer.append(' ');
            }
            ++index;
        }
    }

    private void updateBackpointers() {
        for (AbstractExpression child : this.children) {
            if (child == null) continue;
            child.setParent(this);
        }
    }
}

