/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.security.metadata.CollectionMatch;
import com.ibm.ws.webcontainer.security.metadata.MatchResponse;
import com.ibm.ws.webcontainer.security.metadata.MatchingStrategy;
import com.ibm.ws.webcontainer.security.metadata.ResponseAggregate;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraint;
import com.ibm.ws.webcontainer.security.metadata.WebResourceCollection;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class StandardMatchingStrategy
extends MatchingStrategy {
    static final long serialVersionUID = 2143732350112320905L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    protected ResponseAggregate createResponseAggregate() {
        return new ResponseAggregate(MatchResponse.NO_MATCH_RESPONSE);
    }

    @Override
    protected boolean isMatch(MatchResponse currentResponse) {
        return !MatchResponse.NO_MATCH_RESPONSE.equals(currentResponse);
    }

    @Override
    protected MatchResponse getMatchResponse(SecurityConstraint securityConstraint, String resourceName, String method) {
        CollectionMatch collectionMatch = this.getCollectionMatch(securityConstraint.getWebResourceCollections(), resourceName, method);
        if (CollectionMatch.RESPONSE_NO_MATCH.equals(collectionMatch)) {
            return MatchResponse.NO_MATCH_RESPONSE;
        }
        if (WebContainer.getServletContainerSpecLevel() >= 31 && collectionMatch.isExactMatch() && securityConstraint.isAccessUncovered() && securityConstraint.isFromHttpConstraint()) {
            return new MatchResponse(securityConstraint.getRoles(), securityConstraint.isSSLRequired(), securityConstraint.isAccessPrecluded(), CollectionMatch.RESPONSE_PERMIT);
        }
        return new MatchResponse(securityConstraint.getRoles(), securityConstraint.isSSLRequired(), securityConstraint.isAccessPrecluded(), collectionMatch);
    }

    @Override
    protected CollectionMatch getInitialCollectionMatch() {
        return CollectionMatch.RESPONSE_NO_MATCH;
    }

    @Override
    protected CollectionMatch getCollectionMatchForWebResourceCollection(WebResourceCollection webResourceCollection, String resourceName, String method) {
        CollectionMatch match = null;
        if (webResourceCollection.isMethodMatched(method)) {
            match = webResourceCollection.performUrlMatch(resourceName);
            if (match == null) {
                match = CollectionMatch.RESPONSE_NO_MATCH;
            }
        } else if (webResourceCollection.deniedDueToDenyUncoveredHttpMethods(method)) {
            if (webResourceCollection.isSpecifiedOmissionMethod(method)) {
                match = webResourceCollection.performUrlMatch(resourceName);
                if (match != null && !CollectionMatch.RESPONSE_NO_MATCH.equals(match) && !CollectionMatch.RESPONSE_DENY_MATCH.equals(match)) {
                    match = CollectionMatch.RESPONSE_DENY_MATCH_BY_OMISSION;
                }
            } else {
                match = webResourceCollection.performUrlMatch(resourceName);
                if (match != null && !CollectionMatch.RESPONSE_NO_MATCH.equals(match) && !CollectionMatch.RESPONSE_DENY_MATCH.equals(match)) {
                    match = CollectionMatch.RESPONSE_DENY_MATCH;
                }
            }
        }
        return match;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(StandardMatchingStrategy.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    }
}

