/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.ibm.oauth.core.api.OAuthComponentInstance;
import com.ibm.oauth.core.api.OAuthResult;
import com.ibm.oauth.core.api.attributes.Attribute;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.InvalidGrantException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20AuthorizationCodeInvalidClientException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20BadParameterFormatException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20DuplicateParameterException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InternalException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidClientException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidClientSecretException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidRedirectUriException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidTokenException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidTokenRequestMethodException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MediatorException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MismatchedClientAuthenticationException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MissingParameterException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20PublicClientCredentialsException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20PublicClientForbiddenException;
import com.ibm.oauth.core.api.oauth20.OAuth20Component;
import com.ibm.oauth.core.api.oauth20.client.OAuth20Client;
import com.ibm.oauth.core.api.oauth20.mediator.OAuth20Mediator;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.api.oauth20.token.OAuth20TokenCache;
import com.ibm.oauth.core.internal.OAuthComponentImpl;
import com.ibm.oauth.core.internal.oauth20.OAuth20ComponentInternal;
import com.ibm.oauth.core.internal.oauth20.OAuth20Constants;
import com.ibm.oauth.core.internal.oauth20.OAuth20RequestContext;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.OAuthResultImpl;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigProvider;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigurationImpl;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandler;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandlerFactory;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandlerFactoryImpl;
import com.ibm.oauth.core.internal.oauth20.mediator.OAuth20MediatorFactory;
import com.ibm.oauth.core.internal.oauth20.responsetype.OAuth20ResponseTypeHandler;
import com.ibm.oauth.core.internal.oauth20.responsetype.OAuth20ResponseTypeHandlerFactory;
import com.ibm.oauth.core.internal.oauth20.responsetype.OAuth20ResponseTypeHandlerFactoryImpl;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import com.ibm.oauth.core.internal.oauth20.tokentype.OAuth20TokenTypeHandler;
import com.ibm.oauth.core.internal.oauth20.tokentype.OAuth20TokenTypeHandlerFactory;
import com.ibm.oauth.core.internal.statistics.OAuthStatisticsImpl;
import com.ibm.oauth.core.util.WebUtils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.api.OidcOAuth20Client;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.util.HashUtils;
import com.ibm.ws.security.oauth20.util.MessageDigestUtil;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OAuth20ComponentImpl
extends OAuthComponentImpl
implements OAuth20Component,
OAuth20ComponentInternal {
    static final String CLASS = OAuth20ComponentImpl.class.getName();
    Logger _log = Logger.getLogger(CLASS);
    protected static final TraceComponent tc = Tr.register(OAuth20ComponentImpl.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    static final String HTTP_METHOD_POST = "POST";
    static final String RESPONSE_MODE = "response_mode";
    static final String FORM_POST = "form_post";
    OAuth20GrantTypeHandlerFactory _grantTypeHandlerFactory = null;
    OAuth20ResponseTypeHandlerFactory _responseTypeHandlerFactory = null;
    static final String STATE_ENCODING = "UTF-8";
    OidcOAuth20ClientProvider _clientProvider = null;
    OAuth20TokenCache _tokenCache = null;
    boolean _allowPublicClients = false;
    protected OAuth20ConfigProvider _config20;

    public OAuth20ComponentImpl(OAuthComponentInstance parent, OAuthComponentConfiguration config, OAuth20ConfigProvider configProvider) throws OAuthException {
        super(parent, config);
        this._config20 = configProvider;
        this._grantTypeHandlerFactory = this.initGrantTypeHandlerFactory(this._config20);
        this._responseTypeHandlerFactory = this.initResponseTypeHandlerFactory(this._config20);
        this._clientProvider = this._config20.getClientProvider();
        this._tokenCache = this._config20.getTokenCache();
        this._allowPublicClients = this._config20.isAllowPublicClients();
    }

    public OAuth20ComponentImpl(OAuthComponentInstance parent, OAuthComponentConfiguration config) throws OAuthException {
        super(parent, config);
        OAuthComponentConfiguration configwrapper = super.getConfiguration();
        OAuth20ConfigurationImpl configValidator = new OAuth20ConfigurationImpl(this, configwrapper);
        configValidator.validate();
        this._config20 = configValidator.getConfigProvider();
        this._grantTypeHandlerFactory = this.initGrantTypeHandlerFactory(this._config20);
        this._responseTypeHandlerFactory = this.initResponseTypeHandlerFactory(this._config20);
        this._clientProvider = this._config20.getClientProvider();
        this._tokenCache = this._config20.getTokenCache();
        this._allowPublicClients = this._config20.isAllowPublicClients();
    }

    OAuth20GrantTypeHandlerFactory initGrantTypeHandlerFactory(OAuth20ConfigProvider config) throws OAuthException {
        OAuth20GrantTypeHandlerFactory result = config.getGrantTypeHandlerFactory();
        if (result == null) {
            result = new OAuth20GrantTypeHandlerFactoryImpl();
        }
        return result;
    }

    OAuth20ResponseTypeHandlerFactory initResponseTypeHandlerFactory(OAuth20ConfigProvider config) throws OAuthException {
        OAuth20ResponseTypeHandlerFactory result = config.getResponseTypeHandlerFactory();
        if (result == null) {
            result = new OAuth20ResponseTypeHandlerFactoryImpl();
            result.init(super.getConfiguration());
        }
        return result;
    }

    @Override
    public OAuth20ConfigProvider get20Configuration() {
        if (this._log.isLoggable(Level.FINEST)) {
            this._log.logp(Level.FINEST, CLASS, "get20Configuration", "get20Configuration returns [" + this._config20 + "]");
        }
        return this._config20;
    }

    @Override
    public OAuthComponentConfiguration getConfiguration() {
        throw new UnsupportedOperationException("called OAuth20ComponentImpl.getConfiguration(). Use OAuth20ComponentImpl.get20Configuration() instead.");
    }

    @Override
    public OAuthResult processAuthorization(HttpServletRequest request, HttpServletResponse response, AttributeList options) {
        String username = request.getUserPrincipal().getName();
        String clientId = request.getParameter("client_id");
        String redirectUri = request.getParameter("redirect_uri");
        String responseType = request.getParameter("response_type");
        String state = request.getParameter("state");
        String[] scope = null;
        if (options != null) {
            scope = options.getAttributeValuesByName("scope");
        }
        return this.processAuthorization(username, clientId, redirectUri, responseType, state, scope, options, request, response);
    }

    @Override
    public OAuthResult processAuthorization(String username, String clientId, String redirectUri, String responseType, String state, String[] authorizedScopes, HttpServletResponse response) {
        return this.processAuthorization(username, clientId, redirectUri, responseType, state, authorizedScopes, null, null, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public OAuthResult processAuthorization(String username, String clientId, String redirectUri, String responseType, String state, String[] authorizedScopes, AttributeList options, HttpServletRequest request, HttpServletResponse response) {
        OAuthResult result;
        block23: {
            String methodName;
            block22: {
                ListIterator<OAuth20Token> tokenIter;
                methodName = "processAuthorization";
                boolean errorOccurred = true;
                List<OAuth20Token> tokens = null;
                this._log.entering(CLASS, methodName, new String[]{clientId, redirectUri, responseType, state, "{" + OAuth20Util.arrayToSpaceString(authorizedScopes) + "}"});
                result = null;
                OAuth20RequestContext requestContext = new OAuth20RequestContext();
                AttributeList attributeList = new AttributeList();
                OAuth20Mediator mediator = null;
                try {
                    String strResponseMode;
                    String[] resource;
                    mediator = OAuth20MediatorFactory.getMediator(this);
                    attributeList = this.buildAuthorizationAttributeList(username, clientId, redirectUri, responseType, state, authorizedScopes);
                    this.addRequestHeaderToAttributeList(request, attributeList);
                    OAuth20Client client = this.getOAuth20Client(requestContext, clientId, null, redirectUri, false);
                    this.processPKCEAndUpdateAttributeList(request, client, attributeList);
                    if (request != null && (resource = (String[])request.getAttribute("urn:ibm:names:authn:param:resource")) != null) {
                        attributeList.setAttribute("resource", "urn:ibm:names:oauth:param", resource);
                    }
                    this.populateJwtAccessTokenData(client, attributeList);
                    boolean preInvokeMediation = false;
                    if (options != null) {
                        List<Attribute> attrs = options.getAllAttributes();
                        for (Attribute attr : attrs) {
                            if (attributeList.getAttributeValuesByNameAndType(attr.getName(), attr.getType()) == null) {
                                attributeList.setAttribute(attr.getName(), attr.getType(), attr.getValuesArray());
                            }
                            if (!"com.ibm.wsspi.security.oidc.external.mediation".equals(attr.getType())) continue;
                            preInvokeMediation = true;
                        }
                    }
                    JsonArray registeredRedirectUris = client.getRedirectUris();
                    OAuth20ResponseTypeHandler rth = this._responseTypeHandlerFactory.getHandler(responseType, this.get20Configuration());
                    if (responseType.indexOf("id_token") != -1 && request != null) {
                        this.populateFromRequestForOpenIDConnect(attributeList, request);
                    }
                    boolean allowRegexpRedirects = client.getAllowRegexpRedirects();
                    rth.validateRequestResponseType(attributeList, registeredRedirectUris, allowRegexpRedirects);
                    if (preInvokeMediation) {
                        mediator.mediateAuthorize(attributeList);
                    }
                    OAuth20TokenFactory tokenFactory = new OAuth20TokenFactory(this);
                    tokens = rth.buildTokensResponseType(attributeList, tokenFactory, registeredRedirectUris.get(0).getAsString());
                    rth.buildResponseResponseType(attributeList, tokens);
                    if (state != null && state.length() > 0) {
                        attributeList.setAttribute("state", "urn:ibm:names:oauth:response:attribute", new String[]{state});
                    }
                    if (!preInvokeMediation) {
                        mediator.mediateAuthorize(attributeList);
                    }
                    String responseRedirectURI = redirectUri == null || redirectUri.length() == 0 ? client.getRedirectUris().get(0).getAsString() : redirectUri;
                    String string = strResponseMode = request != null ? request.getParameter(RESPONSE_MODE) : null;
                    if (FORM_POST.equals(strResponseMode)) {
                        this.postRedirect(response, attributeList, responseRedirectURI);
                    } else {
                        String accessToken = attributeList.getAttributeValueByName("access_token");
                        String idToken = attributeList.getAttributeValueByName("id_token");
                        boolean implicit = accessToken != null && accessToken.length() > 0 || idToken != null && idToken.length() > 0;
                        this.sendRedirect(response, attributeList, responseRedirectURI, implicit);
                    }
                    result = new OAuthResultImpl(0, attributeList);
                    errorOccurred = false;
                    if (!errorOccurred || tokens == null) break block22;
                    tokenIter = tokens.listIterator();
                }
                catch (OAuthException e) {
                    result = this.processAuthorizationException(attributeList, mediator, e);
                    break block23;
                }
                catch (Exception e2) {
                    OAuth20InternalException oauthException = new OAuth20InternalException(e2);
                    result = this.processAuthorizationException(attributeList, mediator, oauthException);
                    break block23;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (errorOccurred && tokens != null) {
                        ListIterator tokenIter2 = tokens.listIterator();
                        while (tokenIter2.hasNext()) {
                            OAuth20Token token = (OAuth20Token)tokenIter2.next();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"processAuthorization: Found token to remove from cash.", (Object[])new Object[0]);
                                Tr.debug((TraceComponent)tc, (String)("Type: " + token.getType()), (Object[])new Object[0]);
                                Tr.debug((TraceComponent)tc, (String)("Subtype: " + token.getSubType()), (Object[])new Object[0]);
                                Tr.debug((TraceComponent)tc, (String)("ClientId: " + token.getClientId()), (Object[])new Object[0]);
                                Tr.debug((TraceComponent)tc, (String)("Username: " + token.getUsername()), (Object[])new Object[0]);
                            }
                            this._tokenCache.remove(token.getId());
                        }
                    }
                    this._log.exiting(CLASS, methodName, result);
                }
                while (tokenIter.hasNext()) {
                    OAuth20Token token = tokenIter.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"processAuthorization: Found token to remove from cash.", (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("Type: " + token.getType()), (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("Subtype: " + token.getSubType()), (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("ClientId: " + token.getClientId()), (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("Username: " + token.getUsername()), (Object[])new Object[0]);
                    }
                    this._tokenCache.remove(token.getId());
                }
            }
            this._log.exiting(CLASS, methodName, result);
        }
        return result;
    }

    public void processPKCEAndUpdateAttributeList(HttpServletRequest request, OAuth20Client client, AttributeList attributeList) throws OAuth20DuplicateParameterException, OAuth20BadParameterFormatException, OAuth20MissingParameterException {
        String methodName = "processPKCEAndUpdateAttributeList";
        this._log.entering(CLASS, methodName);
        String code_challenge = null;
        String code_challenge_method = null;
        if (request != null) {
            code_challenge = request.getParameter("code_challenge");
            code_challenge_method = request.getParameter("code_challenge_method");
            if ((this.challengeHasValue(code_challenge) || ((OidcOAuth20Client)client).isProofKeyForCodeExchangeEnabled()) && !this.challengeHasValue(code_challenge_method)) {
                code_challenge_method = "plain";
            }
            if (this.challengeHasValue(code_challenge_method) && this.isValidCodeChallengeMethod(code_challenge_method) && code_challenge == null) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "code_challenge", null);
            }
            if (this.challengeHasValue(code_challenge_method) && !this.isValidCodeChallengeMethod(code_challenge_method)) {
                throw new OAuth20MissingParameterException("security.oauth20.pkce.invalid.method.error", code_challenge_method, null);
            }
        }
        if (this.challengeHasValue(code_challenge) && this.challengeHasValue(code_challenge_method)) {
            this.addParameterToAttributeList("code_challenge", "urn:ibm:names:query:param", code_challenge, attributeList);
            this.addParameterToAttributeList("code_challenge_method", "urn:ibm:names:query:param", code_challenge_method, attributeList);
        } else if (((OidcOAuth20Client)client).isProofKeyForCodeExchangeEnabled()) {
            throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "code_challenge", null);
        }
        this._log.exiting(CLASS, methodName);
    }

    private boolean challengeHasValue(String challenge) {
        return challenge != null && challenge.length() > 0;
    }

    private boolean isValidCodeChallengeMethod(String code_challenge_method) {
        return "plain".equals(code_challenge_method) || "S256".equals(code_challenge_method);
    }

    private OAuthResult processAuthorizationException(AttributeList attributeList, OAuth20Mediator mediator, OAuthException e) {
        OAuthResultImpl result;
        try {
            if (mediator != null) {
                mediator.mediateAuthorizeException(attributeList, e);
            }
            result = new OAuthResultImpl(1, attributeList, e);
        }
        catch (OAuth20MediatorException me) {
            result = new OAuthResultImpl(1, attributeList, me);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public OAuthResult processTokenRequest(String authenticatedClient, HttpServletRequest request, HttpServletResponse response) {
        OAuthResult result;
        block33: {
            String methodName;
            block32: {
                ListIterator<OAuth20Token> tokenIter;
                methodName = "processTokenRequest";
                boolean finestLoggable = this._log.isLoggable(Level.FINEST);
                boolean errorOccurred = true;
                List<OAuth20Token> newTokens = null;
                this._log.entering(CLASS, methodName, new String[]{authenticatedClient});
                result = null;
                AttributeList attributeList = (AttributeList)request.getAttribute("urn:ibm:names:oauth:param:request");
                if (attributeList == null) {
                    attributeList = new AttributeList();
                }
                OAuth20Mediator mediator = null;
                OAuth20RequestContext requestContext = new OAuth20RequestContext();
                try {
                    OAuth20Token token;
                    mediator = OAuth20MediatorFactory.getMediator(this);
                    OAuth20Client client = null;
                    String clientId = request.getParameter("client_id");
                    String grantType = request.getParameter("grant_type");
                    if (clientId == null) {
                        clientId = authenticatedClient;
                    }
                    if (!HTTP_METHOD_POST.equalsIgnoreCase(request.getMethod())) {
                        throw new OAuth20InvalidTokenRequestMethodException("security.oauth20.error.invalid.tokenrequestmethod", request.getMethod());
                    }
                    if (authenticatedClient != null && authenticatedClient.length() > 0) {
                        if (!clientId.equals(authenticatedClient)) {
                            Tr.error((TraceComponent)tc, (String)"security.oauth20.detail.error.mismatched.clientauthentication", (Object[])new Object[]{clientId, authenticatedClient});
                            throw new OAuth20MismatchedClientAuthenticationException("security.oauth20.error.mismatched.clientauthentication", clientId, authenticatedClient);
                        }
                        client = this.getOAuth20Client(requestContext, authenticatedClient, null, null, true);
                    } else {
                        String clientSecret = request.getParameter("client_secret");
                        if (clientSecret == null || clientSecret.length() == 0) {
                            if (grantType != null && grantType.equals("client_credentials")) {
                                throw new OAuth20PublicClientCredentialsException("security.oauth20.error.publicclient.credential", clientId);
                            }
                            if (!this._allowPublicClients) {
                                throw new OAuth20PublicClientForbiddenException("security.oauth20.error.publicclient.forbidden", clientId);
                            }
                        }
                        client = this.getOAuth20Client(requestContext, clientId, clientSecret, null, true);
                    }
                    attributeList = this.buildTokenAttributeList(grantType, client, request, attributeList);
                    this.addRequestHeaderToAttributeList(request, attributeList);
                    OAuth20GrantTypeHandler gth = this._grantTypeHandlerFactory.getHandler(this._parent.getInstanceId(), grantType, this.get20Configuration());
                    ArrayList<OAuth20Token> tokens = new ArrayList<OAuth20Token>();
                    List<String> tokenKeys = gth.getKeysGrantType(attributeList);
                    if (tokenKeys != null) {
                        ListIterator<String> keyIter = tokenKeys.listIterator();
                        while (keyIter.hasNext()) {
                            String key = keyIter.next();
                            token = this.getOAuth20Token(requestContext, key, "authorization_grant", grantType, true);
                            tokens.add(token);
                        }
                        if (tokens.size() >= 1) {
                            OAuth20Token code = (OAuth20Token)tokens.get(0);
                            String code_challenge = null;
                            String code_challenge_method = null;
                            if (client instanceof OidcOAuth20Client) {
                                code_challenge = code.getCodeChallenge();
                                code_challenge_method = code.getCodeChallengeMethod();
                                if (((OidcOAuth20Client)client).isProofKeyForCodeExchangeEnabled() || code_challenge != null) {
                                    this.handlePKCEVerification(code, code_challenge, code_challenge_method, attributeList);
                                } else if (this.requestHasCodeVerifier(attributeList) && code_challenge == null) {
                                    String message = Tr.formatMessage((TraceComponent)tc, (String)"security.oauth20.pkce.error.mismatch.codeverifier", (Object[])new Object[]{"null", attributeList.getAttributeValueByName("code_verifier")});
                                    throw new InvalidGrantException(message, null);
                                }
                            }
                        }
                    }
                    this.populateFromRequestForOpenIDConnect(attributeList, request);
                    gth.validateRequestGrantType(attributeList, tokens);
                    OAuth20TokenFactory tokenFactory = new OAuth20TokenFactory(this);
                    newTokens = gth.buildTokensGrantType(attributeList, tokenFactory, tokens);
                    ListIterator tokenIter2 = tokens.listIterator();
                    while (tokenIter2.hasNext()) {
                        token = (OAuth20Token)tokenIter2.next();
                        this.removeOldToken(token);
                    }
                    gth.buildResponseGrantType(attributeList, newTokens);
                    mediator.mediateToken(attributeList);
                    String data = this.buildResponseDataString(attributeList, true, false);
                    if (finestLoggable) {
                        this._log.logp(Level.FINEST, CLASS, methodName, "Response attributes: " + data);
                    }
                    response.setHeader("Cache-Control", "no-store");
                    response.setHeader("Pragma", "no-cache");
                    response.setHeader("Content-Type", "application/json;charset=UTF-8");
                    String json = OAuth20Util.JSONEncode(data);
                    try {
                        PrintWriter pw = response.getWriter();
                        pw.write(json);
                        pw.flush();
                    }
                    catch (IOException e) {
                        String[] objs = new String[]{clientId, e.getMessage()};
                        throw new OAuth20InternalException("security.oauth20.error.token.internal.exception", (Throwable)e, objs);
                    }
                    result = new OAuthResultImpl(0, attributeList);
                    errorOccurred = false;
                    if (!errorOccurred || newTokens == null) break block32;
                    tokenIter = newTokens.listIterator();
                }
                catch (OAuthException e) {
                    result = this.processException(attributeList, mediator, e);
                    break block33;
                }
                catch (Exception e2) {
                    String[] objs = new String[]{request.getParameter("client_id"), e2.getMessage()};
                    OAuth20InternalException oauthException = new OAuth20InternalException("security.oauth20.error.token.internal.exception", e2.getCause() == null ? e2 : e2.getCause(), objs);
                    result = this.processException(attributeList, mediator, oauthException);
                    break block33;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (errorOccurred && newTokens != null) {
                        ListIterator tokenIter3 = newTokens.listIterator();
                        while (tokenIter3.hasNext()) {
                            OAuth20Token token = (OAuth20Token)tokenIter3.next();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"processTokenRequest: Found token to remove from cash.", (Object[])new Object[0]);
                                Tr.debug((TraceComponent)tc, (String)("Type: " + token.getType()), (Object[])new Object[0]);
                                Tr.debug((TraceComponent)tc, (String)("Subtype: " + token.getSubType()), (Object[])new Object[0]);
                                Tr.debug((TraceComponent)tc, (String)("ClientId: " + token.getClientId()), (Object[])new Object[0]);
                                Tr.debug((TraceComponent)tc, (String)("Username: " + token.getUsername()), (Object[])new Object[0]);
                            }
                            this._tokenCache.remove(token.getId());
                        }
                    }
                    this._log.exiting(CLASS, methodName, result);
                }
                while (tokenIter.hasNext()) {
                    OAuth20Token token = tokenIter.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"processTokenRequest: Found token to remove from cash.", (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("Type: " + token.getType()), (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("Subtype: " + token.getSubType()), (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("ClientId: " + token.getClientId()), (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)("Username: " + token.getUsername()), (Object[])new Object[0]);
                    }
                    this._tokenCache.remove(token.getId());
                }
            }
            this._log.exiting(CLASS, methodName, result);
        }
        return result;
    }

    private boolean requestHasCodeVerifier(AttributeList attributeList) {
        String code_verifier = attributeList.getAttributeValueByName("code_verifier");
        return code_verifier != null && code_verifier.length() > 0;
    }

    public void handlePKCEVerification(OAuth20Token code, String code_challenge, String code_challenge_method, AttributeList attributeList) throws OAuth20AuthorizationCodeInvalidClientException, OAuth20MissingParameterException, InvalidGrantException {
        String derived_code_challenge;
        String methodName = "handlePKCEVerification";
        this._log.entering(CLASS, methodName);
        String code_verifier = attributeList.getAttributeValueByName("code_verifier");
        if (code_verifier == null) {
            throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "code_verifier", null);
        }
        if (!this.isCodeVerifierLengthAcceptable(code_verifier)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"security.oauth20.pkce.codeverifier.length.error", (Object[])new Object[]{code_verifier.length()});
            throw new InvalidGrantException(message, null);
        }
        if ("plain".equals(code_challenge_method) && !code_challenge.equals(code_verifier)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"security.oauth20.pkce.error.mismatch.codeverifier", (Object[])new Object[]{code_challenge, code_verifier});
            throw new InvalidGrantException(message, null);
        }
        if ("S256".equals(code_challenge_method) && !code_challenge.equals(derived_code_challenge = HashUtils.encodedDigest(code_verifier, "SHA-256", "US-ASCII"))) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"security.oauth20.pkce.error.mismatch.codeverifier", (Object[])new Object[]{code_challenge, code_verifier});
            throw new InvalidGrantException(message, null);
        }
        this._log.exiting(CLASS, methodName);
    }

    public boolean isCodeVerifierLengthAcceptable(String code_verifier) {
        return code_verifier != null && code_verifier.length() >= 43 && code_verifier.length() <= 128;
    }

    private void removeOldToken(OAuth20Token token) {
        boolean isAuthorizationGrantTypeAndCodeSubType = "authorization_grant".equals(token.getType()) && "authorization_code".equals(token.getSubType());
        String key = token.getId();
        if (isAuthorizationGrantTypeAndCodeSubType && this._tokenCache instanceof OAuth20EnhancedTokenCache) {
            key = MessageDigestUtil.getDigest(key);
            ((OAuth20EnhancedTokenCache)this._tokenCache).removeByHash(key);
        } else {
            this._tokenCache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OAuthResult processAppTokenRequest(boolean isAppPasswordRequest, String authenticatedClient, HttpServletRequest request, HttpServletResponse response) {
        ListIterator<OAuth20Token> tokenIter;
        boolean errorOccurred = true;
        List<OAuth20Token> newTokens = null;
        OAuthResult result = null;
        AttributeList attributeList = (AttributeList)request.getAttribute("urn:ibm:names:oauth:param:request");
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        OAuth20Mediator mediator = null;
        OAuth20Client client = null;
        OAuth20RequestContext requestContext = new OAuth20RequestContext();
        try {
            OAuth20Token token;
            mediator = OAuth20MediatorFactory.getMediator(this);
            String clientId = authenticatedClient;
            client = this.getOAuth20Client(requestContext, clientId, null, null, true);
            String grantType = isAppPasswordRequest ? "app_password" : "app_token";
            attributeList = this.buildTokenAttributeList(grantType, client, request, attributeList);
            this.addRequestHeaderToAttributeList(request, attributeList);
            this.getAccessTokenFromHttpHeader(request, attributeList);
            OAuth20GrantTypeHandler gth = this._grantTypeHandlerFactory.getHandler(this._parent.getInstanceId(), grantType, this.get20Configuration());
            ArrayList<OAuth20Token> tokens = new ArrayList<OAuth20Token>();
            List<String> tokenKeys = gth.getKeysGrantType(attributeList);
            if (tokenKeys != null) {
                ListIterator<String> keyIter = tokenKeys.listIterator();
                while (keyIter.hasNext()) {
                    String key = keyIter.next();
                    token = this.getOAuth20Token(requestContext, key, "authorization_grant", grantType, true);
                    tokens.add(token);
                }
            }
            this.populateFromRequestForOpenIDConnect(attributeList, request);
            gth.validateRequestGrantType(attributeList, tokens);
            OAuth20TokenFactory tokenFactory = new OAuth20TokenFactory(this);
            newTokens = gth.buildTokensGrantType(attributeList, tokenFactory, tokens);
            ListIterator tokenIter2 = tokens.listIterator();
            while (tokenIter2.hasNext()) {
                token = (OAuth20Token)tokenIter2.next();
                this._tokenCache.remove(token.getId());
            }
            gth.buildResponseGrantType(attributeList, newTokens);
            mediator.mediateToken(attributeList);
            String data = this.buildResponseDataString(attributeList, true, false);
            response.setHeader("Cache-Control", "no-store");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            String json = OAuth20Util.JSONEncode(data);
            AuditManager auditManager = new AuditManager();
            auditManager.setAgent(json);
            try {
                PrintWriter pw = response.getWriter();
                pw.write(json);
                pw.flush();
            }
            catch (IOException e) {
                String[] objs = new String[]{clientId, e.getMessage()};
                throw new OAuth20InternalException("security.oauth20.error.token.internal.exception", (Throwable)e, objs);
            }
            result = new OAuthResultImpl(0, attributeList);
            errorOccurred = false;
            if (!errorOccurred || newTokens == null) return result;
            tokenIter = newTokens.listIterator();
        }
        catch (OAuthException e) {
            result = this.processException(attributeList, mediator, e);
            return result;
        }
        catch (Exception e2) {
            String[] objs = new String[]{request.getParameter("client_id"), e2.getMessage()};
            OAuth20InternalException oauthException = new OAuth20InternalException("security.oauth20.error.token.internal.exception", e2.getCause() == null ? e2 : e2.getCause(), objs);
            result = this.processException(attributeList, mediator, oauthException);
            return result;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (!errorOccurred || newTokens == null) return result;
            ListIterator tokenIter3 = newTokens.listIterator();
            while (tokenIter3.hasNext()) {
                OAuth20Token token = (OAuth20Token)tokenIter3.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processTokenRequest: Found token to remove from cash.", (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("Type: " + token.getType()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("Subtype: " + token.getSubType()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("ClientId: " + token.getClientId()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("Username: " + token.getUsername()), (Object[])new Object[0]);
                }
                this._tokenCache.remove(token.getId());
            }
            return result;
        }
        while (tokenIter.hasNext()) {
            OAuth20Token token = tokenIter.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processTokenRequest: Found token to remove from cash.", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Type: " + token.getType()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Subtype: " + token.getSubType()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("ClientId: " + token.getClientId()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Username: " + token.getUsername()), (Object[])new Object[0]);
            }
            this._tokenCache.remove(token.getId());
        }
        return result;
    }

    void getAccessTokenFromHttpHeader(HttpServletRequest request, AttributeList attributeList) throws OAuth20DuplicateParameterException, OAuth20BadParameterFormatException {
        if (attributeList.getAttributeValueByNameAndType("access_token", "urn:ibm:names:oauth:param") != null) {
            attributeList.setAttribute("access_token", "urn:ibm:names:oauth:param", new String[0]);
        }
        this.addAccessTokenHeaderToAttributeList(request, attributeList);
    }

    void populateJwtAccessTokenData(OAuth20Client client, AttributeList attributeList) {
        JsonArray jsonAudiences;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("populateJwtAccessTokenData client:" + client), (Object[])new Object[0]);
        }
        String clientSecret = client.getClientSecret();
        attributeList.setAttribute("client_secret", "urn:ibm:names:oauth:param", new String[]{clientSecret});
        String[] resource = attributeList.getAttributeValuesByNameAndType("resource", "urn:ibm:names:oauth:param");
        if (resource == null && client instanceof OidcOAuth20Client && (jsonAudiences = ((OidcOAuth20Client)client).getResourceIds()) != null) {
            String[] audiences = new String[jsonAudiences.size()];
            int iCnt = 0;
            for (JsonElement jsonAudience : jsonAudiences) {
                audiences[iCnt] = jsonAudience.getAsString();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("audience:" + audiences[iCnt]), (Object[])new Object[0]);
                }
                ++iCnt;
            }
            attributeList.setAttribute("resource", "urn:ibm:names:oauth:param", audiences);
        }
    }

    private OAuthResult processException(AttributeList attributeList, OAuth20Mediator mediator, OAuthException e) {
        OAuthResultImpl result;
        try {
            if (mediator != null) {
                mediator.mediateTokenException(attributeList, e);
            }
            result = new OAuthResultImpl(1, attributeList, e);
        }
        catch (OAuth20MediatorException me) {
            result = new OAuthResultImpl(1, attributeList, me);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAuthResult processResourceRequest(HttpServletRequest request) {
        String methodName = "processResourceRequest(HttpServletRequest)";
        this._log.entering(CLASS, methodName);
        OAuthResult result = null;
        AttributeList attributeList = new AttributeList();
        OAuth20RequestContext requestContext = new OAuth20RequestContext();
        try {
            attributeList = this.buildResourceAttributeList(request);
            if (request.getRequestURI().contains("/app-passwords") || request.getRequestURI().contains("/app-tokens")) {
                this.getAccessTokenFromHttpHeader(request, attributeList);
            }
            result = this.processResourceRequestInternal(requestContext, attributeList);
            this._log.exiting(CLASS, methodName, result);
        }
        catch (OAuthException e) {
            try {
                result = new OAuthResultImpl(1, attributeList, e);
                this._log.exiting(CLASS, methodName, result);
            }
            catch (Throwable throwable) {
                this._log.exiting(CLASS, methodName, result);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAuthResult processResourceRequest(AttributeList attributeList) {
        String methodName = "processResourceRequest(AttributeList)";
        this._log.entering(CLASS, methodName);
        OAuthResult result = null;
        OAuth20RequestContext requestContext = new OAuth20RequestContext();
        try {
            result = this.processResourceRequestInternal(requestContext, attributeList);
        }
        finally {
            this._log.exiting(CLASS, methodName, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OAuthResult processResourceRequestInternal(OAuth20RequestContext requestContext, AttributeList attributeList) {
        String methodName = "processResourceRequestInternal";
        boolean finestLoggable = this._log.isLoggable(Level.FINEST);
        this._log.entering(CLASS, methodName, new Object[]{attributeList});
        OAuthResultImpl result = null;
        OAuth20Mediator mediator = null;
        try {
            mediator = OAuth20MediatorFactory.getMediator(this);
            if (attributeList != null) {
                OAuth20TokenTypeHandler tth = OAuth20TokenTypeHandlerFactory.getHandler(this);
                String tokenType = tth.getTypeTokenType();
                List<String> tokenKeys = tth.getKeysTokenType(attributeList);
                ArrayList<OAuth20Token> tokens = new ArrayList<OAuth20Token>();
                if (tokenKeys != null) {
                    ListIterator<String> keyIter = tokenKeys.listIterator();
                    while (keyIter.hasNext()) {
                        String key;
                        String tokenLookupStr = key = keyIter.next();
                        if (OidcOAuth20Util.isJwtToken(key)) {
                            tokenLookupStr = HashUtils.digest(key);
                        }
                        OAuth20Token token = this.getOAuth20Token(requestContext, tokenLookupStr, "access_token", tokenType, false);
                        tokens.add(token);
                    }
                }
                tth.validateRequestTokenType(attributeList, tokens);
                attributeList.setAttribute("authorized", "urn:ibm:names:oauth:response:decision", new String[]{"TRUE"});
                tth.buildResponseTokenType(attributeList, tokens);
                mediator.mediateResource(attributeList);
                if (finestLoggable) {
                    this._log.logp(Level.FINEST, CLASS, methodName, "Response attributes: " + attributeList);
                }
            } else {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "access_token", null);
            }
            AttributeList enforcementPointAttributeList = new AttributeList();
            Attribute[] responseAttributes = attributeList.getAttributesByType("urn:ibm:names:oauth:response:attribute");
            Attribute[] decisionAttributes = attributeList.getAttributesByType("urn:ibm:names:oauth:response:decision");
            this.addResponseAttributes(enforcementPointAttributeList, responseAttributes);
            this.addResponseAttributes(enforcementPointAttributeList, decisionAttributes);
            result = new OAuthResultImpl(0, enforcementPointAttributeList);
            this._log.exiting(CLASS, methodName, result);
        }
        catch (OAuthException e) {
            try {
                try {
                    if (mediator != null) {
                        mediator.mediateResourceException(attributeList, e);
                    }
                    result = new OAuthResultImpl(1, attributeList, e);
                }
                catch (OAuth20MediatorException me) {
                    result = new OAuthResultImpl(1, attributeList, me);
                }
                this._log.exiting(CLASS, methodName, result);
            }
            catch (Throwable throwable) {
                this._log.exiting(CLASS, methodName, result);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public OidcOAuth20ClientProvider getClientProvider() {
        return this._clientProvider;
    }

    @Override
    public OAuth20TokenCache getTokenCache() {
        return this._tokenCache;
    }

    @Override
    public OAuthStatisticsImpl getStatisticsImpl() {
        return this._stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OAuth20Client getOAuth20Client(OAuth20RequestContext requestContext, String clientId, String clientSecret, String redirectUri, boolean isTokenRequest) throws OAuthException {
        String methodName = "getOAuth20Client";
        this._log.entering(CLASS, methodName, new Object[]{clientId, clientSecret, redirectUri, isTokenRequest});
        OAuth20Client result = null;
        try {
            if (clientId == null || clientId.length() == 0) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "client_id", null);
            }
            result = requestContext.getRequestClientCache().get(clientId);
            if (result == null) {
                result = this._clientProvider.get(clientId);
            }
            if (result == null || !clientId.equals(result.getClientId()) || !result.isEnabled()) {
                throw new OAuth20InvalidClientException("security.oauth20.error.invalid.client", clientId, isTokenRequest);
            }
            if (clientSecret != null && clientSecret.length() > 0 && !this._clientProvider.validateClient(clientId, clientSecret)) {
                throw new OAuth20InvalidClientSecretException("security.oauth20.error.invalid.clientsecret", clientId);
            }
            JsonArray registered = result.getRedirectUris();
            boolean allowRegexpRedirects = result.getAllowRegexpRedirects();
            if (registered != null && registered.size() > 0 && !OidcOAuth20Util.validateRedirectUris(registered, allowRegexpRedirects)) {
                throw new OAuth20InvalidRedirectUriException("security.oauth20.error.invalid.registered.redirecturi", OidcOAuth20Util.getSpaceDelimitedString(registered), null);
            }
            if (redirectUri != null && redirectUri.length() > 0) {
                if (registered == null || !OAuth20Util.validateRedirectUri(redirectUri)) {
                    throw new OAuth20InvalidRedirectUriException("security.oauth20.error.invalid.redirecturi", redirectUri, null);
                }
                if (!OidcOAuth20Util.jsonArrayContainsString(registered, redirectUri, allowRegexpRedirects)) {
                    throw new OAuth20InvalidRedirectUriException("security.oauth20.error.invalid.redirecturi.mismatch", redirectUri, OidcOAuth20Util.getSpaceDelimitedString(registered), null);
                }
            }
            if (result != null) {
                requestContext.getRequestClientCache().put(clientId, result);
            }
            this._log.exiting(CLASS, methodName, result);
        }
        catch (Throwable throwable) {
            this._log.exiting(CLASS, methodName, result);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AttributeList buildAuthorizationAttributeList(String username, String clientId, String redirectUri, String responseType, String state, String[] authorizedScopes) throws OAuthException {
        String methodName = "buildAuthorizationAttributeList";
        this._log.entering(CLASS, methodName);
        AttributeList result = new AttributeList();
        try {
            result.setAttribute("request_type", "urn:ibm:names:oauth:request", new String[]{"authorization"});
            OAuth20Util.validateRequiredAttribute("username", username);
            this.addParameterToAttributeList("username", "urn:ibm:names:oauth:request", username, result);
            OAuth20Util.validateRequiredAttribute("client_id", clientId);
            this.addParameterToAttributeList("client_id", "urn:ibm:names:query:param", clientId, result);
            if (redirectUri != null && redirectUri.length() > 0) {
                this.addParameterToAttributeList("redirect_uri", "urn:ibm:names:query:param", redirectUri, result);
            }
            OAuth20Util.validateRequiredAttribute("response_type", responseType);
            this.addParameterToAttributeList("response_type", "urn:ibm:names:query:param", responseType, result);
            if (state != null && state.length() > 0) {
                this.addParameterToAttributeList("state", "urn:ibm:names:query:param", state, result);
            }
            if (authorizedScopes != null && authorizedScopes.length > 0) {
                HashSet<String> scopeSet = new HashSet<String>();
                for (int i = 0; i < authorizedScopes.length; ++i) {
                    String scope = authorizedScopes[i];
                    if (!scopeSet.add(scope)) continue;
                    this.addParameterToAttributeList("scope", "urn:ibm:names:oauth:request", scope, result);
                }
            }
        }
        finally {
            this._log.exiting(CLASS, methodName, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AttributeList buildTokenAttributeList(String grantType, OAuth20Client client, HttpServletRequest request, AttributeList attribList) throws OAuthException {
        String methodName = "buildTokenAttributeList";
        this._log.entering(CLASS, methodName);
        String[] resource = (String[])request.getAttribute("urn:ibm:names:authn:param:resource");
        if (resource != null) {
            attribList.setAttribute("resource", "urn:ibm:names:oauth:param", resource);
        }
        String clientId = client.getClientId();
        this.populateJwtAccessTokenData(client, attribList);
        String[] clientRedirectUris = this.getRedirectUris(client);
        try {
            String client_secret;
            attribList.setAttribute("request_type", "urn:ibm:names:oauth:request", new String[]{"access_token"});
            attribList.setAttribute("client_id", "urn:ibm:names:oauth:param", new String[]{clientId});
            attribList.setAttribute("client_redirect_uri", "urn:ibm:names:oauth:param", clientRedirectUris);
            this.populateFromQueryString(request, attribList);
            this.populateFromRequest(request, attribList);
            if ("urn:ietf:params:oauth:grant-type:jwt-bearer".equalsIgnoreCase(grantType) && ((client_secret = request.getParameter("client_secret")) == null || client_secret.length() == 0)) {
                client_secret = client.getClientSecret();
                this.addParameterToAttributeList("client_secret", "urn:ibm:names:oauth:response:metadata", client_secret, attribList);
            }
        }
        finally {
            this._log.exiting(CLASS, methodName, attribList);
        }
        return attribList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AttributeList buildResourceAttributeList(HttpServletRequest request) throws OAuthException {
        String methodName = "buildResourceAttributeList";
        this._log.entering(CLASS, methodName);
        AttributeList result = new AttributeList();
        try {
            result.setAttribute("request_type", "urn:ibm:names:oauth:request", new String[]{"resource"});
            this.populateRequestMetaAttributes(request, result);
            this.populateFromAuthorizationHeader(request, result);
            this.populateFromQueryString(request, result);
            this.populateFromRequest(request, result);
        }
        finally {
            this._log.exiting(CLASS, methodName, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildRedirectUri(String redirectUri, String data, boolean implicit) {
        String methodName = "buildRedirectUri";
        this._log.entering(CLASS, methodName);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("redirectUri:'" + redirectUri + "' data:'" + data + "' implicit:" + implicit), (Object[])new Object[0]);
        }
        String result = null;
        try {
            String redirect = OAuth20Util.stripQueryAndFragment(redirectUri);
            String query = OAuth20Util.getQuery(redirectUri);
            StringBuffer redirectBuffer = new StringBuffer();
            redirectBuffer.append(redirect);
            StringBuffer queryBuffer = new StringBuffer();
            if (query != null) {
                queryBuffer.append(query);
            }
            StringBuffer fragmentBuffer = new StringBuffer();
            if (implicit) {
                fragmentBuffer.append(data.toString());
            } else {
                if (queryBuffer.length() > 0) {
                    queryBuffer.append("&");
                }
                queryBuffer.append(data.toString());
            }
            if (queryBuffer.length() > 0) {
                redirectBuffer.append("?" + queryBuffer.toString());
            }
            if (fragmentBuffer.length() > 0) {
                redirectBuffer.append("#" + fragmentBuffer.toString());
            }
            result = redirectBuffer.toString();
            this._log.exiting(CLASS, methodName, result);
        }
        catch (Throwable throwable) {
            this._log.exiting(CLASS, methodName, result);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OAuth20Token getOAuth20Token(OAuth20RequestContext requestContext, String key, String tokenType, String subType, boolean isTokenRequest) throws OAuthException {
        String methodName = "getOAuth20Token";
        this._log.entering(CLASS, methodName, new Object[]{key, tokenType, subType});
        OAuth20Token result = null;
        boolean isAuthorizationGrantTypeAndCodeSubType = "authorization_grant".equals(tokenType) && "authorization_code".equals(subType);
        try {
            if (isAuthorizationGrantTypeAndCodeSubType && this._tokenCache instanceof OAuth20EnhancedTokenCache) {
                String codekey = MessageDigestUtil.getDigest(key);
                result = ((OAuth20EnhancedTokenCache)this._tokenCache).getByHash(codekey);
            } else {
                result = this._tokenCache.get(key);
            }
            if (result == null || !tokenType.equalsIgnoreCase(result.getType()) || !subType.equalsIgnoreCase(result.getSubType())) {
                throw new OAuth20InvalidTokenException("security.oauth20.error.invalid.token", key, tokenType, subType, isTokenRequest);
            }
            if (OAuth20TokenHelper.isTokenExpired(result)) {
                this._tokenCache.remove(key);
                throw new OAuth20InvalidTokenException("security.oauth20.error.invalid.token.expired", key, tokenType, subType, isTokenRequest);
            }
            String clientId = result.getClientId();
            OAuth20Client client = requestContext.getRequestClientCache().get(clientId);
            if (client == null && (client = this._clientProvider.get(result.getClientId())) != null) {
                requestContext.getRequestClientCache().put(clientId, client);
            }
            if (client == null || !client.isEnabled()) {
                this._tokenCache.remove(key);
                throw new OAuth20InvalidTokenException("security.oauth20.error.invalid.token.client.not.available", key, tokenType, subType, isTokenRequest);
            }
        }
        finally {
            this._log.exiting(CLASS, methodName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateRequestMetaAttributes(HttpServletRequest request, AttributeList attributeList) throws OAuthException {
        String methodName = "populateRequestMetaAttributes";
        this._log.entering(CLASS, methodName);
        try {
            String hostname = request.getServerName();
            String method = request.getMethod();
            String path = request.getRequestURI();
            String scheme = request.getScheme();
            int port = request.getLocalPort();
            this.addParameterToAttributeList("host", "urn:ibm:names:oauth:request", hostname, attributeList);
            this.addParameterToAttributeList("method", "urn:ibm:names:oauth:request", method, attributeList);
            this.addParameterToAttributeList("path", "urn:ibm:names:oauth:request", path, attributeList);
            this.addParameterToAttributeList("scheme", "urn:ibm:names:oauth:request", scheme, attributeList);
            if (!(port <= 0 || port == 80 && scheme != null && scheme.equalsIgnoreCase("http") && port == 443 && scheme != null && scheme.equalsIgnoreCase("https"))) {
                this.addParameterToAttributeList("port", "urn:ibm:names:oauth:request", "" + port, attributeList);
            }
        }
        finally {
            this._log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateFromAuthorizationHeader(HttpServletRequest request, AttributeList attributeList) throws OAuthException {
        String methodName = "populateFromAuthorizationHeader";
        this._log.entering(CLASS, methodName);
        boolean finestLoggable = this._log.isLoggable(Level.FINEST);
        try {
            String aznHeader = request.getHeader("Authorization");
            if (finestLoggable) {
                this._log.logp(Level.FINEST, CLASS, methodName, "Authorization header (length=" + (aznHeader == null ? -1 : aznHeader.length()) + "): " + aznHeader);
            }
            if (aznHeader != null && aznHeader.length() > 0) {
                String token = WebUtils.getBearerTokenFromAuthzHeader(aznHeader);
                if (token != null) {
                    if (finestLoggable) {
                        this._log.logp(Level.FINEST, CLASS, methodName, "Found bearer token: " + token);
                    }
                    this.addParameterToAttributeList("access_token", "urn:ibm:names:oauth:param", token, attributeList);
                } else if (finestLoggable) {
                    this._log.logp(Level.FINEST, CLASS, methodName, "Authorization header does not appear to contain Bearer token data");
                }
            } else if (finestLoggable) {
                this._log.logp(Level.FINEST, CLASS, methodName, "No Authorization header");
            }
        }
        finally {
            this._log.exiting(CLASS, methodName);
        }
    }

    private void populateFromQueryString(HttpServletRequest request, AttributeList attributeList) throws OAuthException {
        String methodName = "populateFromQueryString";
        this._log.entering(CLASS, methodName);
        boolean finestLoggable = this._log.isLoggable(Level.FINEST);
        try {
            String[] params;
            String queryString = request.getQueryString();
            if (queryString != null && (params = queryString.split("&")) != null) {
                for (int i = 0; i < params.length; ++i) {
                    String[] nameval = params[i].split("=", 2);
                    if (nameval != null && (nameval.length == 1 || nameval.length == 2)) {
                        String name = URLDecoder.decode(nameval[0], STATE_ENCODING);
                        String value = "";
                        if (nameval.length == 2) {
                            value = URLDecoder.decode(nameval[1], STATE_ENCODING);
                        }
                        String attrType = "urn:ibm:names:query:param";
                        if (name != null && name.equalsIgnoreCase("access_token")) {
                            attrType = "urn:ibm:names:oauth:param";
                        }
                        this.addParameterToAttributeList(name, attrType, value, attributeList);
                        if (!finestLoggable) continue;
                        this._log.logp(Level.FINEST, CLASS, methodName, "[" + name + "=" + value);
                        continue;
                    }
                    if (!finestLoggable) continue;
                    this._log.logp(Level.FINEST, CLASS, methodName, "Ignoring parameter string with no value: " + params[i]);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuth20InternalException("security.oauth20.error.internal.unsupported.encoding.exception", (Throwable)e, new String[0]);
        }
        finally {
            this._log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addParameterToAttributeList(String name, String type, String value, AttributeList attributeList) throws OAuth20DuplicateParameterException, OAuth20BadParameterFormatException {
        String methodName = "addParameterToAttributeList";
        if ("client_secret".equals(name)) {
            this._log.entering(CLASS, methodName, new Object[]{name, type, "secret_removed"});
        } else {
            this._log.entering(CLASS, methodName, new Object[]{name, type, value});
        }
        try {
            Attribute a = attributeList.getAttributeByNameAndType(name, type);
            if (a == null) {
                attributeList.setAttribute(name, type, new String[0]);
                a = attributeList.getAttributeByNameAndType(name, type);
            }
            List<String> values = a.getValues();
            if (name.equals("scope")) {
                String[] scopes;
                if (value != null && (scopes = value.split(" ")) != null) {
                    HashSet<String> scopeSet = new HashSet<String>();
                    for (int i = 0; i < scopes.length; ++i) {
                        String scope = scopes[i].trim();
                        if (scope == null || scope.length() <= 0) continue;
                        if (OAuth20Util.validateScopeString(scope)) {
                            scopeSet.add(scope);
                            continue;
                        }
                        throw new OAuth20BadParameterFormatException("security.oauth20.error.parameter.format", "scope", scope);
                    }
                    values.addAll(scopeSet);
                }
            } else {
                if (OAuth20Constants.OAuth20RequestParametersSet.contains(name) && values.size() > 0) {
                    throw new OAuth20DuplicateParameterException("security.oauth20.error.duplicate.parameter", name);
                }
                if (value != null && value.length() > 0) {
                    values.add(value);
                }
            }
        }
        finally {
            this._log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateFromRequest(HttpServletRequest request, AttributeList attributeList) throws OAuthException {
        String methodName = "populateFromRequest";
        this._log.entering(CLASS, methodName);
        boolean finestLoggable = this._log.isLoggable(Level.FINEST);
        try {
            if (this.containsFormData(request)) {
                Enumeration e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    String[] values = request.getParameterValues(name);
                    String attrType = "urn:ibm:names:body:param";
                    if (name != null && name.equalsIgnoreCase("access_token")) {
                        attrType = "urn:ibm:names:oauth:param";
                    }
                    String[] existingVals = attributeList.getAttributeValuesByNameAndType(name, "urn:ibm:names:query:param");
                    ArrayList<String> valueList = new ArrayList<String>();
                    if (existingVals != null) {
                        valueList.addAll(Arrays.asList(existingVals));
                    }
                    if (values == null) continue;
                    for (int j = 0; j < values.length; ++j) {
                        String value = values[j];
                        if (valueList.contains(value)) {
                            valueList.remove(value);
                            continue;
                        }
                        this.addParameterToAttributeList(name, attrType, value, attributeList);
                        if (!finestLoggable) continue;
                        if ("client_secret".equals(name)) {
                            this._log.logp(Level.FINEST, CLASS, methodName, name + "=secret_removed");
                            continue;
                        }
                        this._log.logp(Level.FINEST, CLASS, methodName, name + "=" + value);
                    }
                }
            }
        }
        finally {
            this._log.exiting(CLASS, methodName);
        }
    }

    private void addRequestHeaderToAttributeList(HttpServletRequest request, AttributeList attributeList) throws OAuth20DuplicateParameterException, OAuth20BadParameterFormatException {
        String methodName = "addRequestHeaderToAttributeList";
        this._log.entering(CLASS, methodName);
        String hostname = null;
        if (request != null) {
            hostname = request.getHeader("X-Forwarded-Host");
        }
        if (hostname != null && !hostname.isEmpty()) {
            this.addParameterToAttributeList("X-Forwarded-Host", "urn:ibm:names:header:param", hostname, attributeList);
        }
        this._log.exiting(CLASS, methodName);
    }

    private void addAccessTokenHeaderToAttributeList(HttpServletRequest request, AttributeList attributeList) throws OAuth20DuplicateParameterException, OAuth20BadParameterFormatException {
        String methodName = "addAccessTokenHeaderToAttributeList";
        this._log.entering(CLASS, methodName);
        String token = null;
        if (request != null) {
            token = request.getHeader("access_token");
        }
        if (token != null && !token.isEmpty()) {
            this.addParameterToAttributeList("access_token", "urn:ibm:names:oauth:param", token, attributeList);
        }
        this._log.exiting(CLASS, methodName);
    }

    private void populateFromRequestForOpenIDConnect(AttributeList attributeList, HttpServletRequest request) throws OAuth20DuplicateParameterException, OAuth20BadParameterFormatException {
        String methodName = "populateFromRequestForOpenIDConnect";
        this._log.entering(CLASS, methodName);
        String hostname = request.getServerName();
        String scheme = request.getScheme();
        int port = request.getLocalPort();
        String path = request.getRequestURI();
        int lastSlashIndex = path.lastIndexOf("/");
        String issuerIdentifier = scheme + "://" + hostname + ":" + port + path.substring(0, lastSlashIndex);
        this.addParameterToAttributeList("issuerIdentifier", "urn:ibm:names:oauth:request", issuerIdentifier, attributeList);
        if (request.getAttribute("OidcRequest") != null) {
            this.addParameterToAttributeList("request_feature", "urn:ibm:names:oauth:request", "oidc", attributeList);
        }
        this._log.exiting(CLASS, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsFormData(HttpServletRequest request) {
        String methodName = "containsFormData";
        this._log.entering(CLASS, methodName);
        boolean finestLoggable = this._log.isLoggable(Level.FINEST);
        boolean result = false;
        try {
            boolean isChunked;
            String contentType = request.getHeader("Content-Type");
            String transferEncoding = request.getHeader("Transfer-Encoding");
            boolean bl = isChunked = transferEncoding != null && transferEncoding.toLowerCase().indexOf("chunked") >= 0;
            if (contentType != null && contentType.toLowerCase().indexOf("application/x-www-form-urlencoded") >= 0 && !isChunked) {
                result = true;
                if (finestLoggable) {
                    this._log.logp(Level.FINEST, CLASS, methodName, "Content type is application/x-www-form-urlencoded and request is not chunked");
                }
            }
        }
        finally {
            this._log.exiting(CLASS, methodName, "" + result);
        }
        return result;
    }

    private String buildResponseDataString(AttributeList attributeList, boolean bJsonLater, boolean bImplicit) {
        StringBuffer data = new StringBuffer();
        Attribute[] attributes = attributeList.getAttributesByType("urn:ibm:names:oauth:response:attribute");
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                String value;
                int j;
                String name = attributes[i].getName();
                List<String> values = attributes[i].getValues();
                if (name.equals("scope")) {
                    if (!bJsonLater && !bImplicit) continue;
                    if (data.length() > 0) {
                        data.append("&");
                    }
                    data.append(name + "=");
                    if (values.size() <= 0) continue;
                    for (j = 0; j < values.size(); ++j) {
                        value = values.get(j);
                        if (!bJsonLater) {
                            value = this.encode(value, STATE_ENCODING);
                        }
                        data.append(value);
                        if (j >= values.size() - 1) continue;
                        data.append(bJsonLater ? " " : "%20");
                    }
                    continue;
                }
                for (j = 0; j < values.size(); ++j) {
                    value = values.get(j);
                    if (!bJsonLater) {
                        value = this.encode(value, STATE_ENCODING);
                    }
                    if (data.length() > 0) {
                        data.append("&");
                    }
                    data.append(name + "=" + value);
                    if (j >= values.size() - 1) continue;
                    data.append("&");
                }
            }
        }
        return data.toString();
    }

    protected String encode(String value, String stateEncoding) {
        try {
            value = URLEncoder.encode(value, stateEncoding);
        }
        catch (UnsupportedEncodingException e) {
            this._log.logp(Level.WARNING, CLASS, "encode", "Can NOT URLEncode value:" + value + " encoding:" + stateEncoding);
        }
        return value;
    }

    private void addResponseAttributes(AttributeList attributeList, Attribute[] attrs) {
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                List<String> vals = attrs[i].getValues();
                String[] valsArray = new String[vals.size()];
                for (int j = 0; j < vals.size(); ++j) {
                    valsArray[j] = vals.get(j);
                }
                attributeList.setAttribute(attrs[i].getName(), attrs[i].getType(), valsArray);
            }
        }
    }

    private String[] getRedirectUris(OAuth20Client client) {
        String[] redirectUris = null;
        JsonArray redirectUriArray = client.getRedirectUris();
        if (redirectUriArray == null) {
            redirectUris = new String[]{};
        } else {
            redirectUris = new String[redirectUriArray.size()];
            for (int iI = 0; iI < redirectUris.length; ++iI) {
                redirectUris[iI] = redirectUriArray.get(iI).getAsString();
            }
        }
        return redirectUris;
    }

    public void postRedirect(HttpServletResponse response, AttributeList attributeList, String redirectUri) throws OAuth20InternalException {
        StringBuffer sb = new StringBuffer();
        try {
            String redirect = OAuth20Util.stripQueryAndFragment(redirectUri);
            String query = OAuth20Util.getQuery(redirectUri);
            sb.append("<HTML xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">");
            sb.append("<HEAD><title>Submit This Form</title></HEAD>");
            sb.append("<BODY onload=\"javascript:document.forms[0].submit()\">");
            sb.append("<FORM name=\"redirectform\" id=\"redirectform\" action=\"");
            sb.append(redirect);
            sb.append("\" method=\"POST\">");
            this.addHiddenInputs(sb, query);
            this.addHiddenInputs(sb, attributeList);
            sb.append("<button type=\"submit\" name=\"redirectform\">Process request</button>");
            sb.append("</FORM></BODY></HTML>");
        }
        catch (Exception e) {
            throw new OAuth20InternalException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("... expect to be redirected by the browser (\"POST\")\n" + sb.toString()), (Object[])new Object[0]);
        }
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private, max-age=0");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("text/html");
        try {
            PrintWriter out = response.getWriter();
            out.println(sb.toString());
            out.flush();
        }
        catch (IOException e) {
            String[] objs = new String[]{redirectUri, e.getMessage()};
            throw new OAuth20InternalException("security.oauth20.error.authorization.internal.ioexception", (Throwable)e, objs);
        }
    }

    void addHiddenInputs(StringBuffer sb, AttributeList attributeList) {
        Attribute[] attributes = attributeList.getAttributesByType("urn:ibm:names:oauth:response:attribute");
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                String key = attributes[i].getName();
                List<String> values = attributes[i].getValues();
                if (key.equals("scope")) {
                    StringBuffer scopeSb = new StringBuffer();
                    if (values.size() > 0) {
                        int j = 0;
                        while (j < values.size()) {
                            String value = values.get(j++);
                            scopeSb.append(value);
                            if (j >= values.size()) continue;
                            scopeSb.append(" ");
                        }
                    }
                    this.addHiddenInput(sb, key, com.ibm.ws.security.oauth20.web.WebUtils.htmlEncode(scopeSb.toString()));
                    continue;
                }
                for (int j = 0; j < values.size(); ++j) {
                    String value = values.get(j);
                    this.addHiddenInput(sb, key, com.ibm.ws.security.oauth20.web.WebUtils.htmlEncode(value));
                }
            }
        }
    }

    void addHiddenInputs(StringBuffer sb, String query) {
        String[] entries;
        if (query == null || query.isEmpty()) {
            return;
        }
        for (String entry : entries = query.split("&")) {
            int index = entry.indexOf("=");
            if (index < 0) {
                this.addHiddenInput(sb, entry, "");
                continue;
            }
            String key = entry.substring(0, index);
            String value = entry.substring(index + 1);
            this.addHiddenInput(sb, key, com.ibm.ws.security.oauth20.web.WebUtils.htmlEncode(value));
        }
    }

    private void addHiddenInput(StringBuffer sb, String key, String value) {
        key = key.trim();
        value = value.trim();
        sb.append("<input type=\"hidden\" name=\"" + key + "\"");
        sb.append(" value=\"" + value + "\" />");
    }

    void sendRedirect(HttpServletResponse response, AttributeList attributeList, String responseRedirectURI, boolean implicit) throws OAuth20InternalException {
        String methodName = "sendRedirect";
        boolean finestLoggable = this._log.isLoggable(Level.FINEST);
        String data = this.buildResponseDataString(attributeList, false, implicit);
        String redirect = this.buildRedirectUri(responseRedirectURI, data.toString(), implicit);
        if (finestLoggable) {
            this._log.logp(Level.FINEST, CLASS, methodName, "_SSO OP redirecting to [" + redirect + "]");
        }
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        try {
            response.sendRedirect(redirect);
        }
        catch (IOException e) {
            String[] objs = new String[]{responseRedirectURI, e.getMessage()};
            throw new OAuth20InternalException("security.oauth20.error.authorization.internal.ioexception", (Throwable)e, objs);
        }
    }
}

