/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.claims;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.common.claims.UserClaims;
import com.ibm.ws.security.common.claims.UserClaimsRetriever;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={UserClaimsRetrieverService.class}, name="com.ibm.ws.security.openidconnect.server.internal.userclaimsretriever", immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class UserClaimsRetrieverService {
    private static final String KEY_AUTH_CACHE_SERVICE = "authCacheService";
    private static final String KEY_USER_REGISTRY_SERVICE = "userRegistryService";
    AtomicServiceReference<AuthCacheService> authCacheServiceRef = new AtomicServiceReference("authCacheService");
    AtomicServiceReference<UserRegistryService> userRegistryServiceRef = new AtomicServiceReference("userRegistryService");
    private UserClaimsRetriever userClaimsRetriever;
    static final long serialVersionUID = 6323855787549974260L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(service=AuthCacheService.class, name="authCacheService")
    protected void setAuthCacheService(ServiceReference<AuthCacheService> ref) {
        this.authCacheServiceRef.setReference(ref);
    }

    protected void unsetAuthCacheService(ServiceReference<AuthCacheService> ref) {
        this.authCacheServiceRef.unsetReference(ref);
    }

    @Reference(service=UserRegistryService.class, name="userRegistryService")
    protected void setUserRegistryService(ServiceReference<UserRegistryService> ref) {
        this.userRegistryServiceRef.setReference(ref);
    }

    protected void unsetUserRegistryService(ServiceReference<UserRegistryService> ref) {
        this.userRegistryServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.authCacheServiceRef.activate(cc);
        this.userRegistryServiceRef.activate(cc);
        ConfigUtils.setUserClaimsRetrieverService(this);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.authCacheServiceRef.deactivate(cc);
        this.userRegistryServiceRef.deactivate(cc);
        ConfigUtils.setUserClaimsRetrieverService(null);
    }

    @FFDCIgnore(value={Exception.class})
    public UserClaims getUserClaims(String username, String groupIdentifier) {
        try {
            UserClaimsRetriever userClaimsRetriever = this.getUserClaimsRetriever();
            return userClaimsRetriever.getUserClaims(username, groupIdentifier);
        }
        catch (Exception e) {
            return new UserClaims(null, groupIdentifier);
        }
    }

    private UserClaimsRetriever getUserClaimsRetriever() throws RegistryException {
        this.userClaimsRetriever = new UserClaimsRetriever((AuthCacheService)this.authCacheServiceRef.getService(), ((UserRegistryService)this.userRegistryServiceRef.getService()).getUserRegistry());
        return this.userClaimsRetriever;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(UserClaimsRetrieverService.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    }
}

