/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.form;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class FormRetriever {
    private static final String CLASS = FormRetriever.class.getName();
    private static com.ibm.ejs.ras.TraceComponent tc = Tr.register(FormRetriever.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HEADER_CONTENT_LANGUAGE = "Content-Language";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static Map<String, Item> templateCache = new HashMap<String, Item>();
    public static final int dftTemplateLifeTime = Integer.parseInt(System.getProperty(CLASS + ".defaultTemplateLifetime", "600"));
    private int lifetime;
    static final long serialVersionUID = -3197264472992731647L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public FormRetriever() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        this.lifetime = dftTemplateLifeTime;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Item getTemplate(String templateUrl, String acceptLanguage) throws IOException {
        String methodName = "getTemplate";
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, (Object)new Object[]{templateUrl, acceptLanguage});
        }
        String key = this.getKey(templateUrl, this.getLanguage(acceptLanguage));
        Item retVal = templateCache.get(key);
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("retrieve template from cache: " + retVal));
        }
        if (retVal != null && tc.isDebugEnabled()) {
            Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("template will expire at " + new Date(retVal.getExpriation())));
        }
        if (retVal == null || retVal.getExpriation() < System.currentTimeMillis()) {
            Map<String, Item> map = templateCache;
            synchronized (map) {
                retVal = templateCache.get(templateUrl);
                if (retVal == null || retVal.getExpriation() < System.currentTimeMillis()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("retrive form template from " + templateUrl));
                    }
                    if ((retVal = this.getTemplateFromRemote(templateUrl, acceptLanguage)).getLanguage() != null) {
                        key = this.getKey(templateUrl, retVal.getLanguage());
                    }
                    templateCache.put(key, retVal);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, (Object)retVal);
        }
        return retVal;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Item getTemplateFromRemote(String templateUrl, String acceptLanguage) throws IOException {
        String methodName = "getTemplateFromRemote";
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, (Object)new Object[]{templateUrl, acceptLanguage});
        }
        Item retVal = null;
        URL url = new URL(templateUrl);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        URLConnection conn = url.openConnection();
        if (acceptLanguage != null) {
            conn.setRequestProperty(HEADER_ACCEPT_LANGUAGE, acceptLanguage);
        }
        InputStream is = conn.getInputStream();
        byte[] buf = new byte[4096];
        int count = -1;
        while ((count = is.read(buf)) != -1) {
            baos.write(buf, 0, count);
        }
        is.close();
        baos.close();
        String contentLanguage = conn.getHeaderField(HEADER_CONTENT_LANGUAGE);
        String contentType = conn.getHeaderField(HEADER_CONTENT_TYPE);
        retVal = new Item(baos.toByteArray(), this.getLanguage(contentLanguage), contentType, this.lifetime);
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("retrieved template lang=" + contentLanguage + " ,type=" + contentType + " len=" + retVal.getContent().length));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, (Object)retVal);
        }
        return retVal;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private String getKey(String templateUrl, String language) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getKey", (Object)new Object[]{templateUrl, language});
        }
        StringBuilder sb = new StringBuilder();
        sb.append(templateUrl);
        if (language != null) {
            sb.append("@").append(language);
        }
        String string = sb.toString();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getKey", (Object)string);
        }
        return string;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private String getLanguage(String languageHeader) {
        String methodName = "getLanguage";
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, (Object)new Object[]{languageHeader});
        }
        String retVal = null;
        if (languageHeader != null) {
            String[] langs = languageHeader.split(",");
            String[] parts = langs[0].split(";");
            retVal = parts[0].trim().toLowerCase();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)methodName, retVal);
        }
        return retVal;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class Item {
        private byte[] content;
        private long expiration;
        private String language;
        private String contentType;
        static final long serialVersionUID = 4954870634596646869L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Item(byte[] content, String language, String contentType, int lifetimeInSecond) {
            this.content = content;
            this.language = language;
            this.expiration = System.currentTimeMillis() + (long)(lifetimeInSecond * 1000);
            this.contentType = contentType;
        }

        byte[] getContent() {
            return this.content;
        }

        long getExpriation() {
            return this.expiration;
        }

        String getLanguage() {
            return this.language;
        }

        String getContentType() {
            return this.contentType;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = com.ibm.websphere.ras.Tr.register(Item.class, null, null);
        }
    }
}

