/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins;

import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.ibm.oauth.core.api.oauth20.client.OAuth20Client;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import java.io.Serializable;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BaseClient
implements OAuth20Client,
Serializable {
    public static final String SN_CLIENT_ID = "client_id";
    public static final String SN_CLIENT_SECRET = "client_secret";
    public static final String SN_CLIENT_NAME = "client_name";
    public static final String SN_REDIRECT_URIS = "redirect_uris";
    public static final String SN_ALLOW_REGEXP_REDIRECTS = "allow_regexp_redirects";
    private static final long serialVersionUID = -6749898820928856404L;
    String _componentId;
    @Expose
    @SerializedName(value="client_id")
    String _clientId;
    @Expose
    @SerializedName(value="client_secret")
    String _clientSecret;
    @Expose
    @SerializedName(value="client_name")
    String _clientName;
    @Expose
    @SerializedName(value="redirect_uris")
    JsonArray _redirectURIs = new JsonArray();
    @Expose
    @SerializedName(value="allow_regexp_redirects")
    Boolean _allowRegexpRedirects;
    boolean _isEnabled;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public BaseClient(String componentId, String clientId, @Sensitive String clientSecret, String clientName, JsonArray redirectURIs, boolean isEnabled) {
        this._componentId = componentId;
        this._clientId = clientId;
        this._clientSecret = clientSecret;
        this._clientName = clientName;
        this._redirectURIs = redirectURIs;
        this._isEnabled = isEnabled;
        this._allowRegexpRedirects = false;
    }

    public String getComponentId() {
        return this._componentId;
    }

    @Override
    public String getClientId() {
        return this._clientId;
    }

    @Override
    @Sensitive
    public String getClientSecret() {
        return this._clientSecret;
    }

    @Override
    public String getClientName() {
        return this._clientName;
    }

    @Override
    public JsonArray getRedirectUris() {
        return this._redirectURIs;
    }

    @Override
    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void setComponentId(String componentId) {
        this._componentId = componentId;
    }

    public void setClientId(String clientId) {
        this._clientId = clientId;
    }

    public void setClientSecret(@Sensitive String clientSecret) {
        this._clientSecret = clientSecret;
    }

    public void setClientName(String clientName) {
        this._clientName = clientName;
    }

    public void setRedirectUris(JsonArray redirectURIs) {
        this._redirectURIs = redirectURIs;
    }

    public void setEnabled(boolean isEnabled) {
        this._isEnabled = isEnabled;
    }

    public boolean isConfidential() {
        return this._clientSecret != null && this._clientSecret.length() > 0;
    }

    @Override
    public String[] getExtensionProperty(String propertyName) {
        return null;
    }

    @Override
    public void setAllowRegexpRedirects(boolean value) {
        this._allowRegexpRedirects = value;
    }

    @Override
    public boolean getAllowRegexpRedirects() {
        return this._allowRegexpRedirects == null ? false : this._allowRegexpRedirects;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[_componentId=" + this._componentId);
        sb.append(" _clientId=" + this._clientId);
        sb.append(" _clientSecret=secret_removed");
        sb.append(" _displayName=" + this._clientName);
        sb.append(" _redirectURIs=" + OidcOAuth20Util.getSpaceDelimitedString(this._redirectURIs));
        sb.append(" _isEnabled=" + this._isEnabled);
        sb.append(" _allowRegexpRepRedirects=" + this._allowRegexpRedirects);
        sb.append("]");
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BaseClient.class, null, null);
    }
}

