/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.db;

import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.oauth20.client.OAuth20Client;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedClientProvider;
import com.ibm.ws.security.oauth20.exception.OAuthDataException;
import com.ibm.ws.security.oauth20.plugins.BaseClient;
import com.ibm.ws.security.oauth20.plugins.db.OAuthJDBCImpl;
import com.ibm.ws.security.oauth20.util.ClientUtils;
import com.ibm.ws.security.oauth20.util.DynaCacheUtils;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CachedDBClientProvider
extends OAuthJDBCImpl
implements OAuth20EnhancedClientProvider {
    static final String CLASS;
    Logger _log = Logger.getLogger(CLASS);
    private String componentId;
    private String tableName;
    private String clientCacheJndi;
    private Map<String, BaseClient> cache;
    private boolean hasRewrites;
    private String[] providerRewrites;
    static final long serialVersionUID = 2898400566666163733L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public CachedDBClientProvider() {
    }

    public CachedDBClientProvider(String componentId, DataSource ds, String tableName, @Sensitive Object[] credentials, String clientCacheJndi, String[] providerRewrites) {
        super(ds, credentials);
        this.componentId = componentId;
        this.tableName = tableName;
        this.clientCacheJndi = clientCacheJndi == null || "".equals(clientCacheJndi) ? "services/cache/OAuth20DBClientCache" : clientCacheJndi;
        this.providerRewrites = providerRewrites != null ? (String[])providerRewrites.clone() : null;
    }

    @Override
    @ManualTrace
    public void initialize() {
        String methodName = "initialize";
        this._log.entering(CLASS, methodName);
        boolean finestLoggable = this._log.isLoggable(Level.FINEST);
        try {
            if (finestLoggable) {
                this._log.logp(Level.FINEST, CLASS, methodName, "Using ComponentId: " + this.componentId);
            }
            this.cache = DynaCacheUtils.getDynamicCache(this.clientCacheJndi, new String[0], new BaseClient[0]);
            this.hasRewrites = ClientUtils.initRewrites(this.componentId, this.providerRewrites);
        }
        finally {
            this._log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public void init(OAuthComponentConfiguration config) {
        String methodName = "init";
        this._log.entering(CLASS, methodName);
        boolean finestLoggable = this._log.isLoggable(Level.FINEST);
        try {
            String clientCacheJndi;
            super.init(config);
            this.tableName = config.getConfigPropertyValue("oauthjdbc.client.table");
            this.componentId = config.getUniqueId();
            if (finestLoggable) {
                this._log.logp(Level.FINEST, CLASS, methodName, "Using ComponentId: " + this.componentId);
            }
            if ((clientCacheJndi = config.getConfigPropertyValue("oauth20.db.token.cache.jndi.clients")) == null || "".equals(clientCacheJndi)) {
                clientCacheJndi = "services/cache/OAuth20DBClientCache";
            }
            this.cache = DynaCacheUtils.getDynamicCache(clientCacheJndi, new String[0], new BaseClient[0]);
            this.hasRewrites = ClientUtils.initRewrites(config);
        }
        finally {
            this._log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public boolean exists(String clientId) {
        String methodName = "exists";
        boolean result = false;
        Connection conn = null;
        boolean error = false;
        OAuth20Client client = null;
        client = this.cache.get(clientId);
        if (client == null) {
            try {
                conn = this.getDBConnection();
                conn.setAutoCommit(false);
                client = this.loadClient(conn, clientId);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"123", (Object)this, (Object[])new Object[]{clientId});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
                error = true;
            }
            finally {
                this.closeConnection(conn, error);
            }
        }
        result = client != null;
        this._log.exiting(CLASS, methodName, "" + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public OAuth20Client get(String clientId) {
        String methodName = "get";
        this._log.entering(CLASS, methodName, new Object[]{clientId});
        BaseClient result = null;
        Connection conn = null;
        boolean error = false;
        result = this.cache.get(clientId);
        if (result == null) {
            try {
                conn = this.getDBConnection();
                conn.setAutoCommit(false);
                result = this.loadClient(conn, clientId);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"152", (Object)this, (Object[])new Object[]{clientId});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
                error = true;
            }
            finally {
                this.closeConnection(conn, error);
            }
        }
        if (this.hasRewrites && result != null) {
            result = ClientUtils.uriRewrite(result);
        }
        this._log.exiting(CLASS, methodName, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public boolean validateClient(String clientId, String clientSecret) {
        String methodName = "validateClient";
        this._log.entering(CLASS, methodName, new Object[]{clientId, "secret_removed"});
        BaseClient client = null;
        Connection conn = null;
        boolean error = false;
        boolean result = false;
        client = this.cache.get(clientId);
        if (client == null) {
            block8: {
                try {
                    if (clientSecret == null || clientSecret.length() <= 0) break block8;
                    conn = this.getDBConnection();
                    conn.setAutoCommit(false);
                    client = this.loadClient(conn, clientId);
                }
                catch (Exception exception) {
                    try {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"187", (Object)this, (Object[])new Object[]{clientId, clientSecret});
                        this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
                        error = true;
                    }
                    catch (Throwable throwable) {
                        this.closeConnection(conn, error);
                        throw throwable;
                    }
                    this.closeConnection(conn, error);
                }
            }
            this.closeConnection(conn, error);
        }
        if (client != null && client.isEnabled() && client.isConfidential()) {
            String storedSecret;
            if (this.hasRewrites) {
                client = ClientUtils.uriRewrite(client);
            }
            if ((storedSecret = client.getClientSecret()) != null && storedSecret.equals(clientSecret)) {
                result = true;
            }
        }
        this._log.exiting(CLASS, methodName, "" + result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public BaseClient put(BaseClient newClient) throws OAuthDataException {
        String methodName = "put";
        this._log.entering(CLASS, methodName, new Object[]{newClient});
        BaseClient retVal = newClient;
        Connection conn = null;
        boolean error = true;
        String clientId = newClient.getClientId();
        if (this.exists(clientId)) {
            this.delete(clientId);
        }
        try {
            conn = this.getDBConnection();
            conn.setAutoCommit(false);
            this.addClient(conn, newClient);
            error = false;
            this.cache.put(clientId, newClient);
        }
        catch (SQLException sQLException) {
            void e;
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"229", (Object)this, (Object[])new Object[]{newClient});
            throw new OAuthDataException((Exception)e);
        }
        finally {
            this.closeConnection(conn, error);
        }
        if (error) {
            retVal = null;
        }
        this._log.exiting(CLASS, methodName, new Object[0]);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public boolean delete(String clientIdentifier) {
        String methodName = "delete";
        this._log.entering(CLASS, methodName, new Object[]{clientIdentifier});
        Connection conn = null;
        boolean success = true;
        BaseClient cachedClient = this.cache.get(clientIdentifier);
        if (cachedClient != null) {
            BaseClient removed = this.cache.remove(clientIdentifier);
            this._log.fine("removed object from cache: " + removed);
            if (removed == null) {
                this._log.severe("Cannot remove cache object with ID: " + clientIdentifier);
            }
        }
        try {
            conn = this.getDBConnection();
            conn.setAutoCommit(false);
            success = this.deleteClient(conn, clientIdentifier);
            this.closeConnection(conn, !success);
        }
        catch (Exception removed) {
            try {
                void e;
                FFDCFilter.processException((Throwable)removed, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"262", (Object)this, (Object[])new Object[]{clientIdentifier});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
                success = false;
                this.closeConnection(conn, !success);
            }
            catch (Throwable throwable) {
                this.closeConnection(conn, !success);
                throw throwable;
            }
        }
        this._log.exiting(CLASS, methodName, success);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public Collection<BaseClient> getAll() {
        String methodName = "getAll";
        this._log.entering(CLASS, methodName, new Object[0]);
        Collection<BaseClient> results = null;
        Connection conn = null;
        boolean error = false;
        try {
            conn = this.getDBConnection();
            conn.setAutoCommit(false);
            results = this.findAllClients(conn);
            if (this.hasRewrites && results != null) {
                ArrayList<BaseClient> updatedResults = new ArrayList<BaseClient>();
                for (BaseClient result : results) {
                    updatedResults.add(ClientUtils.uriRewrite(result));
                }
                results = updatedResults;
            }
        }
        catch (Exception updatedResults) {
            void e;
            FFDCFilter.processException((Throwable)updatedResults, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"295", (Object)this, (Object[])new Object[0]);
            this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
            error = true;
        }
        finally {
            this.closeConnection(conn, error);
            this._log.exiting(CLASS, methodName, results);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    protected BaseClient loadClient(Connection conn, String clientId) {
        String methodName = "findClient";
        this._log.entering(CLASS, methodName, new Object[]{clientId});
        BaseClient result = null;
        ResultSet queryResults = null;
        Statement st = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE " + "COMPONENTID" + " = ? AND " + "CLIENTID" + " = ?";
            st = conn.prepareStatement(query);
            st.setString(1, this.componentId);
            st.setString(2, clientId);
            queryResults = st.executeQuery();
            while (queryResults != null && result == null && queryResults.next()) {
                result = this.createClient(queryResults, clientId);
                this.cache.put(result.getClientId(), result);
            }
        }
        catch (SQLException e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"327", (Object)this, (Object[])new Object[]{conn, clientId});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(queryResults);
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException sQLException) {
                        void e2;
                        FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"335", (Object)this, (Object[])new Object[]{conn, clientId});
                        this._log.logp(Level.SEVERE, CLASS, methodName, e2.getMessage(), (Throwable)e2);
                    }
                }
                this._log.exiting(CLASS, methodName, result);
                throw throwable;
            }
            this.closeResultSet(queryResults);
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e3) {
                    FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"335", (Object)this, (Object[])new Object[]{conn, clientId});
                    this._log.logp(Level.SEVERE, CLASS, methodName, e3.getMessage(), e3);
                }
            }
            this._log.exiting(CLASS, methodName, result);
        }
        this.closeResultSet(queryResults);
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException query) {
                FFDCFilter.processException((Throwable)query, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"335", (Object)this, (Object[])new Object[]{conn, clientId});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
            }
        }
        this._log.exiting(CLASS, methodName, result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    protected void addClient(Connection conn, BaseClient newClient) throws OAuthDataException {
        String methodName = "addClient";
        this._log.entering(CLASS, methodName, new Object[]{newClient});
        ResultSet queryResults = null;
        Statement st = null;
        try {
            String insert = "INSERT INTO " + this.tableName + " VALUES ( ?, ?, ?, ?, ?, ? )";
            st = conn.prepareStatement(insert);
            st.setString(1, this.componentId);
            st.setString(2, newClient.getClientId());
            st.setString(3, PasswordUtil.passwordEncode((String)newClient.getClientSecret()));
            st.setString(4, newClient.getClientName());
            st.setInt(6, 1);
            st.executeUpdate();
        }
        catch (SQLException e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"363", (Object)this, (Object[])new Object[]{conn, newClient});
                throw new OAuthDataException(e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(queryResults);
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException sQLException) {
                        void e2;
                        FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"370", (Object)this, (Object[])new Object[]{conn, newClient});
                        this._log.logp(Level.SEVERE, CLASS, methodName, e2.getMessage(), (Throwable)e2);
                    }
                }
                this._log.exiting(CLASS, methodName, null);
                throw throwable;
            }
        }
        this.closeResultSet(queryResults);
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException insert) {
                FFDCFilter.processException((Throwable)insert, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"370", (Object)this, (Object[])new Object[]{conn, newClient});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
            }
        }
        this._log.exiting(CLASS, methodName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    protected boolean deleteClient(Connection conn, String clientId) {
        Statement st;
        ResultSet queryResults;
        boolean success;
        String methodName;
        block13: {
            methodName = "deleteClient";
            this._log.entering(CLASS, methodName, new Object[]{this.tableName, this.componentId, clientId});
            success = true;
            queryResults = null;
            st = null;
            try {
                String del = "DELETE FROM " + this.tableName + " WHERE " + "COMPONENTID" + " = ? AND " + "CLIENTID" + " = ?";
                st = conn.prepareStatement(del);
                st.setString(1, this.componentId);
                st.setString(2, clientId);
                int numDeleted = st.executeUpdate();
                this._log.logp(Level.FINE, CLASS, methodName, "Num entries deleted: " + numDeleted);
                if (numDeleted >= 1) break block13;
                success = false;
            }
            catch (SQLException e) {
                try {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"399", (Object)this, (Object[])new Object[]{conn, clientId});
                    this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), e);
                    success = false;
                }
                catch (Throwable throwable) {
                    this.closeResultSet(queryResults);
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException sQLException) {
                            void e2;
                            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"407", (Object)this, (Object[])new Object[]{conn, clientId});
                            this._log.logp(Level.SEVERE, CLASS, methodName, e2.getMessage(), (Throwable)e2);
                        }
                    }
                    this._log.exiting(CLASS, methodName, null);
                    throw throwable;
                }
                this.closeResultSet(queryResults);
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e3) {
                        FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"407", (Object)this, (Object[])new Object[]{conn, clientId});
                        this._log.logp(Level.SEVERE, CLASS, methodName, e3.getMessage(), e3);
                    }
                }
                this._log.exiting(CLASS, methodName, null);
            }
        }
        this.closeResultSet(queryResults);
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException del) {
                void e;
                FFDCFilter.processException((Throwable)del, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"407", (Object)this, (Object[])new Object[]{conn, clientId});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
            }
        }
        this._log.exiting(CLASS, methodName, null);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    protected Collection<BaseClient> findAllClients(Connection conn) {
        String methodName = "findAllClients";
        this._log.entering(CLASS, methodName, new Object[0]);
        ArrayList<BaseClient> results = new ArrayList<BaseClient>();
        ResultSet queryResults = null;
        Statement st = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE " + "COMPONENTID" + " = ?";
            st = conn.prepareStatement(query);
            st.setString(1, this.componentId);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next()) {
                BaseClient result = this.createClient(queryResults);
                results.add(result);
            }
        }
        catch (SQLException e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"434", (Object)this, (Object[])new Object[]{conn});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(queryResults);
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException sQLException) {
                        void e2;
                        FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"442", (Object)this, (Object[])new Object[]{conn});
                        this._log.logp(Level.SEVERE, CLASS, methodName, e2.getMessage(), (Throwable)e2);
                    }
                }
                this._log.exiting(CLASS, methodName, results);
                throw throwable;
            }
            this.closeResultSet(queryResults);
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e3) {
                    FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"442", (Object)this, (Object[])new Object[]{conn});
                    this._log.logp(Level.SEVERE, CLASS, methodName, e3.getMessage(), e3);
                }
            }
            this._log.exiting(CLASS, methodName, results);
        }
        this.closeResultSet(queryResults);
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException query) {
                FFDCFilter.processException((Throwable)query, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"442", (Object)this, (Object[])new Object[]{conn});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
            }
        }
        this._log.exiting(CLASS, methodName, results);
        return results;
    }

    protected BaseClient createClient(ResultSet queryResults) throws SQLException {
        String clientId = queryResults.getString("CLIENTID");
        return this.createClient(queryResults, clientId);
    }

    protected BaseClient createClient(ResultSet queryResults, String clientId) throws SQLException {
        String clientSecret = queryResults.getString("CLIENTSECRET");
        clientSecret = PasswordUtil.passwordDecode((String)clientSecret);
        String displayName = queryResults.getString("DISPLAYNAME");
        String redirectURI = queryResults.getString("REDIRECTURI");
        int enabled = queryResults.getInt("ENABLED");
        BaseClient result = new BaseClient(this.componentId, clientId, clientSecret, displayName, OidcOAuth20Util.initJsonArray(redirectURI), enabled != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @ManualTrace
    protected int update(Connection conn, BaseClient newClient) {
        int retVal;
        block13: {
            Statement st;
            String methodName;
            block11: {
                methodName = "update";
                this._log.entering(CLASS, methodName, new Object[]{conn, newClient});
                st = null;
                retVal = 0;
                String insert2333333332 = "UPDATE " + this.tableName + " SET " + "COMPONENTID" + "=? ," + "CLIENTSECRET" + "=? ," + "DISPLAYNAME" + "=? ," + "REDIRECTURI" + "=? ," + "ENABLED" + "=? WHERE " + "CLIENTID" + " = ?  AND " + "COMPONENTID" + " = ?";
                st = conn.prepareStatement(insert2333333332);
                st.setString(1, this.componentId);
                st.setString(2, newClient.getClientSecret());
                st.setString(3, newClient.getClientName());
                st.setInt(5, newClient.isEnabled() ? 1 : 0);
                st.setString(6, newClient.getClientId());
                st.setString(7, this.componentId);
                retVal = st.executeUpdate();
                if (st == null) break block11;
                try {
                    st.close();
                }
                catch (SQLException insert2333333332) {
                    void e;
                    FFDCFilter.processException((Throwable)insert2333333332, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"505", (Object)this, (Object[])new Object[]{conn, newClient});
                    this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
                }
            }
            this._log.exiting(CLASS, methodName, retVal);
            break block13;
            catch (SQLException e) {
                block12: {
                    try {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"498", (Object)this, (Object[])new Object[]{conn, newClient});
                        this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), e);
                        if (st == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (SQLException sQLException) {
                                void e2;
                                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"505", (Object)this, (Object[])new Object[]{conn, newClient});
                                this._log.logp(Level.SEVERE, CLASS, methodName, e2.getMessage(), (Throwable)e2);
                            }
                        }
                        this._log.exiting(CLASS, methodName, retVal);
                        throw throwable;
                    }
                    try {
                        st.close();
                    }
                    catch (SQLException e3) {
                        FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"505", (Object)this, (Object[])new Object[]{conn, newClient});
                        this._log.logp(Level.SEVERE, CLASS, methodName, e3.getMessage(), e3);
                    }
                }
                this._log.exiting(CLASS, methodName, retVal);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public BaseClient update(BaseClient newClient) {
        BaseClient retVal;
        boolean error;
        Connection conn;
        String methodName;
        block4: {
            methodName = "update";
            this._log.entering(CLASS, methodName, new Object[]{newClient});
            this.cache.put(newClient.getClientId(), newClient);
            conn = null;
            error = false;
            retVal = null;
            try {
                conn = this.getDBConnection();
                conn.setAutoCommit(false);
                if (this.update(conn, newClient) != 1) break block4;
                retVal = newClient;
            }
            catch (Exception exception) {
                try {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"529", (Object)this, (Object[])new Object[]{newClient});
                    this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
                    error = true;
                }
                catch (Throwable throwable) {
                    this.closeConnection(conn, error);
                    this._log.exiting(CLASS, methodName, retVal);
                    throw throwable;
                }
                this.closeConnection(conn, error);
                this._log.exiting(CLASS, methodName, retVal);
            }
        }
        this.closeConnection(conn, error);
        this._log.exiting(CLASS, methodName, retVal);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public int getCount() {
        int result;
        block18: {
            Statement st;
            ResultSet queryResults;
            String methodName;
            block17: {
                methodName = "getCount";
                this._log.entering(CLASS, methodName, new Object[0]);
                result = -1;
                queryResults = null;
                st = null;
                Connection conn2333333332 = this.getDBConnection();
                conn2333333332.setAutoCommit(false);
                String query = "SELECT COUNT(*) AS \"TOTAL\" FROM " + this.tableName + " WHERE " + "COMPONENTID" + " = ?";
                st = conn2333333332.prepareStatement(query);
                st.setString(1, this.componentId);
                queryResults = st.executeQuery();
                while (queryResults != null && queryResults.next()) {
                    result = queryResults.getInt("TOTAL");
                }
                this.closeResultSet(queryResults);
                if (st == null) break block17;
                try {
                    st.close();
                }
                catch (SQLException conn2333333332) {
                    void e;
                    FFDCFilter.processException((Throwable)conn2333333332, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"576", (Object)this, (Object[])new Object[0]);
                    this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
                }
            }
            this._log.exiting(CLASS, methodName, result);
            break block18;
            catch (SQLException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"565", (Object)this, (Object[])new Object[0]);
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), e);
                break block18;
            }
            catch (OAuthDataException e222222) {
                FFDCFilter.processException((Throwable)e222222, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"568", (Object)this, (Object[])new Object[0]);
                this._log.logp(Level.SEVERE, CLASS, methodName, e222222.getMessage(), e222222);
                break block18;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeResultSet(queryResults);
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e22222) {
                        FFDCFilter.processException((Throwable)e22222, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBClientProvider", (String)"576", (Object)this, (Object[])new Object[0]);
                        this._log.logp(Level.SEVERE, CLASS, methodName, e22222.getMessage(), e22222);
                    }
                }
                this._log.exiting(CLASS, methodName, result);
            }
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CachedDBClientProvider.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
        CLASS = CachedDBClientProvider.class.getName();
    }
}

