/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.db;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DynamicDBMigrator {
    private static final String CLASS;
    private Logger log = Logger.getLogger(CLASS);
    private String tableName;
    private static final String ALTER_ADD_COL_CLIENTMETADATA = "ALTER TABLE %s ADD %s CLOB NOT NULL DEFAULT '{}'";
    private static final String ALTER_ADD_COLUMN = "ALTER TABLE %s ADD %s %s NOT NULL DEFAULT '{}'";
    static final long serialVersionUID = 3780270573044272500L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DynamicDBMigrator(String tableName) {
        this.tableName = tableName;
    }

    public DynamicDBMigrator() {
    }

    public void execute(Connection conn) {
        this.addTable(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addColumnToTable(Connection conn, String table, String column, String dataType) {
        String methodName = "addColumnToTable";
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement(String.format(ALTER_ADD_COLUMN, table, column, dataType));
            st.execute();
            this.closeStatement(st);
        }
        catch (SQLException sQLException) {
            try {
                void e;
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.DynamicDBMigrator", (String)"49", (Object)this, (Object[])new Object[]{conn, table, column, dataType});
                this.log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
                this.closeStatement(st);
            }
            catch (Throwable throwable) {
                this.closeStatement(st);
                throw throwable;
            }
        }
    }

    private void addTable(Connection conn) {
        this.addClientMetadataTable(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void addClientMetadataTable(Connection conn) {
        String methodName = "addClientMetadataTable";
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement(String.format(ALTER_ADD_COL_CLIENTMETADATA, this.tableName, "CLIENTMETADATA"));
            st.execute();
            this.closeStatement(st);
        }
        catch (SQLException sQLException) {
            try {
                void e;
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.DynamicDBMigrator", (String)"67", (Object)this, (Object[])new Object[]{conn});
                this.log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
                this.closeStatement(st);
            }
            catch (Throwable throwable) {
                this.closeStatement(st);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void closeStatement(Statement statement) {
        String methodName = "closeStatement";
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                void e;
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.DynamicDBMigrator", (String)"80", (Object)this, (Object[])new Object[]{statement});
                this.log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DynamicDBMigrator.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
        CLASS = DynamicDBMigrator.class.getName();
    }
}

