/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.SimpleTimeZone;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DateUtil {
    private static final SimpleDateFormat _RFC822DateFormatInternal;
    private static final SimpleDateFormat _RFC850DateFormatInternal;
    private static final SimpleDateFormat _ANSICDateFormatInternal;
    private static final SimpleTimeZone _gmtTimeZoneInternal;
    static final long serialVersionUID = 3779805821782210853L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Timestamp parseTimeRFC2616(String time) {
        if (time == null) {
            throw new IllegalArgumentException("time must not be null");
        }
        try {
            return DateUtil.parseTimeRFC822(time);
        }
        catch (ParseException parseException) {
            FFDCFilter.processException((Throwable)parseException, (String)"com.ibm.ws.security.oauth20.util.DateUtil", (String)"69", null, (Object[])new Object[]{time});
            try {
                return DateUtil.parseTimeRFC850(time);
            }
            catch (ParseException parseException2) {
                FFDCFilter.processException((Throwable)parseException2, (String)"com.ibm.ws.security.oauth20.util.DateUtil", (String)"74", null, (Object[])new Object[]{time});
                try {
                    return DateUtil.parseTimeANSIC(time);
                }
                catch (ParseException parseException3) {
                    FFDCFilter.processException((Throwable)parseException3, (String)"com.ibm.ws.security.oauth20.util.DateUtil", (String)"79", null, (Object[])new Object[]{time});
                    return null;
                }
            }
        }
    }

    public static synchronized Timestamp parseTimeRFC822(String time) throws ParseException {
        if (time == null) {
            throw new IllegalArgumentException("time must not be null");
        }
        return new Timestamp(_RFC822DateFormatInternal.parse(time).getTime());
    }

    public static synchronized Timestamp parseTimeRFC850(String time) throws ParseException {
        if (time == null) {
            throw new IllegalArgumentException("time must not be null");
        }
        return new Timestamp(_RFC850DateFormatInternal.parse(time).getTime());
    }

    public static synchronized Timestamp parseTimeANSIC(String time) throws ParseException {
        if (time == null) {
            throw new IllegalArgumentException("time must not be null");
        }
        return new Timestamp(_ANSICDateFormatInternal.parse(time).getTime());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DateUtil.class, null, null);
        _gmtTimeZoneInternal = new SimpleTimeZone(0, "GMT");
        _RFC822DateFormatInternal = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        _RFC822DateFormatInternal.setTimeZone(_gmtTimeZoneInternal);
        _RFC850DateFormatInternal = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss z", Locale.ENGLISH);
        _RFC850DateFormatInternal.setTimeZone(_gmtTimeZoneInternal);
        _ANSICDateFormatInternal = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.ENGLISH);
        _ANSICDateFormatInternal.setTimeZone(_gmtTimeZoneInternal);
    }
}

