/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.Base64;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.web.AbstractOidcEndpointServices;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CoverageMapEndpointServices
extends AbstractOidcEndpointServices {
    protected static final String MESSAGE_BUNDLE = "com.ibm.ws.security.oauth20.internal.resources.OAuthMessages";
    private static TraceComponent tc = Tr.register(CoverageMapEndpointServices.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    static final long serialVersionUID = 4915824348316262147L;

    protected void handleEndpointRequest(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws OidcServerException, IOException {
        if (!request.getMethod().equalsIgnoreCase("GET") && !request.getMethod().equalsIgnoreCase("HEAD")) {
            String errorMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_UNSUPPORTED_METHOD", (Object[])new Object[]{request.getMethod(), this.getClass().getSimpleName()}, (String)"CWWKS1433E: The HTTP method {0} is not supported for the service {1}.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "server_error", 405);
        }
        this.processHeadOrGet(provider, request, response);
    }

    private void processHeadOrGet(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws IOException, OidcServerException {
        CoverageMapEndpointServices.validateJsonAcceptable(request);
        this.validateTokenType(request, response);
        JsonArray members = new JsonArray();
        Set<String> trustedUriPrefixesSet = this.getTrustedUriPrefixes(provider.getClientProvider());
        for (String trustedUriPrefix : trustedUriPrefixesSet) {
            members.add((JsonElement)new JsonPrimitive(CoverageMapEndpointServices.addTrailingSlash(trustedUriPrefix)));
        }
        String eTag = this.getETag(members);
        response.addHeader("ETag", String.format("\"%s\"", eTag));
        response.setHeader("Cache-Control", CoverageMapEndpointServices.constructCacheControlHeaderWithMaxAge(true, String.valueOf(provider.getCoverageMapSessionMaxAge())));
        response.setHeader("Content-Type", "application/json");
        OidcServerException preconditionException = CoverageMapEndpointServices.checkConditionalExecution(request, true, true, eTag, null);
        if (preconditionException != null) {
            response.setStatus(preconditionException.getHttpStatus());
            response.flushBuffer();
            return;
        }
        if (request.getMethod().equalsIgnoreCase("GET")) {
            response.getOutputStream().print(OidcOAuth20Util.GSON_RAW.toJson((JsonElement)members));
        }
        response.setStatus(200);
        response.flushBuffer();
    }

    private Set<String> getTrustedUriPrefixes(OidcOAuth20ClientProvider clientProvider) throws OidcServerException {
        HashSet<String> trustedUriPrefixesSet = new HashSet<String>();
        Collection<OidcBaseClient> allClients = clientProvider.getAll();
        for (OidcBaseClient cr : allClients) {
            JsonArray trustedUriPrefixes = cr.getTrustedUriPrefixes();
            for (JsonElement trustedUriPrefix : trustedUriPrefixes) {
                trustedUriPrefixesSet.add(trustedUriPrefix.getAsString());
            }
        }
        return trustedUriPrefixesSet;
    }

    private String validateTokenType(HttpServletRequest request, HttpServletResponse response) throws IOException, OidcServerException {
        String queryString = request.getQueryString();
        if (queryString == null) {
            String errorMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_COVERAGE_MAP_MISSING_PARAMS", (Object[])new Object[]{"token_type"}, (String)"CWWKS1434E: Missing required parameters in request.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_request", 400);
        }
        Map<String, String[]> queryParms = CoverageMapEndpointServices.parseQueryParameters(queryString);
        String[] tokenTypes = queryParms.get("token_type");
        if (tokenTypes == null) {
            String errorMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_COVERAGE_MAP_MISSING_TOKEN_PARAM", (Object[])new Object[]{"token_type"}, (String)"CWWKS1435E: Missing {0} parameter in request.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_request", 400);
        }
        if (tokenTypes.length > 1) {
            String errorMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_COVERAGE_MAP_MULTIPLE_TOKEN_PARAM", (Object[])new Object[]{"token_type"}, (String)"CWWKS1436E: Request contains multiple {0} parameters.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_request", 400);
        }
        String tokenType = CoverageMapEndpointServices.decode(tokenTypes[0]);
        if (tokenType.equalsIgnoreCase("Bearer")) {
            return tokenType.toLowerCase();
        }
        String errorMsg = TraceNLS.getFormattedMessage(this.getClass(), (String)MESSAGE_BUNDLE, (String)"OAUTH_COVERAGE_MAP_UNRECOGNIZED_TOKEN_PARAM", (Object[])new Object[]{tokenType}, (String)"CWWKS1437E: Request contains unrecognized token type parameter {0}.");
        Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
        throw new OidcServerException(errorMsg, "invalid_request", 400);
    }

    /*
     * WARNING - void declaration
     */
    private String getETag(JsonArray appRoots) {
        MessageDigest digest;
        List<String> appRootsList = CoverageMapEndpointServices.getList(appRoots);
        Collections.sort(appRootsList);
        try {
            digest = MessageDigest.getInstance("MD5");
            for (String appRoot : appRootsList) {
                digest.update(Base64Coder.getBytes((String)appRoot));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.oauth20.web.CoverageMapEndpointServices", (String)"213", (Object)this, (Object[])new Object[]{appRoots});
            throw new RuntimeException((Throwable)e);
        }
        byte[] digestBytes = digest.digest();
        return Base64.encode(digestBytes);
    }
}

