/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.oauth.core.api.OAuthResult;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.internal.oauth20.OAuthResultImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Prompt {
    private static TraceComponent tc = Tr.register(Prompt.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final String ATTR_PROMPT = "prompt";
    private String value = null;
    private boolean prompt = false;
    private boolean none = false;
    private boolean login = false;
    private boolean consent = false;
    static final long serialVersionUID = 6873469872302897501L;

    Prompt(HttpServletRequest request) {
        String p = request.getParameter(ATTR_PROMPT);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prompt=" + p), (Object[])new Object[0]);
        }
        if (p != null) {
            this.prompt = true;
            this.value = p;
            if (p.contains("none")) {
                this.none = true;
            }
            if (p.contains("login")) {
                this.login = true;
            }
            if (p.contains("consent")) {
                this.consent = true;
            }
        }
    }

    Prompt() {
    }

    public OAuthResult errorLoginRequired() {
        OAuth20Exception oe = new OAuth20Exception("login_required", "End-User authentication is required. The prompt parameter value needs to be modified in order to display a login form, or a user credential needs to be supplied.", null);
        return new OAuthResultImpl(1, new AttributeList(), oe);
    }

    public OAuthResult errorLoginRequired(AttributeList al) {
        OAuth20Exception oe = new OAuth20Exception("login_required", "End-User authentication is required. The prompt parameter value needs to be modified in order to display a login form, or a user credential needs to be supplied.", null);
        return new OAuthResultImpl(1, al, oe);
    }

    public OAuthResult errorConsentRequired() {
        return this.errorConsentRequired(null);
    }

    public OAuthResult errorConsentRequired(AttributeList al) {
        OAuth20Exception oe = new OAuth20Exception("consent_required", "End-User consent is required. The prompt parameter value needs to be modified in order to display a consent form.", null);
        if (al == null) {
            al = new AttributeList();
        }
        return new OAuthResultImpl(1, al, oe);
    }

    public String getValue() {
        return this.value;
    }

    boolean hasPrompt() {
        return this.prompt;
    }

    boolean hasNone() {
        return this.none;
    }

    boolean hasLogin() {
        return this.login;
    }

    boolean hasConsent() {
        return this.consent;
    }
}

