/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.cdi.helper.Utils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.astefanutti.metrics.cdi.MetricName;
import io.astefanutti.metrics.cdi.MetricsExtension;
import io.astefanutti.metrics.cdi.MetricsParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Vetoed;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricResolver {
    @Inject
    private MetricRegistry registry;
    @Inject
    protected MetricsExtension extension;
    @Inject
    protected MetricName metricName;
    static final long serialVersionUID = 5350648443935529188L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    <E extends Member & AnnotatedElement> Of<Counted> counted(Class<?> topClass, E element) {
        return this.resolverOf(topClass, element, (Class)Counted.class);
    }

    <E extends Member & AnnotatedElement> Of<ConcurrentGauge> concurentGauged(Class<?> topClass, E element) {
        return this.resolverOf(topClass, element, (Class)ConcurrentGauge.class);
    }

    Of<Gauge> gauge(Class<?> topClass, Method method) {
        return this.resolverOf(topClass, method, Gauge.class);
    }

    <E extends Member & AnnotatedElement> Of<Metered> metered(Class<?> topClass, E element) {
        return this.resolverOf(topClass, element, (Class)Metered.class);
    }

    <E extends Member & AnnotatedElement> Of<Timed> timed(Class<?> bean, E element) {
        return this.resolverOf(bean, element, (Class)Timed.class);
    }

    private <E extends Member & AnnotatedElement, T extends Annotation> Of<T> resolverOf(Class<?> bean, E element, Class<T> metric) {
        if (((AnnotatedElement)element).isAnnotationPresent(metric)) {
            return this.elementResolverOf(element, metric);
        }
        return this.beanResolverOf(element, metric, bean);
    }

    protected <E extends Member & AnnotatedElement, T extends Annotation> Of<T> elementResolverOf(E element, Class<T> metric) {
        T annotation = ((AnnotatedElement)element).getAnnotation(metric);
        String name = this.extension.getMetricNameForMember(element, (Annotation)annotation);
        boolean initialDiscovery = false;
        if (name == null) {
            name = this.metricName(element, (Class<? extends Annotation>)metric, this.metricName((Annotation)annotation), this.isMetricAbsolute((Annotation)annotation));
            initialDiscovery = true;
        }
        MetadataBuilder mdb = Metadata.builder().withName(name).withType(this.getType((Annotation)annotation)).withUnit(this.getUnit((Annotation)annotation)).withDescription(this.getDescription((Annotation)annotation)).withDisplayName(this.getDisplayname((Annotation)annotation));
        String[] tags = this.getTags((Annotation)annotation);
        mdb = this.getReusable((Annotation)annotation) ? mdb.reusable() : mdb.notReusable();
        DoesHaveMetric of = new DoesHaveMetric((Annotation)annotation, name, mdb.build(), initialDiscovery, tags, null);
        this.checkReusable(of);
        return of;
    }

    protected <E extends Member & AnnotatedElement, T extends Annotation> Of<T> beanResolverOf(E element, Class<T> metric, Class<?> bean) {
        if (bean.isAnnotationPresent(metric)) {
            T annotation = bean.getAnnotation(metric);
            String name = this.extension.getMetricNameForMember(element, (Annotation)annotation);
            boolean initialDiscovery = false;
            if (name == null) {
                name = this.metricName(bean, element, (Class<? extends Annotation>)metric, this.metricName((Annotation)annotation), this.isMetricAbsolute((Annotation)annotation));
                initialDiscovery = true;
            }
            MetadataBuilder mdb = Metadata.builder().withName(name).withType(this.getType((Annotation)annotation)).withUnit(this.getUnit((Annotation)annotation)).withDescription(this.getDescription((Annotation)annotation)).withDisplayName(this.getDisplayname((Annotation)annotation));
            String[] tags = this.getTags((Annotation)annotation);
            mdb = this.getReusable((Annotation)annotation) ? mdb.reusable() : mdb.notReusable();
            DoesHaveMetric of = new DoesHaveMetric((Annotation)annotation, name, mdb.build(), initialDiscovery, tags, null);
            this.checkReusable(of);
            return of;
        }
        if (bean.getSuperclass() != null) {
            return this.beanResolverOf(element, metric, bean.getSuperclass());
        }
        return new DoesNotHaveMetric();
    }

    private <E extends Member & AnnotatedElement> String metricName(E element, Class<? extends Annotation> type, String name, boolean absolute) {
        String metric = name.isEmpty() ? this.defaultName(element, type) : this.metricName.of(name);
        return absolute ? metric : MetricRegistry.name(element.getDeclaringClass(), (String[])new String[]{metric});
    }

    private <E extends Member & AnnotatedElement> String metricName(Class<?> bean, E element, Class<? extends Annotation> type, String name, boolean absolute) {
        String metric = name.isEmpty() ? bean.getSimpleName() : this.metricName.of(name);
        return absolute ? MetricRegistry.name((String)metric, (String[])new String[]{this.defaultName(element, type)}) : MetricRegistry.name((String)bean.getPackage().getName(), (String[])new String[]{metric, this.defaultName(element, type)});
    }

    private <E extends Member & AnnotatedElement> String defaultName(E element, Class<? extends Annotation> type) {
        return this.memberName(element);
    }

    private String memberName(Member member) {
        if (member instanceof Constructor) {
            return member.getDeclaringClass().getSimpleName();
        }
        return member.getName();
    }

    private String metricName(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).name();
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return ((ConcurrentGauge)annotation).name();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).name();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).name();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).name();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private boolean isMetricAbsolute(Annotation annotation) {
        if (this.extension.getParameters().contains((Object)MetricsParameter.useAbsoluteName)) {
            return true;
        }
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).absolute();
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return ((ConcurrentGauge)annotation).absolute();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).absolute();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).absolute();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).absolute();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private String[] getTags(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).tags();
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return ((ConcurrentGauge)annotation).tags();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).tags();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).tags();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).tags();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private String getDisplayname(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).displayName();
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return ((ConcurrentGauge)annotation).displayName();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).displayName();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).displayName();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).displayName();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private String getDescription(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).description();
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return ((ConcurrentGauge)annotation).description();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).description();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).description();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).description();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private MetricType getType(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return MetricType.COUNTER;
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return MetricType.CONCURRENT_GAUGE;
        }
        if (Gauge.class.isInstance(annotation)) {
            return MetricType.GAUGE;
        }
        if (Metered.class.isInstance(annotation)) {
            return MetricType.METERED;
        }
        if (Timed.class.isInstance(annotation)) {
            return MetricType.TIMER;
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private String getUnit(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).unit();
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return "none";
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).unit();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).unit();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).unit();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private boolean getReusable(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).reusable();
        }
        if (ConcurrentGauge.class.isInstance(annotation)) {
            return ((ConcurrentGauge)annotation).reusable();
        }
        if (Gauge.class.isInstance(annotation)) {
            return false;
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).reusable();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).reusable();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private <T extends Annotation> boolean checkReusable(Of<T> of) {
        if (!of.isInitialDiscovery()) {
            return true;
        }
        String name = of.metadata().getName();
        String[] tags = of.tags();
        MetricID MetricID2 = new MetricID(name, Utils.tagsToTags(tags));
        Metadata existingMetadata = (Metadata)this.registry.getMetadata().get(MetricID2);
        if (!(existingMetadata == null || existingMetadata.isReusable() && of.metadata().isReusable())) {
            throw new IllegalArgumentException("Cannot reuse metric for " + of.metricName() + " with tags " + of.tags());
        }
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MetricResolver.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
    }

    @Vetoed
    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static final class DoesNotHaveMetric<T extends Annotation>
    implements Of<T> {
        static final long serialVersionUID = -4904605879829017239L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DoesNotHaveMetric() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public String metricName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T metricAnnotation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata metadata() {
            return null;
        }

        @Override
        public boolean isInitialDiscovery() {
            return false;
        }

        @Override
        public String[] tags() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DoesNotHaveMetric.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static final class DoesHaveMetric<T extends Annotation>
    implements Of<T> {
        private final T annotation;
        private final String name;
        private final Metadata metadata;
        private final boolean initialDiscovery;
        private final String[] tags;
        static final long serialVersionUID = 7987376624598700693L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DoesHaveMetric(T annotation, String name, Metadata metadata, boolean initialDiscovery, String[] tags) {
            this.annotation = annotation;
            this.name = name;
            this.metadata = metadata;
            this.initialDiscovery = initialDiscovery;
            this.tags = tags;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public String metricName() {
            return this.name;
        }

        @Override
        public T metricAnnotation() {
            return this.annotation;
        }

        @Override
        public Metadata metadata() {
            return this.metadata;
        }

        @Override
        public boolean isInitialDiscovery() {
            return this.initialDiscovery;
        }

        @Override
        public String[] tags() {
            return this.tags;
        }

        /* synthetic */ DoesHaveMetric(Annotation x0, String x1, Metadata x2, boolean x3, String[] x4, 1 x5) {
            this(x0, x1, x2, x3, x4);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DoesHaveMetric.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.cdi.resources.MetricsCDI");
        }
    }

    public static interface Of<T extends Annotation> {
        public boolean isPresent();

        public String metricName();

        public String[] tags();

        public Metadata metadata();

        public T metricAnnotation();

        public boolean isInitialDiscovery();
    }
}

