/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.BootstrapDefaults;
import com.ibm.ws.kernel.boot.internal.BootstrapManifest;
import com.ibm.ws.kernel.boot.internal.KernelResolver;
import com.ibm.ws.kernel.boot.internal.KernelUtils;
import com.ibm.ws.kernel.boot.internal.LauncherDelegate;
import com.ibm.ws.kernel.boot.internal.ServerLock;
import com.ibm.ws.kernel.boot.security.WLPDynamicPolicy;
import com.ibm.ws.kernel.boot.utils.SequenceNumber;
import com.ibm.ws.kernel.internal.classloader.BootstrapChildFirstJarClassloader;
import com.ibm.ws.kernel.internal.classloader.BootstrapChildFirstURLClassloader;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.kernel.provisioning.NameBasedLocalBundleRepository;
import com.ibm.ws.kernel.provisioning.ServiceFingerprint;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class KernelBootstrap {
    protected final BootstrapConfig bootProps;
    protected final ServerLock serverLock;
    protected final CountDownLatch delegateCreated = new CountDownLatch(1);
    protected LauncherDelegate launcherDelegate;
    protected File serverRunning = null;
    protected final boolean libertyBoot;

    public KernelBootstrap(BootstrapConfig bootProps) {
        this.bootProps = bootProps;
        this.libertyBoot = Boolean.parseBoolean(bootProps.get("wlp.liberty.boot"));
        this.serverLock = ServerLock.createServerLock(bootProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnCode go() {
        try {
            this.serverLock.obtainServerLock();
            this.clearServerStateDir();
            this.setupJMXOverride();
            this.setHttpRetryPost();
            this.setLoggerProperties();
            ServerLock.createServerRunningMarkerFile(this.bootProps);
            this.cleanStart();
            BootstrapManifest bootManifest = null;
            try {
                bootManifest = BootstrapManifest.readBootstrapManifest(this.libertyBoot);
            }
            catch (IOException e) {
                throw new LaunchException("Could not read the jar manifest", BootstrapConstants.messages.getString("error.unknown.kernel.version"), e);
            }
            BootstrapDefaults bootDefaults = null;
            try {
                bootDefaults = new BootstrapDefaults(this.bootProps);
            }
            catch (IOException e) {
                throw new LaunchException("Could not read the defaults file", BootstrapConstants.messages.getString("error.unknown.kernel.version"), e);
            }
            bootManifest.prepSystemPackages(this.bootProps);
            String kernelVersion = "wlp-" + bootManifest.getBundleVersion();
            String productInfo = KernelBootstrap.getProductInfoDisplayName();
            KernelResolver resolver = new KernelResolver(this.bootProps.getInstallRoot(), this.bootProps.getWorkareaFile("platform/kernel.cache"), bootDefaults.getKernelDefinition(this.bootProps), bootDefaults.getLogProviderDefinition(this.bootProps), bootDefaults.getOSExtensionDefinition(this.bootProps), this.libertyBoot);
            String logLevel = this.bootProps.get("com.ibm.ws.logging.console.log.level");
            boolean logVersionInfo = logLevel == null || !logLevel.equalsIgnoreCase("off");
            KernelBootstrap.processVersion(this.bootProps, "info.serverLaunch", kernelVersion, productInfo, logVersionInfo);
            if (logVersionInfo) {
                this.logSerialFilterMessage();
                List<String> cmdArgs = this.bootProps.getCmdArgs();
                if (cmdArgs != null && !cmdArgs.isEmpty()) {
                    System.out.println("\t" + MessageFormat.format(BootstrapConstants.messages.getString("info.cmdArgs"), cmdArgs));
                }
            }
            if (resolver.getForceCleanStart()) {
                KernelUtils.cleanStart(this.bootProps.getWorkareaFile(null));
            }
            ServiceFingerprint.putInstallDir(null, this.bootProps.getInstallRoot());
            String packages = this.bootProps.get("org.osgi.framework.system.packages.extra");
            packages = resolver.appendExtraSystemPackages(packages);
            if (packages != null) {
                this.bootProps.put("org.osgi.framework.system.packages.extra", packages);
            }
            ArrayList<URL> urlList = new ArrayList<URL>();
            if (!this.libertyBoot) {
                this.bootProps.addBootstrapJarURLs(urlList);
                resolver.addBootJars(urlList);
            }
            ClassLoader loader = this.buildClassLoader(urlList, this.bootProps.get("verifyJarSignature"));
            try {
                Class<? extends LauncherDelegate> clazz = this.getLauncherDelegateClass(loader);
                this.launcherDelegate = clazz.getConstructor(BootstrapConfig.class).newInstance(this.bootProps);
            }
            catch (Exception e) {
                this.rethrowException("Unable to create OSGi framework due to " + e, e);
            }
            this.delegateCreated.countDown();
            this.bootProps.setFrameworkClassloader(loader);
            this.bootProps.setKernelResolver(resolver);
            this.bootProps.setInstrumentation(this.getInstrumentation());
            if (!Boolean.parseBoolean(this.bootProps.get("server.no.start"))) {
                this.launcherDelegate.launchFramework();
            }
        }
        catch (LaunchException le) {
            throw le;
        }
        catch (Throwable e) {
            this.rethrowException("Caught unexpected exception " + e, e);
        }
        finally {
            this.delegateCreated.countDown();
            if (this.serverLock != null) {
                this.serverLock.releaseServerLock();
            }
        }
        return ReturnCode.OK;
    }

    private void clearServerStateDir() {
        File stateDir = this.bootProps.getOutputFile("logs/state");
        KernelUtils.cleanDirectory(stateDir, "state");
    }

    public Set<String> getServerContent(String osRequest) throws FileNotFoundException, IOException, InterruptedException {
        this.delegateCreated.await();
        if (this.launcherDelegate != null) {
            return this.launcherDelegate.queryFeatureInformation(osRequest);
        }
        return Collections.emptySet();
    }

    public Set<String> getServerFeatures() throws InterruptedException {
        this.delegateCreated.await();
        if (this.launcherDelegate != null) {
            return this.launcherDelegate.queryFeatureNames();
        }
        return Collections.emptySet();
    }

    public boolean waitForStarted() throws InterruptedException {
        this.delegateCreated.await();
        if (this.launcherDelegate != null) {
            return this.launcherDelegate.waitForReady();
        }
        return false;
    }

    public ReturnCode shutdown() throws InterruptedException {
        return this.shutdown(false);
    }

    public ReturnCode shutdown(boolean force) throws InterruptedException {
        this.delegateCreated.await();
        if (this.launcherDelegate != null && this.launcherDelegate.shutdown(force)) {
            return this.serverLock.waitForStop();
        }
        return ReturnCode.OK;
    }

    protected void setupJMXOverride() {
        System.setProperty("javax.management.builder.initial", "com.ibm.ws.kernel.boot.jmx.internal.PlatformMBeanServerBuilder");
    }

    private void setLoggerProperties() {
        String logManager = this.bootProps.get("java.util.logging.manager");
        if (logManager == null) {
            logManager = "com.ibm.ws.kernel.boot.logging.WsLogManager";
        }
        System.setProperty("java.util.logging.manager", logManager);
    }

    private void setHttpRetryPost() {
        String httpRetryPost = this.bootProps.get("sun.net.http.retryPost");
        if (httpRetryPost == null) {
            httpRetryPost = "false";
        }
        System.setProperty("sun.net.http.retryPost", httpRetryPost);
    }

    protected void cleanStart() {
        File workareaFile = this.bootProps.getWorkareaFile(null);
        if (ServiceFingerprint.hasServiceBeenApplied(this.bootProps.getInstallRoot(), workareaFile) || this.bootProps.checkCleanStart()) {
            ServiceFingerprint.clear();
            KernelUtils.cleanStart(workareaFile);
            this.bootProps.remove("org.osgi.framework.storage.clean");
            this.bootProps.remove("osgi.clean");
        }
    }

    protected Class<? extends LauncherDelegate> getLauncherDelegateClass(ClassLoader loader) throws ClassNotFoundException {
        String className = "com.ibm.ws.kernel.launch.internal.LauncherDelegateImpl";
        Class<?> clazz = loader.loadClass(className);
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        return clazz.asSubclass(LauncherDelegate.class);
    }

    protected ClassLoader buildClassLoader(final List<URL> urlList, String verifyJarProperty) {
        if (this.libertyBoot) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return this.getClass().getClassLoader();
                }
            });
        }
        final boolean verifyJar = System.getSecurityManager() == null ? "true".equalsIgnoreCase(verifyJarProperty) : true;
        KernelBootstrap.enableJava2SecurityIfSet(this.bootProps, urlList);
        ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader parent = this.getClass().getClassLoader();
                URL[] urls = urlList.toArray(new URL[urlList.size()]);
                if (verifyJar) {
                    return new BootstrapChildFirstURLClassloader(urls, parent);
                }
                try {
                    return new BootstrapChildFirstJarClassloader(urls, parent);
                }
                catch (RuntimeException e) {
                    return new BootstrapChildFirstURLClassloader(urls, parent);
                }
            }
        });
        return loader;
    }

    public static void enableJava2SecurityIfSet(BootstrapConfig bootProps, List<URL> urlList) {
        if (bootProps.get("websphere.java.security") != null) {
            NameBasedLocalBundleRepository repo = new NameBasedLocalBundleRepository(bootProps.getInstallRoot());
            urlList.add(KernelBootstrap.getJarFileFromBundleName(repo, "com.ibm.ws.org.eclipse.equinox.region", "[1.0,1.0.100)"));
            urlList.add(KernelBootstrap.getJarFileFromBundleName(repo, "com.ibm.ws.kernel.instrument.serialfilter", "[1.0,1.0.100)"));
            KernelBootstrap.addJarFileIfExist(urlList, bootProps.getInstallRoot() + "/bin/tools/ws-javaagent.jar");
            KernelBootstrap.addJarFileIfExist(urlList, bootProps.getInstallRoot() + "/lib/bootstrap-agent.jar");
            WLPDynamicPolicy wlpPolicy = new WLPDynamicPolicy(Policy.getPolicy(), urlList);
            Policy.setPolicy(wlpPolicy);
        }
    }

    private static URL getJarFileFromBundleName(NameBasedLocalBundleRepository repo, String bundleName, String versionRange) {
        File bestMatchFile = repo.selectBundle(bundleName, VersionUtility.stringToVersionRange(versionRange));
        if (bestMatchFile == null) {
            throw new LaunchException("Could not find bundle for " + bundleName + ".", BootstrapConstants.messages.getString("error.missingBundleException"));
        }
        try {
            return bestMatchFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new LaunchException("Failure to set the default Security Manager due to exception ", BootstrapConstants.messages.getString("error.set.securitymanager"), e);
        }
    }

    private static void addJarFileIfExist(List<URL> urlList, String name) {
        try {
            File file = new File(name);
            if (file.exists()) {
                urlList.add(file.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new LaunchException("Failure to set the default Security Manager due to exception ", BootstrapConstants.messages.getString("error.set.securitymanager"), e);
        }
    }

    public static void showVersion(BootstrapConfig bootProps) {
        try {
            BootstrapManifest bootManifest = BootstrapManifest.readBootstrapManifest(Boolean.parseBoolean(bootProps.get("wlp.liberty.boot")));
            String kernelVersion = bootManifest.getBundleVersion();
            String productInfo = KernelBootstrap.getProductInfoDisplayName();
            KernelBootstrap.processVersion(bootProps, "info.serverVersion", kernelVersion, productInfo, true);
        }
        catch (IOException e) {
            throw new LaunchException("Could not read the jar manifest", BootstrapConstants.messages.getString("error.unknown.kernel.version"), e);
        }
    }

    private static void processVersion(BootstrapConfig bootProps, String msgKey, String kernelVersion, String productInfo, boolean printVersion) {
        String versionString;
        String launchString;
        String consoleFormat = System.getenv("WLP_LOGGING_CONSOLE_FORMAT");
        if (productInfo == null) {
            launchString = "WebSphere Application Server/" + kernelVersion;
            versionString = "WebSphere Application Server (" + kernelVersion + ")";
        } else {
            launchString = productInfo + "/" + kernelVersion;
            versionString = productInfo + " (" + kernelVersion + ")";
        }
        String consoleLogHeader = MessageFormat.format(BootstrapConstants.messages.getString(msgKey), "info.serverLaunch".equals(msgKey) ? launchString : versionString, System.getProperty("java.vm.name"), System.getProperty("java.runtime.version") + " (" + Locale.getDefault() + ")", bootProps.getProcessName());
        if (printVersion) {
            if ("json".equals(consoleFormat)) {
                String jsonConsoleHeader = KernelBootstrap.constructJSONHeader(consoleLogHeader, bootProps);
                System.out.println(jsonConsoleHeader);
            } else {
                System.out.println(consoleLogHeader);
            }
        }
        bootProps.put("websphere.product.info", versionString);
    }

    private static String constructJSONHeader(String consoleLogHeader, BootstrapConfig bootProps) {
        String serverName = bootProps.get("wlp.server.name");
        String wlpUserDir = System.getProperty("wlp.user.dir");
        String serverHostName = KernelBootstrap.getServerHostName();
        String datetime = KernelBootstrap.getDatetime();
        String sequenceNumber = KernelBootstrap.getSequenceNumber();
        StringBuilder sb = new StringBuilder();
        sb.append("{\"type\":\"liberty_message\"");
        sb.append(",\"host\":\"");
        sb = KernelBootstrap.jsonEscape(sb, serverHostName);
        sb.append("\",\"ibm_userDir\":\"");
        sb = KernelBootstrap.jsonEscape(sb, wlpUserDir);
        sb.append("\",\"ibm_serverName\":\"");
        sb = KernelBootstrap.jsonEscape(sb, serverName);
        sb.append("\",\"message\":\"");
        sb = KernelBootstrap.jsonEscape(sb, consoleLogHeader);
        sb.append("\",\"ibm_datetime\":\"");
        sb = KernelBootstrap.jsonEscape(sb, datetime);
        sb.append("\",\"ibm_sequence\":\"");
        sb = KernelBootstrap.jsonEscape(sb, sequenceNumber);
        sb.append("\"}");
        return sb.toString();
    }

    private static String getSequenceNumber() {
        SequenceNumber sequenceNumber = new SequenceNumber();
        long rawSequenceNumber = sequenceNumber.getRawSequenceNumber();
        String sequenceId = null;
        if (sequenceId == null || sequenceId.isEmpty()) {
            sequenceId = SequenceNumber.formatSequenceNumber(System.currentTimeMillis(), rawSequenceNumber);
        }
        return sequenceId;
    }

    private static String getDatetime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String datetime = dateFormat.format(System.currentTimeMillis());
        return datetime;
    }

    private static String getServerHostName() {
        String serverHostName = null;
        String containerHost = System.getenv("CONTAINER_HOST");
        if (containerHost == null || containerHost.equals("") || containerHost.length() == 0) {
            try {
                serverHostName = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws UnknownHostException {
                        return InetAddress.getLocalHost().getCanonicalHostName();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                serverHostName = "";
            }
        } else {
            serverHostName = containerHost;
        }
        return serverHostName;
    }

    private static StringBuilder jsonEscape(StringBuilder sb, String s) {
        if (s == null) {
            return sb.append(s);
        }
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append("\\");
                    sb.append(c);
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb;
    }

    protected static String getProductInfoDisplayName() {
        String result = null;
        try {
            Map<String, ProductInfo> products = ProductInfo.getAllProductInfo();
            StringBuilder builder = new StringBuilder();
            for (ProductInfo productInfo : products.values()) {
                ProductInfo replaced = productInfo.getReplacedBy();
                if (productInfo.getReplacedBy() != null && !replaced.isReplacedProductLogged()) continue;
                if (builder.length() != 0) {
                    builder.append(", ");
                }
                builder.append(productInfo.getDisplayName());
            }
            result = builder.toString();
        }
        catch (ProductInfoParseException productInfoParseException) {
        }
        catch (DuplicateProductInfoException duplicateProductInfoException) {
        }
        catch (ProductInfoReplaceException productInfoReplaceException) {
            // empty catch block
        }
        return result;
    }

    private void rethrowException(String untranslatedMsg, Throwable ex) {
        Throwable cause = ex.getCause();
        if (cause == null) {
            cause = ex;
        }
        throw new LaunchException(untranslatedMsg, MessageFormat.format(BootstrapConstants.messages.getString("error.unknownException"), cause.toString()), cause);
    }

    protected Instrumentation getInstrumentation() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        Instrumentation i = this.findInstrumentation(cl, "com.ibm.ws.kernel.instrument.BootstrapAgent");
        if (i == null) {
            i = this.findInstrumentation(cl, "wlp.lib.extract.agent.BootstrapAgent");
        }
        return i;
    }

    private Instrumentation findInstrumentation(ClassLoader cl, String clazz) {
        try {
            Class<?> agentClass = cl.loadClass(clazz);
            Method getInstrumentation = agentClass.getMethod("getInstrumentation", new Class[0]);
            return (Instrumentation)getInstrumentation.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void logSerialFilterMessage() {
        if (this.isSerialFilterLoaded()) {
            System.out.println(BootstrapConstants.messages.getString("info.serialFilterLoaded"));
        }
    }

    private boolean isSerialFilterLoaded() {
        String activeSerialFilter = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("com.ibm.websphere.serialfilter.active");
            }
        });
        return "true".equalsIgnoreCase(activeSerialFilter);
    }
}

