/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.staticvalue;

import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;

public abstract class StaticValue<T> {
    private static final boolean multiplex = StaticValue.class.getResource("/com.ibm.ws.staticvalue.multiplex") != null;

    @FFDCIgnore(value={Exception.class})
    public static <T> StaticValue<T> createStaticValue(Callable<T> initializer) {
        if (multiplex) {
            return new Multiplexed<T>(initializer);
        }
        try {
            return new FinalSingleton<Object>((initializer == null ? null : (Object)initializer.call()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> StaticValue<T> mutateStaticValue(StaticValue<T> staticValue, Callable<T> initializer) {
        if (multiplex) {
            if (staticValue == null) {
                staticValue = StaticValue.createStaticValue(null);
            }
            staticValue.initialize(StaticValue.getThreadGroup(), initializer);
            return staticValue;
        }
        return StaticValue.createStaticValue(initializer);
    }

    static ThreadGroup getThreadGroup() {
        ThreadGroup g;
        for (g = Thread.currentThread().getThreadGroup(); !(g == null || g.getName() != null && g.getName().startsWith("osgi-boot-")); g = g.getParent()) {
        }
        return g;
    }

    public abstract T get();

    T initialize(ThreadGroup g, Callable<T> initializer) {
        return null;
    }

    public String toString() {
        return "StaticValue[" + this.get() + "]";
    }

    static class FinalSingleton<T>
    extends StaticValue<T> {
        private final T singleton;

        FinalSingleton(T initial) {
            this.singleton = initial;
        }

        @Override
        public T get() {
            return this.singleton;
        }
    }

    static class Multiplexed<T>
    extends StaticValue<T> {
        private final Map<ThreadGroup, GroupHolder<T>> threadGroups = new WeakHashMap<ThreadGroup, GroupHolder<T>>();
        private final Callable<T> constructorInitializer;
        private GroupHolder<T> singleton;

        Multiplexed(Callable<T> initializer) {
            this.constructorInitializer = initializer;
        }

        @Override
        T initialize(ThreadGroup g, Callable<T> initializer) {
            if (g == null) {
                return this.getOrInitSingleton(initializer);
            }
            return this.getOrInitGroup(g, initializer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            GroupHolder<T> result;
            ThreadGroup g = Multiplexed.getThreadGroup();
            boolean initialize = false;
            Multiplexed multiplexed = this;
            synchronized (multiplexed) {
                GroupHolder<T> groupHolder = result = g == null ? this.singleton : this.threadGroups.get(g);
                if (result == null) {
                    if (this.constructorInitializer != null) {
                        initialize = true;
                    } else {
                        return null;
                    }
                }
            }
            return initialize ? this.initialize(g, this.constructorInitializer) : result.t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @FFDCIgnore(value={Exception.class})
        private T getOrInitSingleton(Callable<T> initializer) {
            try {
                Multiplexed multiplexed = this;
                synchronized (multiplexed) {
                    if (this.singleton != null && this.singleton.initializer == initializer) {
                        return this.singleton.t;
                    }
                }
                Object val = initializer == null ? null : (Object)initializer.call();
                Multiplexed multiplexed2 = this;
                synchronized (multiplexed2) {
                    if (this.singleton != null && this.singleton.initializer == initializer) {
                        return this.singleton.t;
                    }
                    this.singleton = new GroupHolder<Object>(val, (Callable<Object>)initializer);
                    return this.singleton.t;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @FFDCIgnore(value={Exception.class})
        private T getOrInitGroup(ThreadGroup g, Callable<T> initializer) {
            Multiplexed multiplexed = this;
            synchronized (multiplexed) {
                GroupHolder<T> result = this.threadGroups.get(g);
                if (result != null && result.initializer == initializer) {
                    return result.t;
                }
            }
            try {
                Object val = initializer == null ? null : (Object)initializer.call();
                Multiplexed multiplexed2 = this;
                synchronized (multiplexed2) {
                    GroupHolder<Object> result = this.threadGroups.get(g);
                    if (result != null && result.initializer == initializer) {
                        return result.t;
                    }
                    result = new GroupHolder<Object>(val, (Callable<Object>)initializer);
                    this.threadGroups.put(g, result);
                    this.singleton = result;
                    return result.t;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static class GroupHolder<T> {
            final T t;
            final Callable<T> initializer;

            GroupHolder(T t, Callable<T> initializer) {
                this.t = t;
                this.initializer = initializer;
            }
        }
    }
}

