/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.v21.cdi.internal;

import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.classloading.ClassLoaderIdentifierService;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jpa.container.v21.cdi.internal.BeanManagerInvocationHandler;
import com.ibm.ws.jpa.container.v21.cdi.internal.HibernateNotifier;
import com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager;
import com.ibm.ws.jpa.management.JPAEMFPropertyProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ClassLoadingService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component
public class CDIJPAEMFPropertyProviderImpl
implements JPAEMFPropertyProvider,
HibernateNotifier {
    private static final TraceComponent tc = Tr.register(CDIJPAEMFPropertyProviderImpl.class, null, null);
    private static final ClassLoader CLASSLOADER = BeanManager.class.getClassLoader();
    private static final String CDI_BEANMANAGER = "javax.persistence.bean.manager";
    private CDIService cdiService;
    private Map<String, IBMHibernateExtendedBeanManager> extendedBeanManagers = new HashMap<String, IBMHibernateExtendedBeanManager>();
    @Reference
    protected ClassLoadingService classLoadingService;
    @Reference
    protected ClassLoaderIdentifierService classLoaderIdentifierService;
    private static final String ENABLE_HIBERNATE_COMPATIBILITY = "com.ibm.websphere.jpa.hibernate-cdi-compatibility";
    private static final boolean hibernateEnabled = Boolean.parseBoolean((String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("com.ibm.websphere.jpa.hibernate-cdi-compatibility", "false")));
    static final long serialVersionUID = -5419706427143839508L;

    @FFDCIgnore(value={ClassNotFoundException.class})
    public void updateProperties(Map<String, Object> props, ClassLoader applicationClassLoader) {
        if (this.cdiService != null) {
            Class[] beanManagerInterfaces = null;
            BeanManagerInvocationHandler invocationHandler = null;
            ClassLoader classLoader = CLASSLOADER;
            if (hibernateEnabled) {
                try {
                    String baseClassLoaderId = this.getBaseClassLoaderId(applicationClassLoader);
                    ClassLoader unifiedClassLoader = this.unify(CLASSLOADER, applicationClassLoader);
                    Class<?> extendedBeanManagerInterface = Class.forName("org.hibernate.resource.beans.container.spi.ExtendedBeanManager", true, unifiedClassLoader);
                    Class<?> depreciatedExtendedBeanManagerInterface = Class.forName("org.hibernate.jpa.event.spi.jpa.ExtendedBeanManager", true, unifiedClassLoader);
                    IBMHibernateExtendedBeanManager extendedBeanManager = null;
                    if (this.extendedBeanManagers.containsKey(baseClassLoaderId)) {
                        extendedBeanManager = this.extendedBeanManagers.get(baseClassLoaderId);
                    } else {
                        extendedBeanManager = new IBMHibernateExtendedBeanManager(unifiedClassLoader, baseClassLoaderId);
                        this.extendedBeanManagers.put(baseClassLoaderId, extendedBeanManager);
                    }
                    invocationHandler = new BeanManagerInvocationHandler(this.cdiService, extendedBeanManager);
                    beanManagerInterfaces = new Class[]{extendedBeanManagerInterface, depreciatedExtendedBeanManagerInterface, BeanManager.class};
                    classLoader = unifiedClassLoader;
                }
                catch (ClassNotFoundException e) {
                    invocationHandler = new BeanManagerInvocationHandler(this.cdiService);
                    beanManagerInterfaces = new Class[]{BeanManager.class};
                }
            } else {
                invocationHandler = new BeanManagerInvocationHandler(this.cdiService);
                beanManagerInterfaces = new Class[]{BeanManager.class};
            }
            Object beanManager = Proxy.newProxyInstance(classLoader, beanManagerInterfaces, (InvocationHandler)invocationHandler);
            props.put(CDI_BEANMANAGER, beanManager);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"updateProperties setting {0}={1}", (Object[])new Object[]{CDI_BEANMANAGER, beanManager});
            }
        }
    }

    @Override
    public void notifyHibernateAfterBeanDiscovery(BeanManager beanManager, ClassLoader classLoader) {
        String baseClassLoaderId = this.getBaseClassLoaderId(classLoader);
        for (IBMHibernateExtendedBeanManager extendedBeanManager : this.extendedBeanManagers.values()) {
            extendedBeanManager.notifyHibernateAfterBeanDiscovery(baseClassLoaderId, beanManager);
        }
    }

    @Override
    public void notifyHibernateBeforeShutdown(BeanManager beanManager) {
        Iterator<Map.Entry<String, IBMHibernateExtendedBeanManager>> it = this.extendedBeanManagers.entrySet().iterator();
        while (it.hasNext()) {
            IBMHibernateExtendedBeanManager extendedBeanManager = it.next().getValue();
            if (!extendedBeanManager.notifyHibernateBeforeShutdown(beanManager)) continue;
            it.remove();
        }
    }

    private ClassLoader unify(final ClassLoader parent, final ClassLoader child) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = 3087645573907448459L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return CDIJPAEMFPropertyProviderImpl.this.classLoadingService.unify(parent, new ClassLoader[]{child});
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, null, null);
            }
        });
    }

    private String getBaseClassLoaderId(ClassLoader applicationClassLoader) {
        while (applicationClassLoader != null) {
            String parentId;
            String id = this.classLoaderIdentifierService.getClassLoaderIdentifier(applicationClassLoader);
            if (id.startsWith("EARApplication")) {
                return id;
            }
            ClassLoader parent = applicationClassLoader.getParent();
            String string = parentId = this.classLoaderIdentifierService.getClassLoaderIdentifier(parent) == null ? null : this.classLoaderIdentifierService.getClassLoaderIdentifier(parent);
            if (parent == null || parentId == null || parentId.equals("Shared Library:global")) {
                return id;
            }
            applicationClassLoader = parent;
        }
        return null;
    }

    @Reference
    protected void setCDIService(CDIService cdiService) {
        this.cdiService = cdiService;
    }

    protected void unsetCDIService(CDIService cdiService) {
        this.cdiService = null;
    }
}

