/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.v21.cdi.internal;

import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.container.v21.cdi.internal.HibernateNotifier;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={WebSphereCDIExtension.class})
public class JPAContainerCDIExtension
implements Extension,
WebSphereCDIExtension {
    @Reference
    protected HibernateNotifier notUsed;
    WeakReference<ClassLoader> classLoader = null;
    private static final String ENABLE_HIBERNATE_COMPATIBILITY = "com.ibm.websphere.jpa.hibernate-cdi-compatibility";
    private static final boolean hibernateEnabled;
    static final long serialVersionUID = 2521183771765836011L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager manager) {
        if (hibernateEnabled) {
            ClassLoader cl = this.extractClassLoaderFromEvent(event);
            if (cl == null) {
                throw new IllegalStateException("Unable to find a classloader which can map the correct hibernate ExtendedBeanManager");
            }
            this.classLoader = new WeakReference<ClassLoader>(cl);
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager manager) {
        if (hibernateEnabled) {
            HibernateNotifier hibernateNotifier = this.getPropertyProvideder();
            hibernateNotifier.notifyHibernateAfterBeanDiscovery(manager, (ClassLoader)this.classLoader.get());
            this.classLoader.clear();
        }
    }

    public void beforeShutdown(@Observes BeforeShutdown event, BeanManager manager) {
        if (hibernateEnabled) {
            HibernateNotifier hibernateNotifier = this.getPropertyProvideder();
            hibernateNotifier.notifyHibernateBeforeShutdown(manager);
        }
    }

    private ClassLoader extractClassLoaderFromEvent(final AfterBeanDiscovery event) {
        if (event != null && event.getClass().getName().equals("org.jboss.weld.bootstrap.events.AfterBeanDiscoveryImpl")) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                static final long serialVersionUID = -643010709927328777L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() {
                    try {
                        Method getDeployment = event.getClass().getSuperclass().getDeclaredMethod("getDeployment", new Class[0]);
                        getDeployment.setAccessible(true);
                        Object maybeDeployment = getDeployment.invoke((Object)event, new Object[0]);
                        if (maybeDeployment.getClass().getSimpleName().contains("WebSphereCDIDeployment")) {
                            Method getClassLoader = maybeDeployment.getClass().getDeclaredMethod("getClassLoader", new Class[0]);
                            getClassLoader.setAccessible(true);
                            Object maybeClassLoader = getClassLoader.invoke(maybeDeployment, new Object[0]);
                            if (maybeClassLoader instanceof ClassLoader) {
                                return (ClassLoader)maybeClassLoader;
                            }
                            return null;
                        }
                        return null;
                    }
                    catch (Throwable getDeployment) {
                        FFDCFilter.processException((Throwable)getDeployment, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.JPAContainerCDIExtension$1", (String)"99", (Object)this, (Object[])new Object[0]);
                        return null;
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, null, null);
                }
            });
        }
        return null;
    }

    private HibernateNotifier getPropertyProvideder() {
        final Bundle bundle = FrameworkUtil.getBundle(HibernateNotifier.class);
        HibernateNotifier hibernateNotifier = AccessController.doPrivileged(new PrivilegedAction<HibernateNotifier>(){
            static final long serialVersionUID = 2450991009076932552L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public HibernateNotifier run() {
                BundleContext bCtx = bundle.getBundleContext();
                ServiceReference svcRef = bCtx.getServiceReference(HibernateNotifier.class);
                return svcRef == null ? null : (HibernateNotifier)bCtx.getService(svcRef);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, null, null);
            }
        });
        if (hibernateNotifier == null) {
            throw new IllegalStateException("Failed to get the HibernateNotifier.");
        }
        return hibernateNotifier;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JPAContainerCDIExtension.class, null, null);
        hibernateEnabled = Boolean.parseBoolean((String)AccessController.doPrivileged(new SystemGetPropertyPrivileged(ENABLE_HIBERNATE_COMPATIBILITY, "false")));
    }
}

