/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs21.sse;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseEventSink;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.sse.NoSuitableMessageBodyWriterException;
import org.apache.cxf.message.Message;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertySseEventSinkImpl
implements SseEventSink {
    private static final TraceComponent tc = Tr.register(LibertySseEventSinkImpl.class, null, null);
    private final MessageBodyWriter<OutboundSseEvent> writer;
    private final Message message;
    private final HttpServletResponse response;
    private volatile boolean closed;
    static final long serialVersionUID = -3718893555005535457L;

    public LibertySseEventSinkImpl(MessageBodyWriter<OutboundSseEvent> writer, Message message) {
        this.writer = writer;
        this.message = message;
        this.response = (HttpServletResponse)message.get(HttpServletResponse.class);
        message.getExchange().put((Object)"ignore.message.writers", (Object)"true");
    }

    /*
     * WARNING - void declaration
     */
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.response.getOutputStream().close();
                HttpServletRequest req = (HttpServletRequest)this.message.get((Object)"HTTP.REQUEST");
                if (req != null) {
                    req.getAsyncContext().complete();
                }
            }
            catch (Exception req) {
                FFDCFilter.processException((Throwable)req, (String)"com.ibm.ws.jaxrs21.sse.LibertySseEventSinkImpl", (String)"73", (Object)this, (Object[])new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void ex;
                    Tr.debug((TraceComponent)tc, (String)"Failed to close response stream", (Object[])new Object[]{ex});
                }
            }
            finally {
                ServerProviderFactory.releaseRequestState((Message)this.message);
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={WebApplicationException.class, IOException.class, NoSuitableMessageBodyWriterException.class})
    public CompletionStage<?> send(OutboundSseEvent event) {
        CompletableFuture<?> future = this.createCompleteableFuture();
        if (!this.closed) {
            if (this.writer != null) {
                ByteArrayOutputStream os = null;
                try {
                    os = new ByteArrayOutputStream();
                    this.writer.writeTo((Object)event, event.getClass(), null, new Annotation[0], event.getMediaType(), null, (OutputStream)os);
                    String eventContents = os.toString();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("send - sending " + eventContents), (Object[])new Object[0]);
                    }
                    if (!this.response.isCommitted()) {
                        this.response.setHeader("Content-Type", "text/event-stream");
                        this.response.flushBuffer();
                    }
                    if (event.getName() == null) {
                        this.response.getOutputStream().print("    UnnamedEvent\n");
                    }
                    this.response.getOutputStream().println(eventContents);
                    this.response.getOutputStream().flush();
                    CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(eventContents);
                    return completableFuture;
                }
                catch (NoSuitableMessageBodyWriterException ex) {
                    this.handleException(ex, future, event);
                    throw new IllegalArgumentException("No suitable message body writer for OutboundSseEvent created with data " + event.getData() + " and mediaType " + event.getMediaType() + ". The data contained within the OutboundSseEvent must match the mediaType.");
                }
                catch (WebApplicationException ex) {
                    this.handleException(ex, future, event);
                }
                catch (IOException ex) {
                    this.handleException(ex, future, event);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No MessageBodyWriter - returning null for event:  " + event), (Object[])new Object[0]);
                }
                future.complete(null);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SseEventSink is closed - failed sending event:  " + event), (Object[])new Object[0]);
            }
            throw new IllegalStateException("SseEventSink is closed.");
        }
        return future;
    }

    private void handleException(Throwable t, CompletableFuture future, OutboundSseEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("send - failed sending event " + event), (Object[])new Object[0]);
        }
        future.completeExceptionally(t);
        this.close();
    }

    private CompletableFuture<?> createCompleteableFuture() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return new CompletableFuture();
        }
        return AccessController.doPrivileged(() -> new CompletableFuture());
    }
}

