/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.s4u2proxy;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.kerberos.Krb5HelperJdk;
import com.ibm.ws.security.kerberos.internal.BoundedHashMap;
import com.ibm.ws.security.krb5.Krb5Common;
import com.ibm.ws.security.s4u2proxy.KerberosExtService;
import com.ibm.ws.security.token.krb5.Krb5Helper;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={SpnegoHelper.class}, name="SpnegoHelper", configurationPid={"com.ibm.websphere.security.s4u2proxy.SpnegoHelper"}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class SpnegoHelper {
    private static final TraceComponent tc = Tr.register(SpnegoHelper.class, (String)"security", (String)"com.ibm.ws.security.internal.resources.LoggingMessages");
    private static Map<String, Object> delegateSubjectCache = null;
    private static final int MAX_CACHE = 10;
    static final String KEY_KERBEROS_EXT_SERVICE = "KerberosExtService";
    static final String KEY_KRB5_HELPER_JDK = "Krb5HelperJdk";
    private static Krb5HelperJdk krb5HelperJdk = null;
    static boolean supportJDK = false;
    protected static final AtomicServiceReference<KerberosExtService> kerberosExtServiceRef = new AtomicServiceReference("KerberosExtService");
    static final long serialVersionUID = -1401653034278874401L;

    public static String buildS4U2ProxyAuthorizationUsingS4U2Self(String upn, String targetServiceSpn, int lifetime, boolean delegate, String delegateServiceSpn, String jaasLoginContextEntry, String krb5Keytab) throws GSSException, PrivilegedActionException, LoginException {
        Krb5Helper.checkUpn(upn);
        Krb5Helper.checkSpn(targetServiceSpn);
        KerberosExtService kerberosExtService = SpnegoHelper.getKerberosExtService();
        if (!kerberosExtService.isS4U2selfEnable()) {
            String methodName = "buildS4U2proxyAuthorization()";
            String msg = TraceNLS.getFormattedMessage(SpnegoHelper.class, (String)"com.ibm.ws.security.internal.resources.LoggingMessages", (String)"KRB_S4U2SELF_IS_NOT_ENABLED", (Object[])new Object[]{methodName}, (String)"CWWKS4342E: Can not process method {0} because the constrained delegation S4U2self is not enabled.");
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new GSSException(16, 16, msg);
        }
        Subject delegateServiceSubject = SpnegoHelper.getDelegateServiceSubject(delegateServiceSpn, jaasLoginContextEntry, krb5Keytab);
        GSSCredential upnGSSCredS4U2self = kerberosExtService.getDelegateGSSCredUsingS4U2self(upn, targetServiceSpn, GSSName.NT_USER_NAME, 1, delegateServiceSpn, delegateServiceSubject);
        return Krb5Helper.buildSpnegoAuthorization(upnGSSCredS4U2self, targetServiceSpn, lifetime, delegate);
    }

    public static String buildS4U2proxyAuthorization(String spn, Subject subject, int lifetime, boolean delegate) throws GSSException, PrivilegedActionException {
        Krb5Helper.checkSpn(spn);
        KerberosExtService kerberosExtService = SpnegoHelper.getKerberosExtService();
        if (!kerberosExtService.isS4U2proxyEnable()) {
            String methodName = "buildS4U2proxyAuthorization()";
            String msg = TraceNLS.getFormattedMessage(SpnegoHelper.class, (String)"com.ibm.ws.security.internal.resources.LoggingMessages", (String)"KRB_S4U2PROXY_IS_NOT_ENABLED", (Object[])new Object[]{methodName}, (String)"CWWKS4343E: Can not process method {0} because the constrained delegation S4U2proxy is not enabled.");
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new GSSException(16, 16, msg);
        }
        return Krb5Helper.buildSpnegoAuthorizationFromSubjectCommon(spn, subject, lifetime, delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Subject getDelegateServiceSubject(String delegateSpn, String jaasLoginContextEntry, String krb5Keytab) throws LoginException {
        Subject delegateServiceSubject = (Subject)delegateSubjectCache.get(delegateSpn);
        if (delegateServiceSubject != null) {
            boolean valid = SubjectHelper.isTGTInSubjectValid((Subject)delegateServiceSubject, (String)delegateSpn);
            if (valid) {
                return delegateServiceSubject;
            }
            delegateSubjectCache.remove(delegateSpn);
        }
        String savedSubjectCredProp = Krb5Common.setPropertyAsNeeded((String)"javax.security.auth.useSubjectCredsOnly", (String)"false");
        String savedKeytabProp = Krb5Common.setPropertyAsNeeded((String)"KRB5_KTNAME", (String)krb5Keytab);
        String savedPrincProp = Krb5Common.setPropertyAsNeeded((String)Krb5Common.KRB5_PRINCIPAL, (String)delegateSpn);
        try {
            if (krb5HelperJdk != null) {
                delegateServiceSubject = krb5HelperJdk.doKerberosLogin(jaasLoginContextEntry, delegateSpn, krb5Keytab);
            }
        }
        finally {
            Krb5Common.restorePropertyAsNeeded((String)"javax.security.auth.useSubjectCredsOnly", (String)savedSubjectCredProp, (String)"false");
            Krb5Common.restorePropertyAsNeeded((String)"KRB5_KTNAME", (String)savedKeytabProp, (String)krb5Keytab);
            Krb5Common.restorePropertyAsNeeded((String)Krb5Common.KRB5_PRINCIPAL, (String)savedPrincProp, (String)delegateSpn);
        }
        if (delegateServiceSubject != null) {
            delegateSubjectCache.put(delegateSpn, delegateServiceSubject);
        }
        return delegateServiceSubject;
    }

    public static void setSystemProperty(final String propName, final String propValue) {
        AccessController.doPrivileged(new PrivilegedAction(){
            static final long serialVersionUID = 1929407707238940645L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Object run() {
                return System.setProperty(propName, propValue);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, null, null);
            }
        });
    }

    private static KerberosExtService getKerberosExtService() throws GSSException {
        KerberosExtService kerberosExtService;
        if (delegateSubjectCache == null) {
            delegateSubjectCache = new BoundedHashMap(10);
        }
        if ((kerberosExtService = (KerberosExtService)kerberosExtServiceRef.getService()) == null) {
            Krb5Helper.serviceNotAvailableException();
        }
        Krb5Helper.unsuportJdkErrorMsg(supportJDK);
        return kerberosExtService;
    }

    @Reference(service=Krb5HelperJdk.class, name="Krb5HelperJdk", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setKrb5HelperJdk(Krb5HelperJdk krb5HelperJdk) {
        SpnegoHelper.krb5HelperJdk = krb5HelperJdk;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The Krb5HelperJdk service with class name " + SpnegoHelper.krb5HelperJdk.getClass().getSimpleName() + " has been activated"), (Object[])new Object[0]);
        }
    }

    protected void unsetKrb5HelperJdk(Krb5HelperJdk krb5HelperJdk) {
        if (SpnegoHelper.krb5HelperJdk == krb5HelperJdk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The Krb5HelperJdk service with class name " + SpnegoHelper.krb5HelperJdk.getClass().getSimpleName() + " has been deactivated"), (Object[])new Object[0]);
            }
            SpnegoHelper.krb5HelperJdk = null;
        }
    }

    @Reference(service=KerberosExtService.class, name="KerberosExtService", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC)
    protected void setKerberosExtService(ServiceReference<KerberosExtService> ref) {
        kerberosExtServiceRef.setReference(ref);
    }

    protected void unsetKerberosExtService(ServiceReference<KerberosExtService> ref) {
        kerberosExtServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        supportJDK = Krb5Common.isJdk18OrUp;
        if (supportJDK) {
            kerberosExtServiceRef.activate(cc);
        }
    }

    @Modified
    protected void modified(Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        kerberosExtServiceRef.deactivate(cc);
        supportJDK = false;
    }
}

