/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.kerberos;

import com.ibm.security.auth.module.Krb5LoginModule;
import com.ibm.security.jgss.ExtendedGSSContext;
import com.ibm.security.jgss.ExtendedGSSCredential;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.kerberos.Krb5HelperJdk;
import com.ibm.ws.security.krb5.Krb5Common;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={Krb5HelperJdk.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "name=Krb5HelperJdk8"})
public class Krb5HelperJdk8
implements Krb5HelperJdk {
    private static final TraceComponent tc = Tr.register(Krb5HelperJdk8.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.internal.resources.KerberosMessages");
    static final long serialVersionUID = -5714036042776689340L;

    @Reference(policy=ReferencePolicy.STATIC, target="(&(java.specification.version>=1.8)(java.vendor=ibm corporation))")
    protected void setProcess(LibertyProcess process) {
    }

    @Override
    public GSSCredential getDelegateGSSCredUsingS4U2self(final String upn, String targetServiceSpn, final Oid gssNameType, final int gssCredUsage, final String delegateServiceSpn, Subject delegateServiceSubject) throws GSSException {
        final GSSManager gssManager = GSSManager.getInstance();
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){
            static final long serialVersionUID = 2491311124454158059L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public Object run() {
                GSSCredential impersonateGssCred = null;
                try {
                    GSSCredential self = gssManager.createCredential(gssCredUsage);
                    GSSName gssName = gssManager.createName(upn, gssNameType);
                    impersonateGssCred = ((ExtendedGSSCredential)self).impersonate(gssName);
                }
                catch (GSSException self) {
                    void e;
                    FFDCFilter.processException((Throwable)self, (String)"com.ibm.ws.security.kerberos.Krb5HelperJdk8$1", (String)"80", (Object)this, (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"KRB_IMPERSONATE_USER_TO_GET_GSSCRED_FOR_SELF_FAILURE", (Object[])new Object[]{upn, delegateServiceSpn, e.getMessage()});
                }
                return impersonateGssCred;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.internal.resources.KerberosMessages");
            }
        };
        GSSCredential gssCred = (GSSCredential)WSSubject.doAs((Subject)delegateServiceSubject, (PrivilegedAction)action);
        if (gssCred == null) {
            throw new GSSException(11, 12, "GSSCredential is null");
        }
        return gssCred;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GSSCredential getDelegateGSSCredUsingS4U2proxy(String userPrincipalName, GSSContext delegateGSSContext, String delegateServiceSpn) throws GSSException {
        GSSCredential gssCred = null;
        try {
            ExtendedGSSContext extGssContext = (ExtendedGSSContext)delegateGSSContext;
            gssCred = extGssContext.getDelegCred();
        }
        catch (GSSException extGssContext) {
            void e;
            FFDCFilter.processException((Throwable)extGssContext, (String)"com.ibm.ws.security.kerberos.Krb5HelperJdk8", (String)"103", (Object)this, (Object[])new Object[]{userPrincipalName, delegateGSSContext, delegateServiceSpn});
            Tr.error((TraceComponent)tc, (String)"KRB_IMPERSONATE_USER_TO_GET_GSSCRED_FOR_BACKEND_SERVICE_FAILURE", (Object[])new Object[]{userPrincipalName, delegateServiceSpn, e.getMessage()});
        }
        if (gssCred == null) {
            throw new GSSException(11, 13, "GSSCredential is null");
        }
        return gssCred;
    }

    @Override
    public Subject doKerberosLogin(String jaasLoginContextEntry, String delegateSpn, String krb5Keytab) throws LoginException {
        Subject subject = new Subject();
        Krb5LoginModule krb5 = new Krb5LoginModule();
        HashMap<String, String> options = new HashMap<String, String>();
        HashMap sharedState = new HashMap();
        options.put("credsType", "both");
        options.put("useDefaultCcache", "false");
        options.put("forwardable", "true");
        options.put("principal", delegateSpn);
        options.put("useKeytab", krb5Keytab);
        if (tc.isDebugEnabled()) {
            options.put("debug", "true");
        }
        krb5.initialize(subject, null, sharedState, options);
        Krb5Common.debugKrb5LoginModule((Subject)subject, null, sharedState, options);
        krb5.login();
        krb5.commit();
        return subject;
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
    }

    @Modified
    protected void modified(Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
    }
}

