/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditAuthenticationResult;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.utils.AuditUtils;
import com.ibm.ws.webcontainer.security.WebRequest;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JACCEJBAuthorizationEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(JACCEJBAuthorizationEvent.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = 8032397536453921876L;

    public JACCEJBAuthorizationEvent() {
        this.set("eventName", "SECURITY_AUTHZ");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public JACCEJBAuthorizationEvent(AuditAuthenticationResult authResult, HashMap request, Object hreq, Object hwebReq, String realm, Subject subject, Integer statusCode) {
        block21: {
            this();
            try {
                String agent;
                HttpServletRequest req = (HttpServletRequest)hreq;
                WebRequest webreq = (WebRequest)hwebReq;
                if (req != null && req.getRemoteAddr() != null) {
                    this.set("initiator.host.address", req.getRemoteAddr());
                }
                if ((agent = req.getHeader("User-Agent")) != null) {
                    this.set("initiator.host.agent", agent);
                }
                this.set("target.name", URLDecoder.decode(req.getRequestURI(), "UTF-8"));
                this.set("target.appname", AuditUtils.getJ2EEComponentName());
                if (req.getQueryString() != null) {
                    String str = URLDecoder.decode(req.getQueryString(), "UTF-8");
                    str = AuditUtils.hidePassword(str);
                    this.set("target.params", str);
                }
                this.set("target.host.address", req.getLocalAddr() + ":" + req.getLocalPort());
                if (req.getUserPrincipal() != null && req.getUserPrincipal().getName() != null) {
                    this.set("target.credential.token", req.getUserPrincipal().getName());
                } else {
                    this.set("target.credential.token", subject.getPrincipals().iterator().next().getName());
                }
                this.set("target.credential.type", authResult.getAuditCredType());
                this.set("target.method", AuditUtils.getRequestMethod(req));
                String sessionID = AuditUtils.getSessionID(req);
                if (sessionID != null) {
                    this.set("target.session", sessionID);
                }
                if (webreq.getRequiredRoles() != null) {
                    ArrayList<String> rolesList = new ArrayList<String>();
                    for (String role : webreq.getRequiredRoles()) {
                        rolesList.add(role);
                    }
                    if (!rolesList.isEmpty()) {
                        this.set("target.role.names", rolesList.toString());
                    }
                }
                if (req.getMethod() != null) {
                    this.set("target.jacc.permissions", req.getMethod());
                }
                this.set("target.jacc.container", "ejb");
                if (request.get("applicationName") != null) {
                    this.set("target.appname", request.get("applicationName"));
                }
                if (request.get("moduleName") != null) {
                    this.set("target.ejb.module.name", request.get("moduleName"));
                }
                if (request.get("methodName") != null) {
                    this.set("target.method", request.get("methodName"));
                }
                if (request.get("methodInterface") != null) {
                    this.set("target.ejb.method.interface", request.get("methodInterface"));
                }
                if (request.get("methodSignature") != null) {
                    this.set("target.ejb.method.signature", request.get("methodSignature"));
                }
                if (request.get("beanName") != null) {
                    this.set("target.ejb.beanname", request.get("beanName"));
                }
                if (request.get("methodParameters") != null) {
                    this.set("target.ejb.method.parameters", request.get("methodParameters").toString());
                }
                this.set("reason.reasonType", "EJB");
                this.set("target.realm", AuditUtils.getRealmName());
                if (statusCode == 200) {
                    this.setOutcome("success");
                    this.set("reason.reasonCode", statusCode);
                } else {
                    this.setOutcome("failure");
                    this.set("reason.reasonCode", statusCode);
                }
            }
            catch (Exception req) {
                void e;
                FFDCFilter.processException((Throwable)req, (String)"com.ibm.ws.security.audit.event.JACCEJBAuthorizationEvent", (String)"142", (Object)((Object)this), (Object[])new Object[]{authResult, request, hreq, hwebReq, realm, subject, statusCode});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block21;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating JACCEJBAuthorizationEvent", (Object[])new Object[]{e});
            }
        }
    }
}

