/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.event.ParameterUtils;
import com.ibm.ws.security.audit.utils.AuditUtils;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.QueryExp;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JMXMBeanEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(JMXMBeanEvent.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = 7470872793239079617L;

    public JMXMBeanEvent() {
        this.set("eventName", "JMX_MBEAN");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public JMXMBeanEvent(ObjectName name, String className, ObjectName loader, String operationName, Object[] params, String[] signature, QueryExp query, String action, String outcome, String reason) {
        block16: {
            this();
            try {
                StringBuffer buf;
                if (name != null) {
                    this.set("target.jmx.mbean.name", name.toString());
                }
                if (className != null) {
                    this.set("target.jmx.mbean.classname", className);
                }
                if (action != null) {
                    this.set("target.jmx.mbean.action", action);
                }
                if (loader != null) {
                    this.set("target.jmx.mbean.classloader.name", loader.toString());
                }
                if (operationName != null) {
                    this.set("target.jmx.mbean.invoke.operation", operationName);
                }
                this.set("target.realm", AuditUtils.getRealmName());
                if (params != null) {
                    buf = new StringBuffer();
                    for (Object element : params) {
                        if (element == null) continue;
                        buf.append("[").append(ParameterUtils.format(element)).append("]");
                    }
                    String siggy = buf.toString();
                    if (!siggy.isEmpty()) {
                        this.set("target.jmx.mbean.params", siggy);
                    }
                }
                if (signature != null) {
                    buf = new StringBuffer();
                    for (int i = 0; i < signature.length; ++i) {
                        buf.append("[").append(signature[i]).append("]");
                    }
                    String siggy = buf.toString();
                    if (!siggy.isEmpty()) {
                        this.set("target.jmx.mbean.signature", siggy);
                    }
                }
                if (query != null) {
                    this.set("target.jmx.mbean.queryExp", query.toString());
                }
                this.set("observer.name", "JMXService");
                this.set("target.typeURI", "server/mbean");
                if (outcome.equals("success")) {
                    this.setOutcome("success");
                    this.set("reason.reasonCode", 200);
                    this.set("reason.reasonType", reason);
                } else {
                    this.setOutcome("failure");
                    this.set("reason.reasonCode", 201);
                    this.set("reason.reasonType", reason);
                }
            }
            catch (Exception buf) {
                void e;
                FFDCFilter.processException((Throwable)buf, (String)"com.ibm.ws.security.audit.event.JMXMBeanEvent", (String)"115", (Object)((Object)this), (Object[])new Object[]{name, className, loader, operationName, params, signature, query, action, outcome, reason});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating JMXMBeanEvent", (Object[])new Object[]{e});
            }
        }
    }
}

