/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.el.VariableMapper;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.lang.ExpressionBuilder;
import org.apache.el.parser.AstLiteralExpression;
import org.apache.el.parser.Node;
import org.apache.el.util.ReflectionUtil;

public final class ValueExpressionImpl
extends ValueExpression
implements Externalizable {
    private Class<?> expectedType;
    private String expr;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private transient Node node;
    private static boolean reuseEC;
    private static final boolean IS_SECURITY_ENABLED;
    private static ThreadLocal<EvaluationContext> tlCtx;

    public ValueExpressionImpl() {
    }

    public ValueExpressionImpl(String expr, Node node, FunctionMapper fnMapper, VariableMapper varMapper, Class<?> expectedType) {
        this.expr = expr;
        this.node = node;
        this.fnMapper = fnMapper;
        this.varMapper = varMapper;
        this.expectedType = expectedType;
    }

    public boolean equals(Object obj) {
        return obj instanceof ValueExpressionImpl && obj.hashCode() == this.hashCode();
    }

    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    public String getExpressionString() {
        return this.expr;
    }

    private Node getNode() throws ELException {
        if (this.node == null) {
            this.node = ExpressionBuilder.createNode(this.expr);
        }
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getType(ELContext context) throws PropertyNotFoundException, ELException {
        EvaluationContext ctx = null;
        ELContext tempELC = null;
        FunctionMapper tempFM = null;
        VariableMapper tempVM = null;
        if (reuseEC) {
            ctx = tlCtx.get();
            if (ctx == null) {
                ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
                tlCtx.set(ctx);
            } else {
                tempELC = ctx.getELContext();
                tempFM = ctx.getFunctionMapper();
                tempVM = ctx.getVariableMapper();
                ctx.setELContext(context);
                ctx.setFunctionMapper(this.fnMapper);
                ctx.setVariableMapper(this.varMapper);
            }
        } else {
            ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        }
        try {
            Class<?> clazz = this.getNode().getType(ctx);
            return clazz;
        }
        finally {
            if (reuseEC) {
                ctx.setELContext(tempELC);
                ctx.setFunctionMapper(tempFM);
                ctx.setVariableMapper(tempVM);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(ELContext context) throws PropertyNotFoundException, ELException {
        EvaluationContext ctx = null;
        ELContext tempELC = null;
        FunctionMapper tempFM = null;
        VariableMapper tempVM = null;
        if (reuseEC) {
            ctx = tlCtx.get();
            if (ctx == null) {
                ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
                tlCtx.set(ctx);
            } else {
                tempELC = ctx.getELContext();
                tempFM = ctx.getFunctionMapper();
                tempVM = ctx.getVariableMapper();
                ctx.setELContext(context);
                ctx.setFunctionMapper(this.fnMapper);
                ctx.setVariableMapper(this.varMapper);
            }
        } else {
            ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        }
        try {
            Object value = this.getNode().getValue(ctx);
            if (this.expectedType != null) {
                Object object = ELSupport.coerceToType(value, this.expectedType);
                return object;
            }
            Object object = value;
            return object;
        }
        finally {
            if (reuseEC) {
                ctx.setELContext(tempELC);
                ctx.setFunctionMapper(tempFM);
                ctx.setVariableMapper(tempVM);
            }
        }
    }

    public int hashCode() {
        return this.getNode().hashCode();
    }

    public boolean isLiteralText() {
        try {
            return this.getNode() instanceof AstLiteralExpression;
        }
        catch (ELException ele) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnly(ELContext context) throws PropertyNotFoundException, ELException {
        EvaluationContext ctx = null;
        ELContext tempELC = null;
        FunctionMapper tempFM = null;
        VariableMapper tempVM = null;
        if (reuseEC) {
            ctx = tlCtx.get();
            if (ctx == null) {
                ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
                tlCtx.set(ctx);
            } else {
                tempELC = ctx.getELContext();
                tempFM = ctx.getFunctionMapper();
                tempVM = ctx.getVariableMapper();
                ctx.setELContext(context);
                ctx.setFunctionMapper(this.fnMapper);
                ctx.setVariableMapper(this.varMapper);
            }
        } else {
            ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        }
        try {
            boolean bl = this.getNode().isReadOnly(ctx);
            return bl;
        }
        finally {
            if (reuseEC) {
                ctx.setELContext(tempELC);
                ctx.setFunctionMapper(tempFM);
                ctx.setVariableMapper(tempVM);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expr = in.readUTF();
        String type = in.readUTF();
        if (!"".equals(type)) {
            this.expectedType = ReflectionUtil.forName(type);
        }
        this.fnMapper = (FunctionMapper)in.readObject();
        this.varMapper = (VariableMapper)in.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(ELContext context, Object value) throws PropertyNotFoundException, PropertyNotWritableException, ELException {
        EvaluationContext ctx = null;
        ELContext tempELC = null;
        FunctionMapper tempFM = null;
        VariableMapper tempVM = null;
        if (reuseEC) {
            ctx = tlCtx.get();
            if (ctx == null) {
                ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
                tlCtx.set(ctx);
            } else {
                tempELC = ctx.getELContext();
                tempFM = ctx.getFunctionMapper();
                tempVM = ctx.getVariableMapper();
                ctx.setELContext(context);
                ctx.setFunctionMapper(this.fnMapper);
                ctx.setVariableMapper(this.varMapper);
            }
        } else {
            ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        }
        try {
            this.getNode().setValue(ctx, value);
        }
        finally {
            if (reuseEC) {
                ctx.setELContext(tempELC);
                ctx.setFunctionMapper(tempFM);
                ctx.setVariableMapper(tempVM);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.expr);
        out.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        out.writeObject(this.fnMapper);
        out.writeObject(this.varMapper);
    }

    public String toString() {
        return "ValueExpression[" + this.expr + "]";
    }

    public ValueReference getValueReference(ELContext context) {
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        return this.getNode().getValueReference(ctx);
    }

    static {
        IS_SECURITY_ENABLED = System.getSecurityManager() != null;
        reuseEC = IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.valueOf(System.getProperty("com.ibm.ws.el.reuseEvaluationContext"));
            }
        }).booleanValue() : Boolean.valueOf(System.getProperty("com.ibm.ws.el.reuseEvaluationContext")).booleanValue();
        tlCtx = new ThreadLocal();
    }
}

