/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsFactoryFactory;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.JmsConnInternals;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.JmsTemporaryDestinationInternal;
import com.ibm.ws.sib.api.jms.impl.ConnectionListenerImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsFactoryFactoryImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.api.jms.ute.UTEHelperFactory;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnection;
import com.ibm.ws.sib.api.jmsra.JmsJcaSession;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class JmsConnectionImpl
implements Connection,
JmsConnInternals,
ApiJmsConstants,
JmsInternalConstants {
    private static TraceComponent tc = SibTr.register(JmsConnectionImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static final int SESSION_WARNING_THRESHOLD = 100;
    private final JmsJcaConnection jcaConnection;
    private SICoreConnection coreConnection;
    private boolean clientIDFixed;
    private final boolean isManaged;
    private Map passThruProps = null;
    private final List sessions;
    private final List temporaryDestinations;
    private final List<OrderingContext> unusedOrderingContexts = new ArrayList<OrderingContext>(1);
    private int state = 1;
    private final Object stateLock = new Object();
    private final AtomicReference<ExceptionListener> elRef = new AtomicReference<Object>(null);
    private ConnectionListenerImpl connListener = null;
    private static Boolean isCloned = null;
    private static ThreadPool exceptionThreadPool = null;
    private static Object exceptionTPCreateSync = new Object();
    private final JmsAsyncExceptionTask asyncExceptionTask = new JmsAsyncExceptionTask();

    JmsConnectionImpl(JmsJcaConnection jcaConnection, boolean isManaged, Map _passThruProps) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsConnectionImpl", (Object)new Object[]{jcaConnection, isManaged, _passThruProps});
        }
        this.passThruProps = _passThruProps;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("clientId : " + this.passThruProps.get("clientID  nonPersistentMapping : " + this.passThruProps.get("nonPersistentMapping"))));
        }
        this.jcaConnection = jcaConnection;
        String tempClientID = (String)this.passThruProps.get("clientID");
        if (tempClientID != null && !"".equals(tempClientID) && !this.isDefaultClientId(tempClientID)) {
            this.fixClientID();
            this.addClientId(tempClientID);
        }
        this.isManaged = isManaged;
        this.sessions = new ArrayList();
        this.temporaryDestinations = new ArrayList();
        this.setState(1);
        try {
            this.coreConnection = jcaConnection.getSICoreConnection();
            String durableSubsHome = (String)this.passThruProps.get("durableSubscriptionHome");
            if (null == durableSubsHome) {
                durableSubsHome = "defaultME";
            }
            if (durableSubsHome.equals("defaultME")) {
                this.passThruProps.put("durableSubscriptionHome", this.coreConnection.getMeName());
            }
            if (this.coreConnection == null) {
                JMSException e = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "JCA_RESOURCE_EXC_CWSIA0005", null, tc);
                FFDCFilter.processException((Throwable)e, (String)"JmsConnectionImpl", (String)"<init>#1", (Object)this, (Object[])new Object[]{jcaConnection, isManaged, _passThruProps});
                throw e;
            }
        }
        catch (IllegalStateException ise) {
            throw (javax.jms.IllegalStateException)JmsErrorUtils.newThrowable(javax.jms.IllegalStateException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{ise, "JmsConnectionImpl.getSICoreConnection"}, ise, "JmsConnectionImpl#2", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"JmsConnectionImpl(JmsJcaConnection, boolean, Map)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSession", (Object)new Object[]{transacted, acknowledgeMode});
        }
        JmsSessionImpl jmsSession = null;
        this.checkClosed();
        this.fixClientID();
        if (transacted) {
            acknowledgeMode = 0;
        }
        if (!transacted && this.isManaged) {
            if (acknowledgeMode == 2) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_ACKNOWLEDGE_MODE_CWSIA0514", new Object[]{acknowledgeMode}, tc);
            }
            acknowledgeMode = acknowledgeMode == 3 ? 3 : 1;
        }
        boolean internallyTransacted = transacted || acknowledgeMode == 2 || acknowledgeMode == 3;
        JmsJcaSession jcaSession = this.createJcaSession(internallyTransacted);
        Object object = this;
        synchronized (object) {
            try {
                this.coreConnection = jcaSession.getSICoreConnection();
            }
            catch (IllegalStateException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.api.jms.impl.JmsConnectionImpl", (String)"createSession#2", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSession", (Object)jmsSession);
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "JCA_CREATE_SESS_CWSIA0024", null, e, "JmsConnectionImpl.createSession#2", this, tc);
            }
            jmsSession = this.instantiateSession(transacted, acknowledgeMode, this.coreConnection, jcaSession);
        }
        object = this.stateLock;
        synchronized (object) {
            this.sessions.add(jmsSession);
            if (this.sessions.size() % 100 == 0) {
                String errorLocation = JmsErrorUtils.getFirstApplicationStackString();
                SibTr.warning((TraceComponent)tc, (String)"MANY_SESSIONS_WARNING_CWSIA0027", (Object)new Object[]{"" + this.sessions.size(), errorLocation});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSession", (Object)jmsSession);
        }
        return jmsSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientID() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getClientID");
        }
        this.checkClosed();
        String cl = null;
        Object object = this.stateLock;
        synchronized (object) {
            cl = (String)this.passThruProps.get("clientID");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getClientID", (Object)cl);
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientID(String clID) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setClientID", (Object)clID);
        }
        this.checkClosed();
        if (this.isManaged) {
            throw (javax.jms.IllegalStateException)JmsErrorUtils.newThrowable(javax.jms.IllegalStateException.class, "MGD_ENV_CWSIA0025", new Object[]{"setClientID"}, tc);
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (clID == null || "".equals(clID)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Ignoring null or empty clientID - does not affect fixed state.");
                }
            } else if (!this.clientIDFixed) {
                if (this.isDefaultClientId(clID) && clID.equals(this.getClientID())) {
                    this.fixClientID();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("The client Id " + clID + " being set is a default client Id and this connection already has the default client Id set"));
                    }
                    return;
                }
                if (this.clientIdExists(clID)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)(" The client ID " + clID + " is invalid as a connection with the same client ID is already running."));
                    }
                    throw (InvalidClientIDException)JmsErrorUtils.newThrowable(InvalidClientIDException.class, "CLIENT_ID_ALREADY_EXISTS_CWSIA0028", new Object[]{clID}, tc);
                }
                this.passThruProps.put("clientID", clID);
                this.addClientId(clID);
                this.fixClientID();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("clientID set to " + clID));
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Attempted to set clientID after it has been fixed.");
                }
                throw (javax.jms.IllegalStateException)JmsErrorUtils.newThrowable(javax.jms.IllegalStateException.class, "CLIENT_ID_FIXED_CWSIA0023", null, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setClientID");
        }
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMetaData");
        }
        this.checkClosed();
        ConnectionMetaData cmd = JmsFactoryFactory.getInstance().getMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)cmd);
        }
        return cmd;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getExceptionListener");
        }
        this.checkClosed();
        ExceptionListener el = this.elRef.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getExceptionListener", (Object)el);
        }
        return el;
    }

    public void setExceptionListener(ExceptionListener eListener) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setExceptionListener", (Object)eListener);
        }
        this.checkClosed();
        this.fixClientID();
        if (this.isManaged) {
            InvocationHandler handler;
            String name;
            boolean exceptionRequired = true;
            if (eListener instanceof Proxy && (name = (handler = Proxy.getInvocationHandler(eListener)).getClass().getName()).startsWith("com.ibm")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"async beans: exceptionListener accepted");
                }
                exceptionRequired = false;
            }
            if (exceptionRequired) {
                throw (javax.jms.IllegalStateException)JmsErrorUtils.newThrowable(javax.jms.IllegalStateException.class, "MGD_ENV_CWSIA0025", new Object[]{"setExceptionListener"}, tc);
            }
        }
        this.elRef.set(eListener);
        if (eListener != null && this.connListener == null) {
            this.connListener = new ConnectionListenerImpl(this);
            try {
                this.coreConnection.addConnectionListener((SICoreConnectionListener)this.connListener);
            }
            catch (SIConnectionUnavailableException e) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsConnectionImpl.setExceptionListener"}, e, null, this, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setExceptionListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        this.fixClientID();
        Object object = this.stateLock;
        synchronized (object) {
            int st = this.getState();
            if (st == 1) {
                Object[] sessionCopy = this.sessions.toArray();
                int sessLength = 0;
                if (sessionCopy != null) {
                    sessLength = sessionCopy.length;
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"sessionCopy is null.");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("About to start " + sessLength + " sessions."));
                }
                for (int i = 0; i < sessLength; ++i) {
                    ((JmsSessionImpl)sessionCopy[i]).start();
                }
                this.setState(2);
            } else if (st == 3) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"start");
                }
                this.checkClosed();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("unknown state: " + st));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        if (this.isManaged) {
            throw (javax.jms.IllegalStateException)JmsErrorUtils.newThrowable(javax.jms.IllegalStateException.class, "MGD_ENV_CWSIA0025", new Object[]{"stop"}, tc);
        }
        this.fixClientID();
        Object object = this.stateLock;
        synchronized (object) {
            int st = this.getState();
            if (st == 2 || st == 1) {
                Object[] sessionCopy = this.sessions.toArray();
                int sessLength = 0;
                if (sessionCopy != null) {
                    sessLength = sessionCopy.length;
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"sessionCopy is null.");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("About to stop " + sessLength + " sessions."));
                }
                for (int i = 0; i < sessLength; ++i) {
                    ((JmsSessionImpl)sessionCopy[i]).stop();
                }
                this.setState(1);
            } else if (st == 3) {
                this.checkClosed();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unknown state: " + st));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws JMSException {
        boolean needToClose;
        block30: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
            }
            if (!this.isManaged) {
                Object object = this.stateLock;
                synchronized (object) {
                    Object[] objectArray = this.sessions.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((JmsSessionImpl)objectArray[i]).validateCloseCommitRollback("close");
                        ((JmsSessionImpl)objectArray[i]).validateStopCloseForMessageListener("close");
                    }
                }
            }
            needToClose = this.getState() != 3;
            try {
                if (!needToClose) break block30;
                this.removeClientId(this.getClientID());
                this.setState(3);
                this.fixClientID();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"connection aquiring sessions lock");
                }
                Object object = this.stateLock;
                synchronized (object) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"connection acquired sessions lock");
                    }
                    Object[] sess = this.sessions.toArray();
                    for (int i = 0; i < sess.length; ++i) {
                        ((JmsSessionImpl)sess[i]).close(true);
                    }
                    this.sessions.clear();
                    this.unusedOrderingContexts.clear();
                    Object[] tempDests = this.temporaryDestinations.toArray();
                    for (int index = 0; index < tempDests.length; ++index) {
                        ((JmsTemporaryDestinationInternal)tempDests[index]).delete();
                    }
                    this.temporaryDestinations.clear();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"connection released sessions lock");
                }
                if (this.connListener == null || this.coreConnection == null) break block30;
                try {
                    this.coreConnection.removeConnectionListener((SICoreConnectionListener)this.connListener);
                }
                catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{sIConnectionUnavailableException, "JmsConnectionImpl.close"}, sIConnectionUnavailableException, null, this, tc);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (!needToClose) throw throwable;
                    this.jcaConnection.close();
                    throw throwable;
                }
                catch (SIException e) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsConnectionImpl.close"}, e, "JmsConnectionImpl.close#2", this, tc);
                }
                finally {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
                    }
                }
            }
        }
        try {
            if (!needToClose) return;
            this.jcaConnection.close();
            return;
        }
        catch (SIException sIException) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{sIException, "JmsConnectionImpl.close"}, sIException, "JmsConnectionImpl.close#2", this, tc);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
            }
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination dest, String selector, ServerSessionPool ssp, int maxMessages) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConnectionConsumer");
        }
        if (this.isManaged) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MGD_ENV_CWSIA0025", new Object[]{"JmsConnectionImpl.createConnectionConsumer"}, tc);
        }
        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNSUPPORTED_FUNC_CWSIA0026", new Object[]{"JmsConnectionImpl.createConnectionConsumer()"}, tc);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subName, String selector, ServerSessionPool ssp, int maxMessages) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDurableConnectionConsumer");
        }
        if (this.isManaged) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MGD_ENV_CWSIA0025", new Object[]{"createDurableConnectionConsumer"}, tc);
        }
        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNSUPPORTED_FUNC_CWSIA0026", new Object[]{"JmsConnectionImpl.createDurableConnectionConsumer()"}, tc);
    }

    @Override
    public void reportException(JMSException e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reportException", (Object)((Object)e));
        }
        if (this.elRef.get() != null) {
            this.asyncExceptionTask.handleException(e);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"No exception listener is currently set for this connection.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reportException");
        }
    }

    @Override
    public String getConnectedMEName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConnectedMEName");
        }
        String meName = this.coreConnection.getMeName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConnectedMEName", (Object)meName);
        }
        return meName;
    }

    public void createDestination(Destination dest) throws JMSException {
        UTEHelperFactory.getHelperInstance().createDestination(dest);
    }

    public void deleteDestination(Destination dest) throws JMSException {
        UTEHelperFactory.getHelperInstance().deleteDestination(dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionCount() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.sessions.size();
        }
    }

    int getTempDestCount() {
        return this.temporaryDestinations.size();
    }

    JmsSessionImpl instantiateSession(boolean transacted, int acknowledgeMode, SICoreConnection coreConnection, JmsJcaSession jcaSession) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"instantiateSession", (Object)new Object[]{transacted, acknowledgeMode, coreConnection, jcaSession});
        }
        JmsSessionImpl jmsSession = new JmsSessionImpl(transacted, acknowledgeMode, coreConnection, this, jcaSession);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"instantiateSession", (Object)jmsSession);
        }
        return jmsSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(JmsSessionImpl sess) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeSession", (Object)sess);
        }
        Object object = this.stateLock;
        synchronized (object) {
            boolean res = this.sessions.remove(sess);
            this.unusedOrderingContexts.add(sess.getOrderingContext());
            if (!res && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"session not found in list");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getState() {
        int tempState;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getState");
        }
        Object object = this.stateLock;
        synchronized (object) {
            tempState = this.state;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getState", (Object)this.state);
        }
        return tempState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(int newState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setState", (Object)newState);
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (newState == 3 || newState == 1 || newState == 2) {
                this.state = newState;
                this.stateLock.notifyAll();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setState");
        }
    }

    protected void checkClosed() throws JMSException {
        if (this.getState() == 3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"This Connection is closed.");
            }
            throw (javax.jms.IllegalStateException)JmsErrorUtils.newThrowable(javax.jms.IllegalStateException.class, "CONNECTION_CLOSED_CWSIA0021", null, tc);
        }
    }

    boolean isManaged() {
        return this.isManaged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fixClientID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"fixClientID");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.clientIDFixed = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"fixClientID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unfixClientID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unfixClientID");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.clientIDFixed = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unfixClientID");
        }
    }

    protected JmsJcaSession createJcaSession(boolean transacted) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createJcaSession", (Object)transacted);
        }
        JmsJcaSession jcaSess = null;
        if (this.jcaConnection != null) {
            try {
                jcaSess = this.jcaConnection.createSession(transacted);
            }
            catch (Exception e) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "JCA_CREATE_SESS_CWSIA0024", null, e, "JmsConnectionImpl.createSession#1", this, tc);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"jcaConnection is null, returning null jcaSess");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createJcaSession", (Object)jcaSess);
        }
        return jcaSess;
    }

    protected Map getPassThruProps() {
        return this.passThruProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTemporaryDestination(JmsTemporaryDestinationInternal tempDest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addTemporaryDestination", (Object)System.identityHashCode(tempDest));
        }
        List list = this.temporaryDestinations;
        synchronized (list) {
            this.temporaryDestinations.add(tempDest);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addTemporaryDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTemporaryDestination(JmsTemporaryDestinationInternal tempDest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeTemporaryDestination", (Object)System.identityHashCode(tempDest));
        }
        List list = this.temporaryDestinations;
        synchronized (list) {
            this.temporaryDestinations.remove(tempDest);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeTemporaryDestination");
        }
    }

    public static boolean isClonedServer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isClonedServer");
        }
        if (isCloned == null) {
            isCloned = RuntimeInfo.isClusteredServer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isClonedServer", (Object)isCloned);
        }
        return isCloned;
    }

    public static void setIsClonedServer(Boolean newVal) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setIsClonedServer", (Object)newVal);
        }
        isCloned = newVal;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setIsClonedServer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderingContext allocateOrderingContext() throws SIConnectionDroppedException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"allocateOrderingContext");
        }
        OrderingContext oc = null;
        Object object = this.stateLock;
        synchronized (object) {
            while (oc == null && !this.unusedOrderingContexts.isEmpty()) {
                oc = this.unusedOrderingContexts.remove(0);
                if (!oc.isProxyConnectionClosed()) continue;
                oc = null;
            }
            if (oc == null) {
                oc = this.coreConnection.createOrderingContext();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"allocateOrderingContext", (Object)oc);
        }
        return oc;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("ConnectionId: " + Integer.toHexString(System.identityHashCode(this)));
        result.append(", MEName: " + this.coreConnection.getMeName());
        result.append(", Sessions: " + this.sessions.size());
        result.append(", TemporaryDestinations: " + this.temporaryDestinations.size());
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initExceptionThreadPool() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initExceptionThreadPool");
        }
        Object object = exceptionTPCreateSync;
        synchronized (object) {
            if (exceptionThreadPool == null) {
                int maxThreads = Integer.parseInt("10");
                String maxThreadsStr = RuntimeInfo.getProperty((String)"sib.apijms.maxExceptionThreads", (String)"10");
                try {
                    maxThreads = Integer.parseInt(maxThreadsStr);
                }
                catch (NumberFormatException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("sib.apijms.maxExceptionThreads: " + Integer.toString(maxThreads)));
                }
                exceptionThreadPool = new ThreadPool("JMS Exception Callback", 0, maxThreads);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initExceptionThreadPool");
        }
    }

    private void callExceptionListener(JMSException e) {
        ExceptionListener elLocal;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"callExceptionListener");
        }
        if ((elLocal = this.elRef.get()) != null) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exception handler class: " + elLocal.getClass().getName()));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception: ", (Object)((Object)e));
                }
                elLocal.onException(e);
            }
            catch (RuntimeException exc) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"User ExceptionListener threw exception", (Object)exc);
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"No exception listener is currently set for this connection.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"callExceptionListener");
        }
    }

    public Session createSession() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSession");
        }
        Session session = null;
        try {
            session = this.createSession(false, 1);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSession");
            }
        }
        return session;
    }

    public Session createSession(int sessionMode) throws JMSException {
        Session session = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSession", (Object)new Object[]{sessionMode});
        }
        try {
            session = sessionMode == 0 ? this.createSession(true, sessionMode) : this.createSession(false, sessionMode);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSession");
            }
        }
        return session;
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic arg0, String arg1, String arg2, ServerSessionPool arg3, int arg4) throws javax.jms.IllegalStateException, InvalidDestinationException, InvalidSelectorException, JMSException {
        if (this.isManaged) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MGD_ENV_CWSIA0025", new Object[]{"createSharedConnectionConsumer"}, tc);
        }
        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNSUPPORTED_FUNC_CWSIA0026", new Object[]{"JmsConnectionImpl.createSharedConnectionConsumer()"}, tc);
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic arg0, String arg1, String arg2, ServerSessionPool arg3, int arg4) throws javax.jms.IllegalStateException, InvalidDestinationException, InvalidSelectorException, JMSException {
        if (this.isManaged) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MGD_ENV_CWSIA0025", new Object[]{"createSharedDurableConnectionConsumer"}, tc);
        }
        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNSUPPORTED_FUNC_CWSIA0026", new Object[]{"JmsConnectionImpl.createSharedDurableConnectionConsumer()"}, tc);
    }

    private void addClientId(String clientId) {
        if (clientId == null) {
            return;
        }
        ConcurrentHashMap<String, Integer> clientIdTable = JmsFactoryFactoryImpl.getClientIdTable();
        if (clientIdTable.containsKey(clientId)) {
            clientIdTable.put(clientId, clientIdTable.get(clientId) + 1);
        } else {
            clientIdTable.put(clientId, 1);
        }
    }

    private void removeClientId(String clientId) {
        if (clientId == null) {
            return;
        }
        ConcurrentHashMap<String, Integer> clientIdTable = JmsFactoryFactoryImpl.getClientIdTable();
        if (clientIdTable.containsKey(clientId)) {
            int referenceCount = clientIdTable.get(clientId);
            if (referenceCount == 1) {
                clientIdTable.remove(clientId);
            } else {
                clientIdTable.put(clientId, clientIdTable.get(clientId) - 1);
            }
        }
    }

    private boolean clientIdExists(String clientId) {
        if (clientId == null) {
            return false;
        }
        ConcurrentHashMap<String, Integer> clientIdTable = JmsFactoryFactoryImpl.getClientIdTable();
        return clientIdTable.containsKey(clientId);
    }

    boolean isDefaultClientId(String clientId) {
        return "clientID".equals(clientId);
    }

    private class JmsAsyncExceptionTask
    implements Runnable {
        private final LinkedList<JMSException> exceptionQueue = new LinkedList();
        private boolean active = false;

        private JmsAsyncExceptionTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"run");
            }
            boolean moreWork = true;
            while (moreWork) {
                JMSException jmse = null;
                JmsAsyncExceptionTask jmsAsyncExceptionTask = this;
                synchronized (jmsAsyncExceptionTask) {
                    int size = this.exceptionQueue.size();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exceptions queued for handling: " + size));
                    }
                    moreWork = size > 0;
                    this.active = moreWork;
                    if (moreWork) {
                        jmse = this.exceptionQueue.removeFirst();
                    }
                }
                if (jmse == null) continue;
                JmsConnectionImpl.this.callExceptionListener(jmse);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"run");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleException(JMSException jmse) {
            boolean threadAvailable;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"handleException", (Object)((Object)jmse));
            }
            JmsAsyncExceptionTask jmsAsyncExceptionTask = this;
            synchronized (jmsAsyncExceptionTask) {
                threadAvailable = this.active;
                if (!threadAvailable) {
                    try {
                        if (exceptionThreadPool == null) {
                            JmsConnectionImpl.initExceptionThreadPool();
                        }
                        exceptionThreadPool.execute((Runnable)this);
                        this.active = true;
                        threadAvailable = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Activated exception handling thread for connection");
                        }
                    }
                    catch (Throwable ue) {
                        if (ue instanceof ThreadDeath) {
                            throw (ThreadDeath)ue;
                        }
                        FFDCFilter.processException((Throwable)ue, (String)"com.ibm.ws.sib.api.jms.impl.JmsConnectionImpl", (String)"handleException#2", (Object)this);
                    }
                }
                if (threadAvailable) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Queuing exception for handling thread");
                    }
                    this.exceptionQueue.addLast(jmse);
                }
            }
            if (!threadAvailable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Calling exception handler in-line.");
                }
                JmsConnectionImpl.this.callExceptionListener(jmse);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"handleException");
            }
        }
    }
}

