/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install;

import com.ibm.websphere.crypto.InvalidPasswordDecodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.RepositoryConfig;
import com.ibm.ws.install.RepositoryConfigValidationResult;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.repository.internal.RepositoryUtils;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.repository.connections.DirectoryRepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RestRepositoryConnection;
import com.ibm.ws.repository.connections.RestRepositoryConnectionProxy;
import com.ibm.ws.repository.connections.ZipRepositoryConnection;
import com.ibm.ws.repository.exceptions.RepositoryException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RepositoryConfigUtils {
    public static final String WLP_REPO = "default";
    public static final String USE_WLP_REPO = "useDefaultRepository";
    public static final String ORDER = "order";
    public static final String URL_SUFFIX = ".url";
    public static final String APIKEY_SUFFIX = ".apiKey";
    public static final String USER_SUFFIX = ".user";
    public static final String USERPWD_SUFFIX = ".userPassword";
    public static final String PWD_SUFFIX = ".password";
    public static final String COMMENT_PREFIX = "#";
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_USER = "proxyUser";
    public static final String PROXY_PASSWORD = "proxyPassword";
    public static final String EQUALS = "=";
    private static final String[] SUPPORTED_KEYS = new String[]{"useDefaultRepository", "proxyHost", "proxyPort", "proxyUser", "proxyPassword"};
    private static final Logger logger = Logger.getLogger("com.ibm.ws.install");

    public static Properties loadRepoProperties() throws InstallException {
        Properties repoProperties;
        block6: {
            boolean isPropsLocationOverridden;
            File repoPropertiesFile;
            block5: {
                repoProperties = null;
                repoPropertiesFile = new File(RepositoryConfigUtils.getRepoPropertiesFileLocation());
                boolean bl = isPropsLocationOverridden = System.getProperty("WLP_REPOSITORIES_PROPS") != null;
                if (!repoPropertiesFile.exists() || !repoPropertiesFile.isFile()) break block5;
                repoProperties = new Properties();
                FileInputStream repoPropertiesInput = null;
                try {
                    repoPropertiesInput = new FileInputStream(repoPropertiesFile);
                    repoProperties.load(repoPropertiesInput);
                }
                catch (Exception e) {
                    try {
                        throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_REPOSITORY_PROPS_NOT_LOADED", RepositoryConfigUtils.getRepoPropertiesFileLocation()), 25);
                    }
                    catch (Throwable throwable) {
                        InstallUtils.close(repoPropertiesInput);
                        throw throwable;
                    }
                }
                InstallUtils.close(repoPropertiesInput);
                break block6;
            }
            if (isPropsLocationOverridden) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage(repoPropertiesFile.isDirectory() ? "ERROR_TOOL_REPOSITORY_PROPS_NOT_FILE" : "ERROR_TOOL_REPOSITORY_PROPS_NOT_EXISTS", RepositoryConfigUtils.getRepoPropertiesFileLocation()), 25);
            }
        }
        return repoProperties;
    }

    public static String getRepoPropertiesFileLocation() {
        String installDirPath = Utils.getInstallDir().getAbsolutePath();
        String overrideLocation = System.getProperty("WLP_REPOSITORIES_PROPS");
        if (overrideLocation == null) {
            return installDirPath + InstallConstants.DEFAULT_REPO_PROPERTIES_LOCATION;
        }
        return overrideLocation;
    }

    public static void setProxyAuthenticator(final String proxyHost, final String proxyPort, final String proxyUser, final String decodedPwd) {
        if (proxyUser == null || proxyUser.isEmpty() || decodedPwd == null || decodedPwd.isEmpty()) {
            return;
        }
        Authenticator.setDefault(new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equals(proxyHost) && this.getRequestingPort() == Integer.valueOf(proxyPort).intValue()) {
                    return new PasswordAuthentication(proxyUser, decodedPwd.toCharArray());
                }
                return null;
            }
        });
    }

    public static RestRepositoryConnectionProxy getProxyInfo(Properties repoProperties) throws InstallException {
        RestRepositoryConnectionProxy proxyInfo = null;
        URL proxyURL = null;
        if (repoProperties != null) {
            String proxyHost = repoProperties.getProperty(PROXY_HOST);
            String proxyPort = repoProperties.getProperty(PROXY_PORT);
            String proxyUser = RepositoryConfigUtils.getProxyUser(repoProperties);
            String proxyPwd = RepositoryConfigUtils.getProxyPwd(repoProperties);
            try {
                if (proxyHost != null && !proxyHost.isEmpty() && proxyPort != null && !proxyPort.isEmpty()) {
                    proxyHost = proxyHost.trim();
                    proxyPort = proxyPort.trim();
                    logger.log(Level.FINEST, "proxyHost: " + proxyHost);
                    logger.log(Level.FINEST, "proxyPort: " + proxyPort);
                    logger.log(Level.FINEST, "proxyUser: " + proxyUser);
                    logger.log(Level.FINEST, "proxyPassword: ********");
                    proxyURL = proxyHost.toLowerCase().startsWith("http://") ? new URL(proxyHost + ":" + proxyPort) : new URL("http://" + proxyHost + ":" + proxyPort);
                    if (proxyURL.getPort() < 0 || proxyURL.getPort() > 65535) {
                        throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_INVALID_PROXY_PORT", String.valueOf(proxyURL.getPort())));
                    }
                } else {
                    if ((proxyHost == null || proxyHost.isEmpty()) && proxyPort != null) {
                        throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_PROXY_HOST_MISSING", new Object[0]), 24);
                    }
                    if (proxyHost != null && (proxyPort == null || proxyPort.isEmpty())) {
                        throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_PROXY_PORT_MISSING", new Object[0]), 24);
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_INVALID_PROXY_PORT", proxyPort), e, 21);
            }
            if (proxyURL != null) {
                if (proxyUser != null && !proxyUser.isEmpty() && proxyPwd != null && !proxyPwd.isEmpty()) {
                    proxyUser = proxyUser.trim();
                    String decodedPwd = proxyPwd = proxyPwd.trim();
                    try {
                        decodedPwd = PasswordUtil.decode((String)proxyPwd);
                        RepositoryConfigUtils.setProxyAuthenticator(proxyHost, proxyPort, proxyUser, decodedPwd);
                    }
                    catch (InvalidPasswordDecodingException ipde) {
                        decodedPwd = proxyPwd;
                        logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_PASSWORD_NOT_ENCODED_PROXY", proxyURL) + InstallUtils.NEWLINE);
                        RepositoryConfigUtils.setProxyAuthenticator(proxyHost, proxyPort, proxyUser, decodedPwd);
                    }
                    catch (UnsupportedCryptoAlgorithmException ucae) {
                        throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_PROXY_PWD_CRYPTO_UNSUPPORTED", new Object[0]), ucae, 21);
                    }
                }
                try {
                    proxyInfo = new RestRepositoryConnectionProxy(proxyURL);
                }
                catch (RepositoryException e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    if (sw.toString().contains("com.ibm.websphere.ssl.protocol.SSLSocketFactory")) {
                        throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_CONNECT_JDK_WRONG", new Object[0]), e, 21);
                    }
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_CONNECT", new Object[0]), e, 21);
                }
            }
        }
        return proxyInfo;
    }

    public static String getProxyUser(Properties repoProperties) {
        return repoProperties.getProperty(PROXY_USER);
    }

    public static String getProxyPwd(Properties repoProperties) {
        if (repoProperties.getProperty("proxyUserPassword") != null) {
            return repoProperties.getProperty("proxyUserPassword");
        }
        if (repoProperties.getProperty(PROXY_PASSWORD) != null) {
            return repoProperties.getProperty(PROXY_PASSWORD);
        }
        return null;
    }

    public static List<String> getOrderList(Properties repoProperties) throws InstallException {
        ArrayList<String> orderList = new ArrayList<String>();
        ArrayList<String> repoList = new ArrayList<String>();
        File repoPropertiesFile = new File(RepositoryConfigUtils.getRepoPropertiesFileLocation());
        if (repoPropertiesFile.exists() && repoPropertiesFile.isFile()) {
            FileInputStream repoPropertiesInput = null;
            BufferedReader repoPropertiesReader = null;
            try {
                String line;
                repoPropertiesInput = new FileInputStream(repoPropertiesFile);
                repoPropertiesReader = new BufferedReader(new InputStreamReader(repoPropertiesInput));
                while ((line = repoPropertiesReader.readLine()) != null) {
                    String url;
                    String repoName;
                    String[] keyValue = line.split(EQUALS);
                    if (line.startsWith(COMMENT_PREFIX) || keyValue.length <= 1 || !keyValue[0].endsWith(URL_SUFFIX) || (repoName = keyValue[0].substring(0, keyValue[0].length() - URL_SUFFIX.length())).isEmpty()) continue;
                    if (orderList.contains(repoName)) {
                        repoList.remove(orderList.indexOf(repoName));
                        orderList.remove(repoName);
                    }
                    orderList.add(repoName);
                    repoList.add(line);
                    if (!InstallUtils.isWindows || keyValue.length <= 1 || !keyValue[1].contains("\\") || (url = repoProperties.getProperty(keyValue[0])) == null || InstallUtils.isURL(url)) continue;
                    repoProperties.put(keyValue[0], keyValue[1].trim());
                    logger.log(Level.FINEST, "The value of " + keyValue[0] + " was replaced to " + repoProperties.getProperty(keyValue[0]));
                }
            }
            catch (IOException e) {
                try {
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_REPOSITORY_PROPS_NOT_LOADED", RepositoryConfigUtils.getRepoPropertiesFileLocation()), 25);
                }
                catch (Throwable throwable) {
                    InstallUtils.close(repoPropertiesInput);
                    InstallUtils.close(repoPropertiesReader);
                    throw throwable;
                }
            }
            InstallUtils.close(repoPropertiesInput);
            InstallUtils.close(repoPropertiesReader);
        }
        if (RepositoryConfigUtils.isWlpRepoEnabled(repoProperties)) {
            orderList.add(WLP_REPO);
        }
        return orderList;
    }

    private static boolean repoPropertiesFileExists() {
        return new File(RepositoryConfigUtils.getRepoPropertiesFileLocation()).exists();
    }

    public static boolean isWlpRepoEnabled(Properties repoProperties) {
        if (!RepositoryConfigUtils.repoPropertiesFileExists() || repoProperties == null) {
            return true;
        }
        String wlpEnabled = repoProperties.getProperty(USE_WLP_REPO);
        if (wlpEnabled == null) {
            return true;
        }
        return !wlpEnabled.trim().equalsIgnoreCase("false");
    }

    public static List<RepositoryConfig> getRepositoryConfigs(Properties repoProperties) throws InstallException {
        List<String> orderList = RepositoryConfigUtils.getOrderList(repoProperties);
        ArrayList<RepositoryConfig> connections = new ArrayList<RepositoryConfig>(orderList.size());
        if (repoProperties == null || repoProperties.isEmpty()) {
            connections.add(new RepositoryConfig(WLP_REPO, null, null, null, null));
            return connections;
        }
        for (String r : orderList) {
            if (r.equalsIgnoreCase(WLP_REPO)) {
                connections.add(new RepositoryConfig(WLP_REPO, null, null, null, null));
                continue;
            }
            String url = repoProperties.getProperty(r + URL_SUFFIX);
            String user = null;
            String userPwd = null;
            if (url == null || url.isEmpty()) continue;
            user = repoProperties.getProperty(r + USER_SUFFIX);
            if (user != null) {
                if (user.isEmpty()) {
                    user = null;
                } else {
                    userPwd = repoProperties.getProperty(r + PWD_SUFFIX);
                    if (userPwd == null || userPwd.isEmpty()) {
                        userPwd = repoProperties.getProperty(r + USERPWD_SUFFIX);
                    }
                    if (userPwd != null && userPwd.isEmpty()) {
                        userPwd = null;
                    }
                }
            }
            String apiKey = repoProperties.getProperty(r + APIKEY_SUFFIX);
            if (!InstallUtils.isURL(url = url.trim())) {
                File f = new File(url);
                try {
                    url = f.toURI().toURL().toString();
                }
                catch (MalformedURLException e1) {
                    logger.log(Level.FINEST, "Failed to convert " + f.getAbsolutePath() + " to url format", e1);
                }
            }
            connections.add(new RepositoryConfig(r, url, apiKey, user, userPwd));
        }
        if (connections.isEmpty()) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_NO_REPO_WAS_ENABLED", new Object[0]));
        }
        return connections;
    }

    public static String getRepoName(Properties repoProperties, RepositoryConnection repoConn) throws InstallException {
        String repoName = null;
        List<RepositoryConfig> configRepos = RepositoryConfigUtils.getRepositoryConfigs(repoProperties);
        if (!(repoConn instanceof DirectoryRepositoryConnection) && !(repoConn instanceof ZipRepositoryConnection) && RepositoryConfigUtils.isLibertyRepository((RestRepositoryConnection)repoConn, repoProperties)) {
            return WLP_REPO;
        }
        for (RepositoryConfig rc : configRepos) {
            if (rc.getUrl() == null) continue;
            if (rc.getUrl().toLowerCase().startsWith("file:") && (repoConn instanceof DirectoryRepositoryConnection || repoConn instanceof ZipRepositoryConnection)) {
                String repoDir = rc.getUrl();
                try {
                    URL fileURL = new URL(repoDir);
                    File repoFile = new File(fileURL.getPath());
                    if (!repoFile.getAbsolutePath().equalsIgnoreCase(repoConn.getRepositoryLocation())) continue;
                    repoName = rc.getId();
                    break;
                }
                catch (Exception e) {
                    throw new InstallException(RepositoryUtils.getMessage("ERROR_DIRECTORY_NOT_EXISTS", repoDir));
                }
            }
            if (!rc.getUrl().equalsIgnoreCase(repoConn.getRepositoryLocation())) continue;
            repoName = rc.getId();
            break;
        }
        return repoName;
    }

    public static boolean isLibertyRepository(RestRepositoryConnection lie, Properties repoProperties) throws InstallException {
        if (RepositoryConfigUtils.isWlpRepoEnabled(repoProperties)) {
            return lie.getRepositoryLocation().startsWith("https://asset-websphere.ibm.com/ma/v1");
        }
        return false;
    }

    private static boolean isKeySupported(String key) {
        if (Arrays.asList(SUPPORTED_KEYS).contains(key)) {
            return true;
        }
        return key.endsWith(URL_SUFFIX) || key.endsWith(APIKEY_SUFFIX) || key.endsWith(USER_SUFFIX) || key.endsWith(PWD_SUFFIX) || key.endsWith(USERPWD_SUFFIX);
    }

    private static void validateRepositoryPropertiesLine(Properties repoProperties, String line, int lineNum, Map<String, String> configMap, Map<String, Integer> lineMap, List<RepositoryConfigValidationResult> validationResults) {
        if (!(line = line.trim()).isEmpty() && !line.startsWith(COMMENT_PREFIX)) {
            String[] keyValue = line.split(EQUALS);
            String key = null;
            String value = null;
            if (keyValue.length >= 2) {
                key = keyValue[0];
                value = keyValue[1];
            } else if (keyValue.length == 1) {
                key = keyValue[0];
            }
            if (key == null || key.isEmpty()) {
                validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.EMPTY_KEY, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_EMPTY_KEY", new Object[0])));
                return;
            }
            if (!RepositoryConfigUtils.isKeySupported(key)) {
                validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_KEY, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_KEY", key)));
                return;
            }
            if (key.endsWith(URL_SUFFIX) || key.endsWith(PWD_SUFFIX) || key.endsWith(USER_SUFFIX) || key.endsWith(USERPWD_SUFFIX) || key.endsWith(APIKEY_SUFFIX)) {
                int suffixIndex = key.lastIndexOf(".");
                String suffix = key.substring(suffixIndex);
                String repoName = keyValue[0].substring(0, keyValue[0].length() - suffix.length()).trim();
                if (repoName.isEmpty()) {
                    logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_NO_REPO_NAME", line));
                    validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.MISSING_REPONAME, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_EMPTY_REPONAME", new Object[0])));
                    return;
                }
            }
            if (configMap.containsKey(key)) {
                validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.DUPLICATE_KEY, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_DUPLICATE_KEY", key, lineMap.get(key))));
                return;
            }
            configMap.put(key, value);
            lineMap.put(key, lineNum);
            if (value == null || value.isEmpty()) {
                validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.EMPTY_VALUE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_EMPTY_VALUE", key)));
                return;
            }
            if (key.equals(USE_WLP_REPO) && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
                validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_VALUE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_DEFAULTREPO_VALUE", value)));
                return;
            }
            if (key.endsWith(URL_SUFFIX)) {
                String url = value;
                url = repoProperties.getProperty(key);
                try {
                    URL repoUrl;
                    String protocol;
                    url = url.trim();
                    if (InstallUtils.isURL(url) && !(protocol = (repoUrl = new URL(url)).getProtocol()).equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https") && !protocol.equalsIgnoreCase("file")) {
                        validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.UNSUPPORTED_PROTOCOL, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_UNSUPPORT_PROTOCOL", value)));
                        return;
                    }
                }
                catch (MalformedURLException e) {
                    validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_URL, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_URL", value)));
                    return;
                }
            }
            if (key.equals(PROXY_PORT)) {
                try {
                    int port = Integer.parseInt(value);
                    if (port <= 0 || port > 65535) {
                        validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_PORT, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_PORT_VALUE", value)));
                        return;
                    }
                }
                catch (Exception e) {
                    validationResults.add(new RepositoryConfigValidationResult(lineNum, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_PORT, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_PORT_VALUE", value)));
                    return;
                }
            }
        }
    }

    public static List<RepositoryConfigValidationResult> validateRepositoryPropertiesFile(Properties repoProperties) throws InstallException {
        ArrayList<RepositoryConfigValidationResult> validationResults = new ArrayList<RepositoryConfigValidationResult>();
        File repoPropertiesFile = new File(RepositoryConfigUtils.getRepoPropertiesFileLocation());
        HashMap<String, String> configMap = new HashMap<String, String>();
        HashMap<String, Integer> lineMap = new HashMap<String, Integer>();
        if (repoPropertiesFile.exists() && repoPropertiesFile.isFile()) {
            BufferedReader repoPropertiesReader;
            FileInputStream repoPropertiesInput;
            block13: {
                logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_VALIDATING", RepositoryConfigUtils.getRepoPropertiesFileLocation()));
                repoPropertiesInput = null;
                repoPropertiesReader = null;
                try {
                    String line;
                    repoPropertiesInput = new FileInputStream(repoPropertiesFile);
                    repoPropertiesReader = new BufferedReader(new InputStreamReader(repoPropertiesInput));
                    int lineNum = 0;
                    while ((line = repoPropertiesReader.readLine()) != null) {
                        RepositoryConfigUtils.validateRepositoryPropertiesLine(repoProperties, line, ++lineNum, configMap, lineMap, validationResults);
                    }
                    if (configMap.containsKey(PROXY_HOST)) {
                        int ln = (Integer)lineMap.get(PROXY_HOST);
                        if (!configMap.containsKey(PROXY_PORT)) {
                            validationResults.add(new RepositoryConfigValidationResult(ln, RepositoryConfigValidationResult.ValidationFailedReason.MISSING_PORT, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_MISSING_PORT_VALUE", configMap.get(PROXY_HOST))));
                            break block13;
                        }
                        String proxyHost = repoProperties.getProperty(PROXY_HOST);
                        String proxyPort = repoProperties.getProperty(PROXY_PORT);
                        try {
                            proxyHost = proxyHost.trim();
                            proxyPort = proxyPort.trim();
                            URL proxyUrl = null;
                            if (proxyHost.toLowerCase().contains("://")) {
                                proxyUrl = new URL(proxyHost + ":" + proxyPort);
                                if (!proxyUrl.getProtocol().toLowerCase().equals("http")) {
                                    validationResults.add(new RepositoryConfigValidationResult(ln, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_HOST, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_HOST", configMap.get(PROXY_HOST))));
                                }
                                break block13;
                            }
                            new URL("http://" + proxyHost + ":" + proxyPort);
                        }
                        catch (MalformedURLException e) {
                            validationResults.add(new RepositoryConfigValidationResult(ln, RepositoryConfigValidationResult.ValidationFailedReason.INVALID_HOST, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_INVALID_HOST", configMap.get(PROXY_HOST))));
                        }
                        break block13;
                    }
                    if (configMap.containsKey(PROXY_PORT) || configMap.containsKey(PROXY_USER) || configMap.containsKey(PROXY_PASSWORD)) {
                        int ln = 0;
                        ln = lineMap.containsKey(PROXY_PORT) ? (Integer)lineMap.get(PROXY_PORT) : (lineMap.containsKey(PROXY_USER) ? ((Integer)lineMap.get(PROXY_USER)).intValue() : ((Integer)lineMap.get(PROXY_PASSWORD)).intValue());
                        validationResults.add(new RepositoryConfigValidationResult(ln, RepositoryConfigValidationResult.ValidationFailedReason.MISSING_HOST, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_VALIDATION_MISSING_HOST", new Object[0])));
                    }
                }
                catch (IOException e) {
                    try {
                        throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_REPOSITORY_PROPS_NOT_LOADED", RepositoryConfigUtils.getRepoPropertiesFileLocation()), 25);
                    }
                    catch (Throwable throwable) {
                        InstallUtils.close(repoPropertiesInput);
                        InstallUtils.close(repoPropertiesReader);
                        throw throwable;
                    }
                }
            }
            InstallUtils.close(repoPropertiesInput);
            InstallUtils.close(repoPropertiesReader);
            logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_VALIDATION_DONE", new Object[0]));
        }
        return validationResults;
    }

    @Deprecated
    public static void validatePropertiesFile(Properties repoProperties) throws InstallException {
        ArrayList<String> repoList = new ArrayList<String>();
        ArrayList<String> duplicateRepoList = new ArrayList<String>();
        File repoPropertiesFile = new File(RepositoryConfigUtils.getRepoPropertiesFileLocation());
        if (repoPropertiesFile.exists() && repoPropertiesFile.isFile()) {
            logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_VALIDATING", RepositoryConfigUtils.getRepoPropertiesFileLocation()));
            FileInputStream repoPropertiesInput = null;
            BufferedReader repoPropertiesReader = null;
            try {
                String line;
                repoPropertiesInput = new FileInputStream(repoPropertiesFile);
                repoPropertiesReader = new BufferedReader(new InputStreamReader(repoPropertiesInput));
                while ((line = repoPropertiesReader.readLine()) != null) {
                    String[] keyValue = line.split(EQUALS);
                    if (line.startsWith(COMMENT_PREFIX) || keyValue.length <= 1 || !keyValue[0].endsWith(URL_SUFFIX)) continue;
                    String repoName = keyValue[0].substring(0, keyValue[0].length() - URL_SUFFIX.length());
                    if (repoName.isEmpty()) {
                        logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_NO_REPO_NAME", line));
                        continue;
                    }
                    if (repoList.contains(repoName)) {
                        logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_DUPLICATE_REPO_NAMES", repoName, duplicateRepoList.get(repoList.indexOf(repoName))));
                        duplicateRepoList.remove(repoList.indexOf(repoName));
                        repoList.remove(repoName);
                    }
                    repoList.add(repoName);
                    duplicateRepoList.add(line);
                }
                String wlpEnabled = repoProperties.getProperty(USE_WLP_REPO);
                String string = wlpEnabled = wlpEnabled == null ? null : wlpEnabled.trim();
                if (wlpEnabled != null && !wlpEnabled.equalsIgnoreCase("false") && !wlpEnabled.equalsIgnoreCase("true")) {
                    logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_DEFAULT_INVALID_VALUE", wlpEnabled));
                }
            }
            catch (IOException e) {
                try {
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_REPOSITORY_PROPS_NOT_LOADED", RepositoryConfigUtils.getRepoPropertiesFileLocation()), 25);
                }
                catch (Throwable throwable) {
                    InstallUtils.close(repoPropertiesInput);
                    InstallUtils.close(repoPropertiesReader);
                    throw throwable;
                }
            }
            InstallUtils.close(repoPropertiesInput);
            InstallUtils.close(repoPropertiesReader);
            logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_VALIDATION_DONE", new Object[0]));
        }
    }
}

