/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.asset;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.kernel.boot.EmbeddedServerImpl;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.wsspi.kernel.embeddable.Server;
import com.ibm.wsspi.kernel.embeddable.ServerBuilder;
import com.ibm.wsspi.kernel.embeddable.ServerException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class ServerAsset
implements Comparable<ServerAsset> {
    private static final String TEMP_SERVER_NAME = "tempServer";
    private final Collection<String> requiredFeatures;
    private final File serverInfo;
    private final String serverName;
    private static final SecureRandom random = new SecureRandom();

    public ServerAsset(String serverName) throws InstallException, IOException {
        this(new File(InstallUtils.getServersDir(), (null == serverName ? "" : serverName + File.separator) + "server.xml"));
    }

    public ServerAsset(File serverXMLFile) throws InstallException, IOException {
        this(ServerAsset.determineServerName(serverXMLFile), serverXMLFile);
    }

    public ServerAsset(String serverName, File serverXMLFile) {
        this.serverInfo = serverXMLFile;
        this.serverName = serverName;
        this.requiredFeatures = new HashSet<String>();
    }

    public File getServerDirectory() {
        return this.serverInfo.getParentFile();
    }

    private static String determineServerName(File serverXMLFile) throws InstallException, IOException {
        if (ServerAsset.isExistingServer(serverXMLFile)) {
            return serverXMLFile.getParentFile().getCanonicalFile().getName();
        }
        return ServerAsset.generateTempServerName();
    }

    private static boolean isExistingServer(File serverXMLFile) throws IOException {
        File path;
        String name;
        if (null != serverXMLFile && null != (name = (path = serverXMLFile.getParentFile().getCanonicalFile()).getName()) && !InstallUtils.getServersDir().getCanonicalFile().equals(path)) {
            return InstallUtils.serverExists(name);
        }
        return false;
    }

    private static String generateTempServerName() {
        String serverName = TEMP_SERVER_NAME;
        while (InstallUtils.serverExists(serverName)) {
            int randomNumber = random.nextInt();
            while (randomNumber == Integer.MIN_VALUE) {
                randomNumber = random.nextInt();
            }
            serverName = "tempServer_" + Integer.toString(Math.abs(randomNumber));
        }
        return serverName;
    }

    public Collection<String> getRequiredFeatures() throws InstallException, IOException {
        if (this.requiredFeatures.isEmpty()) {
            this.requiredFeatures.addAll(EmbeddedServerLauncher.getRequiredFeatures(this.serverInfo, this.serverName));
        }
        return Collections.unmodifiableCollection(this.requiredFeatures);
    }

    public String getServerName() {
        return this.serverName;
    }

    private static String getServerLogsDirectoryPath(File serverDir) {
        File dir = new File(serverDir, "logs");
        return dir.getAbsolutePath();
    }

    public String toString() {
        return this.getServerName();
    }

    @Override
    public int compareTo(ServerAsset sa) {
        if (null == sa) {
            return 1;
        }
        if (this.getServerName().equalsIgnoreCase(sa.getServerName())) {
            return 0;
        }
        return this.getServerName().compareTo(sa.getServerName());
    }

    public boolean equals(Object o) {
        if (null != o && o instanceof ServerAsset) {
            return this.getServerName().equalsIgnoreCase(((ServerAsset)o).getServerName());
        }
        return false;
    }

    public int hashCode() {
        return this.getServerName().hashCode();
    }

    private static class EmbeddedServerLauncher {
        private EmbeddedServerLauncher() {
        }

        public static Collection<String> getRequiredFeatures(File serverInfo, String serverName) throws InstallException, IOException {
            boolean isTempServer = !ServerAsset.isExistingServer(serverInfo);
            InstallLogUtils.getInstallLogger().log(Level.FINEST, serverName + (isTempServer ? " is " : " is not ") + " a temp server which serverInfo is " + serverInfo.getAbsolutePath());
            File serverXML = isTempServer ? EmbeddedServerLauncher.createTempServer(serverInfo, serverName) : serverInfo;
            InstallLogUtils.getInstallLogger().log(Level.FINEST, "serverXML of " + serverName + " is " + serverXML.getAbsolutePath());
            try {
                Collection<String> features = EmbeddedServerLauncher.launchServerInFeatureGatherMode(serverXML, serverName, isTempServer);
                if (null == features) {
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("UNABLE_TO_DETERMINE_FEATURES", serverName, ServerAsset.getServerLogsDirectoryPath(isTempServer ? serverXML.getParentFile() : Utils.getServerOutputDir((String)serverName))), 21);
                }
                if (isTempServer) {
                    InstallLogUtils.getInstallLogger().log(Level.FINEST, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_DELETING_TEMP_SERVER_DIR", serverXML.getParent()));
                    InstallUtils.deleteDirectory(serverXML.getParentFile().getParentFile().getParentFile());
                }
                return features;
            }
            catch (InstallException inste) {
                if (isTempServer) {
                    InstallLogUtils.getInstallLogger().log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_NOT_DELETING_TEMP_SERVER_DIR", serverXML.getParent(), serverXML.getParentFile().getParent()));
                }
                throw inste;
            }
        }

        private static File createTempServer(File serverXML, String serverName) throws InstallException {
            File tmpdir = new File(AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("java.io.tmpdir");
                }
            }));
            File tempWLPDir = new File(tmpdir, "tmpwlp");
            int i = 0;
            while (tempWLPDir.exists()) {
                tempWLPDir = new File(tmpdir, "tmpwlp_" + i);
                ++i;
            }
            File tempServDir = new File(tempWLPDir, "servers" + File.separator + serverName);
            try {
                if (!tempServDir.mkdirs()) {
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_CREATING_TEMP_SERVER_DIR", tempServDir.getAbsolutePath(), tmpdir.getAbsolutePath()), 25);
                }
                InstallLogUtils.getInstallLogger().log(Level.FINEST, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_CREATED_TEMP_SERVER_DIR", tempServDir.getAbsolutePath()));
            }
            catch (SecurityException se) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_CREATING_DIR", tempServDir.getAbsolutePath(), se.getMessage()), se, 25);
            }
            File destServerXML = new File(tempServDir, "server.xml");
            try {
                InstallUtils.copyFile(serverXML, destServerXML);
            }
            catch (IOException ioe) {
                InstallUtils.deleteDirectory(tempWLPDir);
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_COPYING_FILE", serverXML.getAbsolutePath(), tempServDir.getAbsolutePath()), ioe, 25);
            }
            return destServerXML;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Collection<String> launchServerInFeatureGatherMode(File serverXML, String serverName, boolean isTempServer) throws InstallException {
            PrintStream stdOut = System.out;
            PrintStream stdErr = System.err;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos, true);
            System.setOut(ps);
            System.setErr(ps);
            try {
                Set set;
                HashMap<String, String> serverProps = new HashMap<String, String>();
                serverProps.put("com.ibm.ws.liberty.feature.request", "1.0.0");
                EmbeddedServerImpl server = EmbeddedServerLauncher.startServer(serverXML, serverName, serverProps, isTempServer);
                try {
                    set = server.getServerFeatures();
                }
                catch (Throwable throwable) {
                    EmbeddedServerLauncher.stopServer(server, serverXML, serverName, isTempServer);
                    throw throwable;
                }
                EmbeddedServerLauncher.stopServer(server, serverXML, serverName, isTempServer);
                return set;
            }
            finally {
                System.out.flush();
                System.err.flush();
                System.setOut(stdOut);
                System.setErr(stdErr);
                if (baos.size() > 0) {
                    InstallLogUtils.getInstallLogger().log(Level.FINEST, baos.toString());
                }
                InstallUtils.close(ps);
            }
        }

        private static EmbeddedServerImpl startServer(File serverXML, String serverName, Map<String, String> serverProps, boolean isTempServer) throws InstallException {
            EmbeddedServerLauncher.validateFile(serverXML);
            ServerBuilder sb = new ServerBuilder().setName(serverName);
            if (isTempServer) {
                sb.setOutputDir(serverXML.getParentFile().getParentFile());
            } else {
                sb.setOutputDir(Utils.getOutputDir());
                InstallLogUtils.getInstallLogger().log(Level.FINEST, "Set output dir to " + Utils.getOutputDir());
                sb.setLogDir(Utils.getLogDir());
                InstallLogUtils.getInstallLogger().log(Level.FINEST, "Set log dir to " + (Utils.getLogDir() != null ? Utils.getLogDir() : Utils.getOutputDir()));
            }
            sb.setUserDir(serverXML.getParentFile().getParentFile().getParentFile());
            EmbeddedServerImpl server = (EmbeddedServerImpl)sb.build();
            if (server.isRunning()) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_TO_GET_FEATURES_FROM_RUNNING_SERVER", serverName), 21);
            }
            Future launchFuture = server.start(serverProps, new String[0]);
            try {
                Server.Result rc = (Server.Result)launchFuture.get(10L, TimeUnit.MINUTES);
                if (rc == null || !rc.successful()) {
                    if (rc != null && rc.getException() != null) {
                        ServerException e = rc.getException();
                        throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("EXCEPTION_STARTING_SERVER", serverName, e.getMessage()), (Throwable)e, rc.getReturnCode());
                    }
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("UNABLE_TO_STOP_START_SERVER", serverName, ServerAsset.getServerLogsDirectoryPath(isTempServer ? serverXML.getParentFile() : Utils.getServerOutputDir((String)serverName))), 21);
                }
            }
            catch (TimeoutException to) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("EXCEPTION_STARTING_SERVER", serverName, to.getMessage()), to, 21);
            }
            catch (InterruptedException inte) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("EXCEPTION_STARTING_SERVER", serverName, inte.getMessage()), inte, 21);
            }
            catch (ExecutionException ee) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("EXCEPTION_STARTING_SERVER", serverName, ee.getMessage()), ee, 21);
            }
            return server;
        }

        private static void stopServer(EmbeddedServerImpl server, File serverXML, String serverName, boolean isTempServer) throws InstallException {
            Future stopFuture = server.stop(new String[0]);
            try {
                Server.Result rc = (Server.Result)stopFuture.get(60L, TimeUnit.SECONDS);
                if (rc == null || !rc.successful() && rc.getReturnCode() != ReturnCode.REDUNDANT_ACTION_STATUS.getValue()) {
                    if (rc != null && rc.getException() != null) {
                        ServerException e = rc.getException();
                        throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("EXCEPTION_STOPPING_SERVER", serverName, e.getMessage()), (Throwable)e, rc.getReturnCode());
                    }
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("UNABLE_TO_STOP_START_SERVER", serverName, ServerAsset.getServerLogsDirectoryPath(isTempServer ? serverXML.getParentFile() : Utils.getServerOutputDir((String)serverName))), 21);
                }
            }
            catch (TimeoutException to) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("EXCEPTION_STOPPING_SERVER", serverName, to.getMessage()), to, 21);
            }
            catch (InterruptedException inte) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("EXCEPTION_STOPPING_SERVER", serverName, inte.getMessage()), inte, 21);
            }
            catch (ExecutionException ee) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("EXCEPTION_STOPPING_SERVER", serverName, ee.getMessage()), ee, 21);
            }
        }

        private static void validateFile(File serverXMLFile) throws InstallException {
            if (null == serverXMLFile) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_TO_FIND_SERVER_XML", "null"));
            }
            if (!serverXMLFile.isFile()) {
                String serverDir;
                String string = serverDir = "server.xml".equalsIgnoreCase(serverXMLFile.getName()) ? serverXMLFile.getParent() : serverXMLFile.getAbsolutePath();
                if (null == serverDir) {
                    serverDir = "";
                }
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_TO_FIND_SERVER_XML", serverDir));
            }
        }
    }
}

