/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.impl.LongAdderAdapter;
import com.ibm.ws.microprofile.metrics.impl.LongAdderProxy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EWMA {
    private static final int INTERVAL = 5;
    private static final double SECONDS_PER_MINUTE = 60.0;
    private static final int ONE_MINUTE = 1;
    private static final int FIVE_MINUTES = 5;
    private static final int FIFTEEN_MINUTES = 15;
    private static final double M1_ALPHA;
    private static final double M5_ALPHA;
    private static final double M15_ALPHA;
    private volatile boolean initialized = false;
    private volatile double rate = 0.0;
    private final LongAdderAdapter uncounted = LongAdderProxy.create();
    private final double alpha;
    private final double interval;
    static final long serialVersionUID = -5378368957978174742L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static EWMA oneMinuteEWMA() {
        return new EWMA(M1_ALPHA, 5L, TimeUnit.SECONDS);
    }

    public static EWMA fiveMinuteEWMA() {
        return new EWMA(M5_ALPHA, 5L, TimeUnit.SECONDS);
    }

    public static EWMA fifteenMinuteEWMA() {
        return new EWMA(M15_ALPHA, 5L, TimeUnit.SECONDS);
    }

    public EWMA(double alpha, long interval, TimeUnit intervalUnit) {
        this.interval = intervalUnit.toNanos(interval);
        this.alpha = alpha;
    }

    public void update(long n) {
        this.uncounted.add(n);
    }

    public void tick() {
        long count = this.uncounted.sumThenReset();
        double instantRate = (double)count / this.interval;
        if (this.initialized) {
            this.rate += this.alpha * (instantRate - this.rate);
        } else {
            this.rate = instantRate;
            this.initialized = true;
        }
    }

    public double getRate(TimeUnit rateUnit) {
        return this.rate * (double)rateUnit.toNanos(1L);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(EWMA.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        M1_ALPHA = 1.0 - Math.exp(-0.08333333333333333);
        M5_ALPHA = 1.0 - Math.exp(-0.016666666666666666);
        M15_ALPHA = 1.0 - Math.exp(-0.005555555555555555);
    }
}

