/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.jaxws.support.JaxWsInstanceManager;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.jaxws.support.ReferenceContextInjectionInstanceInterceptor;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionMetaData;
import com.ibm.wsspi.injectionengine.InjectionMetaDataListener;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxWsInjectionMetaDataListener
implements InjectionMetaDataListener {
    private static final TraceComponent tc = Tr.register(JaxWsInjectionMetaDataListener.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    static final long serialVersionUID = 1217934967759622434L;

    /*
     * WARNING - void declaration
     */
    public void injectionMetaDataCreated(InjectionMetaData injectionMetaData) throws InjectionException {
        if (injectionMetaData == null) {
            return;
        }
        ModuleMetaData mmd = injectionMetaData.getModuleMetaData();
        if (mmd == null) {
            return;
        }
        JaxWsModuleMetaData jaxWsmoduleMetaData = JaxWsMetaDataManager.getJaxWsModuleMetaData(mmd);
        if (jaxWsmoduleMetaData == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unsupported Module, no JaxWsModuleMetaData is created for " + mmd.getName() + ", Injection Processing for web service is ignored"), (Object[])new Object[0]);
            }
            return;
        }
        if (!jaxWsmoduleMetaData.getJ2EEName().equals(mmd.getJ2EEName())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Not main module for the JaxWsModuleMetaData {0} or the jaxWsModuleMetaData has been initialized, Injection Processing for web service is ignored", (Object[])new Object[]{mmd.getName()});
            }
            return;
        }
        List injectionClasses = injectionMetaData.getComponentNameSpaceConfiguration().getInjectionClasses();
        if (injectionClasses != null) {
            for (Class clazz : injectionClasses) {
                jaxWsmoduleMetaData.setReferenceContext(clazz, injectionMetaData.getReferenceContext());
            }
        }
        try {
            JaxWsInstanceManager.InstanceInterceptor interceptor;
            if (JaxWsUtils.isEJBModule(jaxWsmoduleMetaData.getModuleContainer()) && (interceptor = jaxWsmoduleMetaData.getJaxWsInstanceManager().getInterceptor(ReferenceContextInjectionInstanceInterceptor.class.getName())) == null) {
                jaxWsmoduleMetaData.getJaxWsInstanceManager().addInterceptor(new ReferenceContextInjectionInstanceInterceptor(jaxWsmoduleMetaData.getReferenceContextMap()));
            }
        }
        catch (UnableToAdaptException interceptor) {
            void e;
            FFDCFilter.processException((Throwable)interceptor, (String)"com.ibm.ws.jaxws.support.JaxWsInjectionMetaDataListener", (String)"80", (Object)this, (Object[])new Object[]{injectionMetaData});
            throw new InjectionException((Throwable)e);
        }
    }
}

